/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.karaf.features.FeaturePattern;
import org.apache.karaf.features.LocationPattern;
import org.apache.karaf.features.internal.model.Features;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blacklist {
    public static Logger LOG = LoggerFactory.getLogger(Blacklist.class);
    public static final String BLACKLIST_URL = "url";
    public static final String BLACKLIST_TYPE = "type";
    public static final String TYPE_FEATURE = "feature";
    public static final String TYPE_BUNDLE = "bundle";
    public static final String TYPE_REPOSITORY = "repository";
    private static final Logger LOGGER = LoggerFactory.getLogger(Blacklist.class);
    private Clause[] clauses;
    private List<LocationPattern> repositoryBlacklist = new LinkedList<LocationPattern>();
    private List<FeaturePattern> featureBlacklist = new LinkedList<FeaturePattern>();
    private List<LocationPattern> bundleBlacklist = new LinkedList<LocationPattern>();

    public Blacklist() {
        this(Collections.emptyList());
    }

    public Blacklist(List<String> blacklist) {
        this.clauses = Parser.parseClauses(blacklist.toArray(new String[blacklist.size()]));
        this.compileClauses();
    }

    public Blacklist(String blacklistUrl) {
        HashSet blacklist = new HashSet();
        if (blacklistUrl != null) {
            try (InputStream is = new URL(blacklistUrl).openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                reader.lines().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).forEach(blacklist::add);
            }
            catch (FileNotFoundException e) {
                LOGGER.debug("Unable to load blacklist bundles list", (Object)e.toString());
            }
            catch (Exception e) {
                LOGGER.debug("Unable to load blacklist bundles list", (Throwable)e);
            }
        }
        this.clauses = Parser.parseClauses(blacklist.toArray(new String[blacklist.size()]));
        this.compileClauses();
    }

    private void compileClauses() {
        block16: for (Clause c : this.clauses) {
            String type = c.getAttribute(BLACKLIST_TYPE);
            if (type == null) {
                String url = c.getAttribute(BLACKLIST_URL);
                type = url != null || c.getName().startsWith("mvn:") ? TYPE_BUNDLE : TYPE_FEATURE;
            }
            switch (type) {
                case "repository": {
                    String location = c.getName();
                    if (c.getAttribute(BLACKLIST_URL) != null) {
                        location = c.getAttribute(BLACKLIST_URL);
                    }
                    if (location == null) {
                        LOG.warn("Repository blacklist URI is empty. Ignoring.");
                        continue block16;
                    }
                    try {
                        this.repositoryBlacklist.add(new LocationPattern(location));
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Problem parsing repository blacklist URI \"" + location + "\": " + e.getMessage() + ". Ignoring.");
                    }
                    continue block16;
                }
                case "feature": {
                    try {
                        this.featureBlacklist.add(new FeaturePattern(c.toString()));
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Problem parsing blacklisted feature identifier \"" + c.toString() + "\": " + e.getMessage() + ". Ignoring.");
                    }
                    continue block16;
                }
                case "bundle": {
                    String location = c.getName();
                    if (c.getAttribute(BLACKLIST_URL) != null) {
                        location = c.getAttribute(BLACKLIST_URL);
                    }
                    if (location == null) {
                        LOG.warn("Bundle blacklist URI is empty. Ignoring.");
                        continue block16;
                    }
                    try {
                        this.bundleBlacklist.add(new LocationPattern(location));
                        continue block16;
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Problem parsing bundle blacklist URI \"" + location + "\": " + e.getMessage() + ". Ignoring.");
                    }
                }
            }
        }
    }

    public boolean isRepositoryBlacklisted(String uri) {
        for (LocationPattern pattern : this.repositoryBlacklist) {
            if (!pattern.matches(uri)) continue;
            return true;
        }
        return false;
    }

    public boolean isFeatureBlacklisted(String name, String version) {
        for (FeaturePattern pattern : this.featureBlacklist) {
            if (!pattern.matches(name, version)) continue;
            return true;
        }
        return false;
    }

    public boolean isBundleBlacklisted(String uri) {
        for (LocationPattern pattern : this.bundleBlacklist) {
            if (!pattern.matches(uri)) continue;
            return true;
        }
        return false;
    }

    public void merge(Blacklist others) {
        Clause[] ours = this.clauses;
        if (ours == null) {
            this.clauses = Arrays.copyOf(others.clauses, others.clauses.length);
        } else if (others != null && others.clauses.length > 0) {
            this.clauses = new Clause[ours.length + others.clauses.length];
            System.arraycopy(ours, 0, this.clauses, 0, ours.length);
            System.arraycopy(others.clauses, ours.length, this.clauses, 0, others.clauses.length);
        }
        if (others != null) {
            this.repositoryBlacklist.addAll(others.repositoryBlacklist);
            this.featureBlacklist.addAll(others.featureBlacklist);
            this.bundleBlacklist.addAll(others.bundleBlacklist);
        }
    }

    public Clause[] getClauses() {
        return this.clauses;
    }

    public void blacklist(Features featuresModel) {
    }

    public void blacklistRepository(LocationPattern locationPattern) {
        this.repositoryBlacklist.add(locationPattern);
    }

    public void blacklistFeature(FeaturePattern featurePattern) {
        this.featureBlacklist.add(featurePattern);
    }

    public void blacklistBundle(LocationPattern locationPattern) {
        this.bundleBlacklist.add(locationPattern);
    }

    public List<LocationPattern> getRepositoryBlacklist() {
        return this.repositoryBlacklist;
    }

    public List<FeaturePattern> getFeatureBlacklist() {
        return this.featureBlacklist;
    }

    public List<LocationPattern> getBundleBlacklist() {
        return this.bundleBlacklist;
    }
}

