/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.transform;

import com.google.common.base.Predicates;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.EntityAdjuncts;
import org.apache.brooklyn.rest.api.AdjunctApi;
import org.apache.brooklyn.rest.domain.AdjunctDetail;
import org.apache.brooklyn.rest.domain.AdjunctSummary;
import org.apache.brooklyn.rest.domain.Status;
import org.apache.brooklyn.rest.transform.ApplicationTransformer;
import org.apache.brooklyn.rest.transform.ConfigTransformer;
import org.apache.brooklyn.rest.transform.EntityTransformer;
import org.apache.brooklyn.rest.util.BrooklynRestResourceUtils;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableMap;

public class AdjunctTransformer {
    public static AdjunctSummary adjunctSummary(Entity entity, EntityAdjunct adjunct, UriBuilder ub, BrooklynRestResourceUtils brooklynU) {
        return AdjunctTransformer.embellish(new AdjunctSummary(adjunct), entity, adjunct, ub, brooklynU);
    }

    private static <T extends AdjunctSummary> T embellish(T adjunctSummary, Entity entity, EntityAdjunct adjunct, UriBuilder ub, BrooklynRestResourceUtils brooklynU) {
        if (adjunctSummary.getIconUrl() != null && brooklynU.isUrlServerSideAndSafe(adjunctSummary.getIconUrl())) {
            adjunctSummary.iconUrl(AdjunctTransformer.adjunctUri(entity, adjunct, ub) + "/icon");
        }
        return (T)adjunctSummary.state(AdjunctTransformer.inferStatus(adjunct)).links(AdjunctTransformer.buildLinks(entity, adjunct, ub, adjunctSummary instanceof AdjunctDetail));
    }

    public static AdjunctDetail adjunctDetail(Entity entity, EntityAdjunct adjunct, UriBuilder ub, BrooklynRestResourceUtils utils) {
        AdjunctDetail result = AdjunctTransformer.embellish(new AdjunctDetail(adjunct), entity, adjunct, ub, utils);
        for (ConfigKey key : adjunct.config().findKeysDeclared(Predicates.alwaysTrue())) {
            result.parameter(ConfigTransformer.of(key).on(entity, adjunct).includeLinks(ub, false, true).transform());
        }
        result.config(EntityTransformer.getConfigValues(utils, (BrooklynObject)adjunct));
        return result;
    }

    protected static Map<String, URI> buildLinks(Entity entity, EntityAdjunct adjunct, UriBuilder ub, boolean detail) {
        MutableMap links = MutableMap.of();
        links.put((Object)"self", (Object)WebResourceUtils.serviceUriBuilder(ub, AdjunctApi.class, "get").build(new Object[]{entity.getApplicationId(), entity.getId(), adjunct.getId()}));
        if (detail) {
            links.put((Object)"application", (Object)EntityTransformer.applicationUri(entity.getApplication(), ub));
            links.put((Object)"entity", (Object)EntityTransformer.entityUri(entity, ub));
            links.put((Object)"adjunct", (Object)AdjunctTransformer.adjunctUri(entity, adjunct, ub));
            links.put((Object)"config", (Object)WebResourceUtils.serviceUriBuilder(ub, AdjunctApi.class, "listConfig").build(new Object[]{entity.getApplicationId(), entity.getId(), adjunct.getId()}));
            links.put((Object)"status", (Object)WebResourceUtils.serviceUriBuilder(ub, AdjunctApi.class, "getStatus").build(new Object[]{entity.getApplicationId(), entity.getId(), adjunct.getId()}));
            if (adjunct instanceof Policy || adjunct instanceof Feed) {
                links.put((Object)"start", (Object)WebResourceUtils.serviceUriBuilder(ub, AdjunctApi.class, "start").build(new Object[]{entity.getApplicationId(), entity.getId(), adjunct.getId()}));
                links.put((Object)"stop", (Object)WebResourceUtils.serviceUriBuilder(ub, AdjunctApi.class, "stop").build(new Object[]{entity.getApplicationId(), entity.getId(), adjunct.getId()}));
            }
            links.put((Object)"destroy", (Object)WebResourceUtils.serviceUriBuilder(ub, AdjunctApi.class, "destroy").build(new Object[]{entity.getApplicationId(), entity.getId(), adjunct.getId()}));
        }
        return links.asUnmodifiable();
    }

    public static Status inferStatus(EntityAdjunct adjunct) {
        return ApplicationTransformer.statusFromLifecycle(EntityAdjuncts.inferAdjunctStatus((EntityAdjunct)adjunct));
    }

    public static URI adjunctUri(Entity entity, EntityAdjunct adjunct, UriBuilder ub) {
        return WebResourceUtils.serviceUriBuilder(ub, AdjunctApi.class, "get").build(new Object[]{entity.getApplicationId(), entity.getId(), adjunct.getId()});
    }
}

