/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.handlers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.jclouds.gogrid.GoGridResponseException;
import org.jclouds.gogrid.domain.internal.ErrorResponse;
import org.jclouds.gogrid.functions.GenericResponseContainer;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;

public class GoGridErrorHandler
implements HttpErrorHandler {
    private final ParseJson<GenericResponseContainer<ErrorResponse>> errorParser;

    @Inject
    public GoGridErrorHandler(ParseJson<GenericResponseContainer<ErrorResponse>> errorParser) {
        this.errorParser = errorParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        try {
            byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
            String message = data != null ? new String(data) : null;
            HttpResponseException exception = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
            Set<ErrorResponse> errors = this.parseErrorsFromContentOrNull(data);
            if (errors != null) {
                exception = new GoGridResponseException(command, response, errors);
            }
            switch (response.getStatusCode()) {
                case 400: {
                    if (((ErrorResponse)Iterables.get(errors, (int)0)).getMessage().indexOf("No object found") == -1) break;
                    exception = new ResourceNotFoundException(((ErrorResponse)Iterables.get(errors, (int)0)).getMessage(), (Throwable)exception);
                    break;
                }
                case 403: {
                    exception = new AuthorizationException(exception.getMessage(), (Throwable)exception);
                }
            }
            command.setException((Exception)exception);
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
        }
    }

    Set<ErrorResponse> parseErrorsFromContentOrNull(byte[] response) {
        if (response != null) {
            try {
                return ((GenericResponseContainer)this.errorParser.apply((InputStream)new ByteArrayInputStream(response))).getList();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

