/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.entity;

import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.persist.DeserializingClassRenamesProvider;
import org.apache.brooklyn.core.resolve.entity.AbstractEntitySpecResolver;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;

public class JavaEntitySpecResolver
extends AbstractEntitySpecResolver {
    private static final String RESOLVER_NAME = "java";

    public JavaEntitySpecResolver() {
        super(RESOLVER_NAME);
    }

    @Override
    protected String getLocalType(String type) {
        type = super.getLocalType(type);
        type = DeserializingClassRenamesProvider.INSTANCE.findMappedName(type);
        return type;
    }

    @Override
    protected boolean canResolve(String type, BrooklynClassLoadingContext loader) {
        String localType = this.getLocalType(type);
        Maybe<Class<? extends Entity>> javaType = this.tryLoadJavaType(localType, loader);
        return javaType.isPresent();
    }

    @Override
    public EntitySpec<?> resolve(String type, BrooklynClassLoadingContext loader, Set<String> encounteredTypes) {
        String localType = this.getLocalType(type);
        try {
            return this.resolveInternal(localType, loader);
        }
        catch (Exception e) {
            boolean recursiveButTryJava;
            boolean firstOccurrence = encounteredTypes.add(localType);
            boolean bl = recursiveButTryJava = !firstOccurrence;
            if (recursiveButTryJava) {
                throw new IllegalStateException("Recursive reference to " + localType + " (and cannot be resolved as a Java type)", e);
            }
            throw e;
        }
    }

    private EntitySpec<?> resolveInternal(String localType, BrooklynClassLoadingContext loader) {
        EntitySpec spec;
        Maybe<Class<? extends Entity>> javaTypeMaybe = this.tryLoadJavaType(localType, loader);
        if (javaTypeMaybe.isAbsent()) {
            throw new IllegalStateException("Could not find " + localType, Maybe.getException(javaTypeMaybe));
        }
        Class javaType = (Class)javaTypeMaybe.get();
        if (javaType.isInterface()) {
            spec = EntitySpec.create((Class)javaType);
        } else {
            EntitySpec rawSpec;
            Class interfaceclazz = Application.class.isAssignableFrom(javaType) ? Application.class : Entity.class;
            List additionalInterfaceClazzes = Reflections.getAllInterfaces((Class)javaType);
            spec = rawSpec = EntitySpec.create(interfaceclazz).impl(javaType).additionalInterfaces((Iterable)additionalInterfaceClazzes);
        }
        spec.stackCatalogItemId(CatalogUtils.getCatalogItemIdFromLoader(loader));
        return spec;
    }

    private Maybe<Class<? extends Entity>> tryLoadJavaType(String localType, BrooklynClassLoadingContext loader) {
        return loader.tryLoadClass(localType, Entity.class);
    }
}

