/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.Map;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassRenamingMapper
extends MapperWrapper {
    public static final Logger LOG = LoggerFactory.getLogger(ClassRenamingMapper.class);
    private final Map<String, String> nameToType;
    private final Supplier<? extends ClassLoader> classLoaderSupplier;

    public ClassRenamingMapper(Mapper wrapped, Map<String, String> nameToType, Supplier<? extends ClassLoader> classLoaderSupplier) {
        super(wrapped);
        this.nameToType = (Map)Preconditions.checkNotNull(nameToType, (Object)"nameToType");
        this.classLoaderSupplier = (Supplier)Preconditions.checkNotNull(classLoaderSupplier, (Object)"classLoaderSupplier");
    }

    public Class<?> realClass(String elementName) {
        String elementNamOrig = elementName;
        Maybe elementNameOpt = Reflections.findMappedNameMaybe(this.nameToType, (String)elementName);
        if (elementNameOpt.isPresent()) {
            LOG.debug("Mapping class '" + elementName + "' to '" + (String)elementNameOpt.get() + "'");
            elementName = (String)elementNameOpt.get();
        }
        try {
            return super.realClass(elementName);
        }
        catch (Exception e) {
            PrefixAndClass prefixAndClass;
            Maybe classNameOpt;
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.trace("Failed to load class using super.realClass({}), for orig class {}, attempting fallbacks: {}", new Object[]{elementName, elementNamOrig, e});
            Exception tothrow = e;
            if (elementNameOpt.isPresent() && this.hasBundlePrefix(elementName)) {
                try {
                    return ((ClassLoader)this.classLoaderSupplier.get()).loadClass(elementName);
                }
                catch (ClassNotFoundException e2) {
                    LOG.trace("Fallback loadClass({}) attempt failed (orig class {}): {}", new Object[]{elementName, elementNamOrig, e2});
                }
            }
            if (this.hasBundlePrefix(elementNamOrig) && (classNameOpt = Reflections.findMappedNameMaybe(this.nameToType, (String)(prefixAndClass = this.splitBundlePrefix(elementNamOrig)).clazz)).isPresent()) {
                elementName = this.hasBundlePrefix((String)classNameOpt.get()) ? (String)classNameOpt.get() : this.joinBundlePrefix(prefixAndClass.prefix, (String)classNameOpt.get());
                LOG.debug("Mapping class '" + elementNamOrig + "' to '" + elementName + "'");
                try {
                    return super.realClass(elementName);
                }
                catch (CannotResolveClassException e3) {
                    LOG.trace("Fallback super.realClass({}) attempt failed (orig class {}): {}", new Object[]{elementName, elementNamOrig, e3});
                    try {
                        return ((ClassLoader)this.classLoaderSupplier.get()).loadClass(elementName);
                    }
                    catch (ClassNotFoundException e4) {
                        LOG.trace("Fallback loadClass({}) attempt failed (orig class {}): {}", new Object[]{elementName, elementNamOrig, e4});
                    }
                }
            }
            throw Exceptions.propagate((Throwable)tothrow);
        }
    }

    private boolean hasBundlePrefix(String type) {
        return type != null && type.contains(":");
    }

    private PrefixAndClass splitBundlePrefix(String type) {
        int index = type.lastIndexOf(":");
        if (index <= 0) {
            throw new IllegalStateException("'" + type + "' is not in a valid bundle:class format");
        }
        String prefix = type.substring(0, index);
        String clazz = type.substring(index + 1);
        return new PrefixAndClass(prefix, clazz);
    }

    private String joinBundlePrefix(String prefix, String clazz) {
        return (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix") + ":" + (String)Preconditions.checkNotNull((Object)clazz, (Object)"clazz");
    }

    private static class PrefixAndClass {
        private final String prefix;
        private final String clazz;

        public PrefixAndClass(String prefix, String clazz) {
            this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
            this.clazz = (String)Preconditions.checkNotNull((Object)clazz, (Object)"clazz");
        }
    }
}

