/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.helpers.LogLog;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.util.PaxPropertySource;
import org.ops4j.pax.logging.OSGIPaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManagerAwareLogger;
import org.ops4j.pax.logging.avalon.AvalonLogFactory;
import org.ops4j.pax.logging.internal.JdkHandler;
import org.ops4j.pax.logging.jbosslogging.PaxLoggingLoggerProvider;
import org.ops4j.pax.logging.log4jv2.Log4jv2LoggerContext;
import org.ops4j.pax.logging.slf4j.Slf4jLoggerFactory;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.DefaultServiceLog;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.ops4j.pax.logging.spi.support.FrameworkHandler;
import org.ops4j.pax.logging.spi.support.OsgiUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final Map<String, PaxLoggingManagerAwareLogger> m_loggers = new WeakHashMap<String, PaxLoggingManagerAwareLogger>();
    private PaxLoggingManager manager;
    private JdkHandler m_JdkHandler;
    private FrameworkHandler m_frameworkHandler;
    private BundleContext bundleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        String name = this.getClass().getName();
        this.manager = new OSGIPaxLoggingManager(bundleContext);
        String levelName = BackendSupport.defaultLogLevel(bundleContext);
        DefaultServiceLog.setLogLevel(levelName);
        LogLog.setInternalDebugging(DefaultServiceLog.getStaticLogLevel() <= 1);
        PaxPropertySource.debug = DefaultServiceLog.getStaticLogLevel() <= 1;
        PaxPropertySource.defaultLevel = levelName;
        if (!this.skipJulRegistration()) {
            java.util.logging.LogManager logManager = java.util.logging.LogManager.getLogManager();
            if (!this.skipJulReset()) {
                logManager.reset();
            }
            java.util.logging.Logger rootLogger = logManager.getLogger("");
            Handler[] handlers = rootLogger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                rootLogger.removeHandler(handlers[i]);
            }
            rootLogger.setFilter(null);
            this.m_JdkHandler = new JdkHandler(this.manager);
            rootLogger.addHandler(this.m_JdkHandler);
            rootLogger.setLevel(BackendSupport.toJULLevel(levelName));
            java.util.logging.Logger julLogger = java.util.logging.Logger.getLogger(name);
            julLogger.info("Enabling Java Util Logging API support.");
        }
        Slf4jLoggerFactory.setPaxLoggingManager(this.manager);
        Logger slf4jLogger = LoggerFactory.getLogger(name);
        slf4jLogger.info("Enabling SLF4J API support.");
        LogFactory.setPaxLoggingManager(this.manager);
        Log commonsLogger = LogFactory.getLog(name);
        commonsLogger.info("Enabling Apache Commons Logging API support.");
        org.apache.juli.logging.LogFactory.setPaxLoggingManager(this.manager);
        org.apache.juli.logging.Log juliLogger = org.apache.juli.logging.LogFactory.getLog(name);
        juliLogger.info("Enabling JULI Logger API support.");
        AvalonLogFactory.setPaxLoggingManager(this.manager);
        org.apache.avalon.framework.logger.Logger avalonLogger = AvalonLogFactory.getLogger(name);
        avalonLogger.info("Enabling Avalon Logger API support.");
        PaxLoggingLoggerProvider.setPaxLoggingManager(this.manager);
        org.jboss.logging.Logger jbossLoggingLogger = org.jboss.logging.Logger.getLogger(name);
        jbossLoggingLogger.info("Enabling JBoss Logging API support.");
        org.apache.log4j.Logger.configurePaxLoggingManager(this.manager);
        org.apache.log4j.Logger log4j1Logger = org.apache.log4j.Logger.getLogger(name);
        log4j1Logger.info("Enabling Log4J v1 API support.");
        Log4jv2LoggerContext.setPaxLoggingManager(this.manager);
        org.apache.logging.log4j.Logger log4j2Logger = LogManager.getLogger(name);
        log4j2Logger.info("Enabling Log4J v2 API support.");
        Map<String, PaxLoggingManagerAwareLogger> map = m_loggers;
        synchronized (map) {
            for (PaxLoggingManagerAwareLogger logger : m_loggers.values()) {
                logger.setPaxLoggingManager(this.manager);
            }
        }
        this.m_frameworkHandler = new FrameworkHandler(bundleContext, this.manager);
        bundleContext.addBundleListener((BundleListener)this.m_frameworkHandler);
        bundleContext.addFrameworkListener((FrameworkListener)this.m_frameworkHandler);
        bundleContext.addServiceListener((ServiceListener)this.m_frameworkHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        if (this.m_frameworkHandler != null) {
            bundleContext.removeBundleListener((BundleListener)this.m_frameworkHandler);
            bundleContext.removeFrameworkListener((FrameworkListener)this.m_frameworkHandler);
            bundleContext.removeServiceListener((ServiceListener)this.m_frameworkHandler);
        }
        String name = this.getClass().getName();
        Logger slf4jLogger = LoggerFactory.getLogger(name);
        slf4jLogger.info("Disabling SLF4J API support.");
        Slf4jLoggerFactory.setPaxLoggingManager(null);
        Log commonsLogger = LogFactory.getLog(name);
        commonsLogger.info("Disabling Apache Commons Logging API support.");
        LogFactory.setPaxLoggingManager(null);
        org.apache.juli.logging.Log juliLogger = org.apache.juli.logging.LogFactory.getLog(name);
        juliLogger.info("Disabling JULI Logger API support.");
        org.apache.juli.logging.LogFactory.setPaxLoggingManager(null);
        org.apache.avalon.framework.logger.Logger avalonLogger = AvalonLogFactory.getLogger(name);
        avalonLogger.info("Disabling Avalon Logger API support.");
        AvalonLogFactory.setPaxLoggingManager(null);
        org.jboss.logging.Logger jbossLoggingLogger = org.jboss.logging.Logger.getLogger(name);
        jbossLoggingLogger.info("Disabling JBoss Logging API support.");
        PaxLoggingLoggerProvider.setPaxLoggingManager(null);
        org.apache.log4j.Logger log4j1Logger = org.apache.log4j.Logger.getLogger(name);
        log4j1Logger.info("Disabling Log4J v1 API support.");
        org.apache.log4j.Logger.configurePaxLoggingManager(null);
        org.apache.logging.log4j.Logger log4j2Logger = LogManager.getLogger(this.getClass());
        log4j2Logger.info("Disabling Log4J v2 API support.");
        Log4jv2LoggerContext.setPaxLoggingManager(null);
        Map<String, PaxLoggingManagerAwareLogger> map = m_loggers;
        synchronized (map) {
            for (PaxLoggingManagerAwareLogger logger : m_loggers.values()) {
                logger.setPaxLoggingManager(null);
            }
        }
        if (this.m_JdkHandler != null) {
            java.util.logging.Logger julLogger = java.util.logging.Logger.getLogger(name);
            julLogger.info("Disabling Java Util Logging API support.");
            java.util.logging.Logger rootLogger = java.util.logging.LogManager.getLogManager().getLogger("");
            rootLogger.removeHandler(this.m_JdkHandler);
            this.m_JdkHandler.flush();
            this.m_JdkHandler.close();
            this.m_JdkHandler = null;
        }
        if (this.manager != null) {
            this.manager.dispose();
            this.manager.close();
        }
        FallbackLogFactory.cleanup();
    }

    private boolean skipJulRegistration() {
        String property = OsgiUtil.systemOrContextProperty(this.bundleContext, "org.ops4j.pax.logging.skipJUL");
        return Boolean.parseBoolean(property);
    }

    private boolean skipJulReset() {
        String property = OsgiUtil.systemOrContextProperty(this.bundleContext, "org.ops4j.pax.logging.skipJULReset");
        return Boolean.parseBoolean(property);
    }
}

