/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.location.Region;

public final class RegionToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Supplier<URI>>> regionToEndpoints;

    @Inject
    RegionToEndpoint(@Region Supplier<Map<String, Supplier<URI>>> regionToEndpoints) {
        this.regionToEndpoints = regionToEndpoints;
    }

    public URI apply(Object from) {
        Map regionToEndpoint = (Map)this.regionToEndpoints.get();
        Preconditions.checkState((!regionToEndpoint.isEmpty() ? 1 : 0) != 0, (Object)"no region name to endpoint mappings configured!");
        Preconditions.checkArgument((boolean)regionToEndpoint.containsKey(from), (String)"requested location %s, which is not a configured region: %s", (Object[])new Object[]{from, regionToEndpoint});
        return (URI)((Supplier)regionToEndpoint.get(from)).get();
    }
}

