/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.net.InetAddresses;
import javax.inject.Singleton;

public class InetAddresses2 {
    public static boolean isPrivateIPAddress(String in) {
        return IsPrivateIPAddress.INSTANCE.apply(in);
    }

    @Singleton
    public static enum IsPrivateIPAddress implements Predicate<String>
    {
        INSTANCE;


        public boolean apply(String in) {
            if (InetAddresses.isInetAddress((String)((String)Preconditions.checkNotNull((Object)in, (Object)"input address")))) {
                int second;
                if (in.indexOf("10.") == 0) {
                    return true;
                }
                if (in.indexOf("172.") == 0 && (second = Integer.parseInt((String)Iterables.get((Iterable)Splitter.on((char)'.').split((CharSequence)in), (int)1))) >= 16 && second <= 31) {
                    return true;
                }
                if (in.indexOf("192.168.") == 0) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "isPrivateIPAddress()";
        }
    }
}

