/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.concurrent;

import com.google.common.annotations.Beta;
import java.util.concurrent.Callable;

@Beta
public class CallableFromRunnable<T>
implements Callable<T> {
    private final Runnable task;
    private final T result;

    public static <T> CallableFromRunnable<T> newInstance(Runnable task, T result) {
        return new CallableFromRunnable<T>(task, result);
    }

    protected CallableFromRunnable(Runnable task, T result) {
        this.task = task;
        this.result = result;
    }

    @Override
    public T call() {
        this.task.run();
        return this.result;
    }

    public String toString() {
        if (this.result != null) {
            return "CallableFromRunnable[" + this.task + (this.result != null ? "->" + this.result : "") + "]";
        }
        return "" + this.task;
    }
}

