/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.mysql;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.entity.database.mysql.MySqlDriver;
import org.apache.brooklyn.entity.database.mysql.MySqlNode;
import org.apache.brooklyn.entity.database.mysql.MySqlNodeImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;

public class MySqlNodeEffectors {
    public static Effector<Void> EXPORT_DUMP = Effectors.effector(MySqlNode.ExportDumpEffector.EXPORT_DUMP).impl((EffectorBody)new ExportDumpEffectoryBody()).build();
    public static Effector<Void> IMPORT_DUMP = Effectors.effector(MySqlNode.ImportDumpEffector.IMPORT_DUMP).impl((EffectorBody)new ImportDumpEffectorBody()).build();
    public static Effector<Void> CHANGE_PASSWORD = Effectors.effector(MySqlNode.ChangePasswordEffector.CHANGE_PASSWORD).impl((EffectorBody)new ChangePasswordEffectorBody()).build();

    public static class ChangePasswordEffectorBody
    extends EffectorBody<Void>
    implements MySqlNode.ChangePasswordEffector {
        public Void call(ConfigBag parameters) {
            String newPass = (String)Preconditions.checkNotNull((Object)parameters.get(PASSWORD), (Object)"password is required");
            String oldPass = (String)this.entity().getAttribute((AttributeSensor)MySqlNode.PASSWORD);
            this.entity().sensors().set((AttributeSensor)MySqlNode.PASSWORD, (Object)newPass);
            MySqlDriver driver = ((MySqlNodeImpl)this.entity()).getDriver();
            driver.changePassword(oldPass, newPass);
            SshMachineLocation machine = EffectorTasks.getSshMachine((Entity)this.entity());
            DynamicTasks.queue((TaskFactory)SshTasks.newSshExecTaskFactory((SshMachineLocation)machine, (String[])new String[]{"cd " + (String)this.entity().getAttribute((AttributeSensor)MySqlNode.RUN_DIR), "sed -i'' -e 's@^\\(\\s*password\\s*=\\s*\\).*$@\\1" + newPass.replace("\\", "\\\\") + "@g' mymysql.cnf"}).requiringExitCodeZero().summary("Change root password"));
            return null;
        }
    }

    public static class ImportDumpEffectorBody
    extends EffectorBody<Void>
    implements MySqlNode.ImportDumpEffector {
        public Void call(ConfigBag parameters) {
            String path = (String)Preconditions.checkNotNull((Object)parameters.get(PATH), (Object)"path is required");
            ((MySqlNodeImpl)this.entity()).getDriver().executeScriptFromInstalledFileAsync(path);
            return null;
        }
    }

    public static class ExportDumpEffectoryBody
    extends EffectorBody<Void>
    implements MySqlNode.ExportDumpEffector {
        public Void call(ConfigBag parameters) {
            String path = (String)parameters.get(PATH);
            String additionalOptions = Strings.nullToEmpty((String)((String)parameters.get(ADDITIONAL_OPTIONS)));
            ((MySqlNodeImpl)this.entity()).getDriver().dumpDatabase(additionalOptions, path);
            return null;
        }
    }
}

