/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.rubyrep;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.entity.database.rubyrep.RubyRepDriver;
import org.apache.brooklyn.entity.database.rubyrep.RubyRepNode;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubyRepSshDriver
extends AbstractSoftwareProcessSshDriver
implements RubyRepDriver {
    public static final Logger log = LoggerFactory.getLogger(RubyRepSshDriver.class);

    public RubyRepSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
        entity.sensors().set(Attributes.LOG_FILE_LOCATION, (Object)this.getLogFileLocation());
    }

    protected String getLogFileLocation() {
        return Os.mergePaths((String[])new String[]{this.getRunDir(), "log", "rubyrep.log"});
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList commands = ImmutableList.builder().addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)BashCommands.INSTALL_UNZIP).add((Object)("unzip " + saveAs)).build();
        this.newScript((String)"installing").body.append((Collection)commands).failOnNonZeroResultCode().execute();
    }

    public void customize() {
        this.newScript((String)"customizing").body.append((CharSequence)String.format("cp -R %s %s", this.getExpandedInstallDir(), this.getRunDir())).failOnNonZeroResultCode().execute();
        try {
            this.customizeConfiguration();
        }
        catch (Exception e) {
            log.error("Failed to configure rubyrep, replication is unlikely to succeed", (Throwable)e);
        }
    }

    protected void customizeConfiguration() throws ExecutionException, InterruptedException, URISyntaxException {
        Reader configContents;
        log.info("Copying creation script " + this.getEntity().toString());
        String configScriptUrl = (String)this.entity.getConfig(RubyRepNode.CONFIGURATION_SCRIPT_URL);
        if (configScriptUrl != null) {
            configContents = Streams.reader((InputStream)this.resource.getResourceFromUrl(configScriptUrl));
        } else {
            String configScriptContents = this.processTemplate((String)this.entity.getConfig(RubyRepNode.TEMPLATE_CONFIGURATION_URL));
            configContents = Streams.newReaderWithContents((String)configScriptContents);
        }
        this.getMachine().copyTo(configContents, this.getRunDir() + "/rubyrep.conf");
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").body.append((CharSequence)String.format("nohup rubyrep-%s/jruby/bin/jruby rubyrep-%s/bin/rubyrep replicate -c rubyrep.conf > ./console 2>&1 &", this.getVersion(), this.getVersion())).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "stopping").execute();
    }
}

