/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.hash.HashCode;
import com.google.common.io.BaseEncoding;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.googlecloudstorage.domain.GoogleCloudStorageObject;
import org.jclouds.javax.annotation.Nullable;

public class ObjectToBlobMetadata
implements Function<GoogleCloudStorageObject, MutableBlobMetadata> {
    public MutableBlobMetadata apply(GoogleCloudStorageObject from) {
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        to.getContentMetadata().setContentMD5(ObjectToBlobMetadata.toHashCode(from.md5Hash()));
        to.getContentMetadata().setContentType(from.contentType());
        to.getContentMetadata().setContentDisposition(from.contentDisposition());
        to.getContentMetadata().setContentEncoding(from.contentEncoding());
        to.getContentMetadata().setContentLanguage(from.contentLanguage());
        to.getContentMetadata().setContentLength(Long.valueOf(from.size()));
        to.setLastModified(from.updated());
        to.setContainer(from.bucket());
        to.setUserMetadata(from.metadata());
        to.setETag(from.etag());
        to.setName(from.name());
        to.setUri(from.selfLink());
        to.setId(from.id());
        to.setPublicUri(from.mediaLink());
        to.setType((Enum)StorageType.BLOB);
        to.setSize(Long.valueOf(from.size()));
        to.setTier(from.storageClass().toTier());
        return to;
    }

    private static HashCode toHashCode(@Nullable String hashCode) {
        return hashCode == null ? null : HashCode.fromBytes((byte[])BaseEncoding.base64().decode((CharSequence)hashCode));
    }
}

