/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class Domain
implements Comparable<Domain> {
    private final String id;
    private final boolean hasChild;
    private final long level;
    private final String name;
    private final String networkDomain;
    private final String parentDomainId;
    private final String parentDomainName;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromDomain(this);
    }

    @ConstructorProperties(value={"id", "haschild", "level", "name", "networkdomain", "parentdomainid", "parentdomainname"})
    protected Domain(String id, boolean hasChild, long level, @Nullable String name, @Nullable String networkDomain, @Nullable String parentDomainId, @Nullable String parentDomainName) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.hasChild = hasChild;
        this.level = level;
        this.name = name;
        this.networkDomain = networkDomain;
        this.parentDomainId = parentDomainId;
        this.parentDomainName = parentDomainName;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasChild() {
        return this.hasChild;
    }

    public long getLevel() {
        return this.level;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getNetworkDomain() {
        return this.networkDomain;
    }

    @Nullable
    public String getParentDomainId() {
        return this.parentDomainId;
    }

    @Nullable
    public String getParentDomainName() {
        return this.parentDomainName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.hasChild, this.level, this.name, this.networkDomain, this.parentDomainId, this.parentDomainName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Domain that = (Domain)Domain.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.hasChild, (Object)that.hasChild) && Objects.equal((Object)this.level, (Object)that.level) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.networkDomain, (Object)that.networkDomain) && Objects.equal((Object)this.parentDomainId, (Object)that.parentDomainId) && Objects.equal((Object)this.parentDomainName, (Object)that.parentDomainName);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("hasChild", this.hasChild).add("level", this.level).add("name", (Object)this.name).add("networkDomain", (Object)this.networkDomain).add("parentDomainId", (Object)this.parentDomainId).add("parentDomainName", (Object)this.parentDomainName);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Domain other) {
        return this.id.compareTo(other.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected boolean hasChild;
        protected long level;
        protected String name;
        protected String networkDomain;
        protected String parentDomainId;
        protected String parentDomainName;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T hasChild(boolean hasChild) {
            this.hasChild = hasChild;
            return this.self();
        }

        public T level(long level) {
            this.level = level;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T networkDomain(String networkDomain) {
            this.networkDomain = networkDomain;
            return this.self();
        }

        public T parentDomainId(String parentDomainId) {
            this.parentDomainId = parentDomainId;
            return this.self();
        }

        public T parentDomainName(String parentDomainName) {
            this.parentDomainName = parentDomainName;
            return this.self();
        }

        public Domain build() {
            return new Domain(this.id, this.hasChild, this.level, this.name, this.networkDomain, this.parentDomainId, this.parentDomainName);
        }

        public T fromDomain(Domain in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).hasChild(in.hasChild())).level(in.getLevel())).name(in.getName())).networkDomain(in.getNetworkDomain())).parentDomainId(in.getParentDomainId())).parentDomainName(in.getParentDomainName());
        }
    }
}

