/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp.jetty;

import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.EntityFunctions;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.java.JavaAppUtils;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.webapp.JavaWebAppSoftwareProcessImpl;
import org.apache.brooklyn.entity.webapp.jetty.Jetty6Driver;
import org.apache.brooklyn.entity.webapp.jetty.Jetty6Server;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty6ServerImpl
extends JavaWebAppSoftwareProcessImpl
implements Jetty6Server {
    private static final Logger log = LoggerFactory.getLogger(Jetty6ServerImpl.class);
    private volatile JmxFeed jmxFeedJetty;
    private volatile JmxFeed jmxFeedMx;

    public void connectSensors() {
        super.connectSensors();
        if (this.getDriver().isJmxEnabled()) {
            String serverMbeanName = "org.mortbay.jetty:type=server,id=0";
            String statsMbeanName = "org.mortbay.jetty.handler:type=atomicstatisticshandler,id=0";
            this.jmxFeedJetty = JmxFeed.builder().entity((Entity)this).period(500L, TimeUnit.MILLISECONDS).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(SERVICE_UP).objectName(serverMbeanName).attributeName("running").onSuccess(Functions.forPredicate((Predicate)Predicates.equalTo((Object)true)))).setOnFailureOrException((Object)false)).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(REQUEST_COUNT).objectName(statsMbeanName).attributeName("requests").onFailureOrException(EntityFunctions.attribute((Entity)this, (AttributeSensor)REQUEST_COUNT))).pollAttribute(new JmxAttributePollConfig(RESPONSES_4XX_COUNT).objectName(statsMbeanName).attributeName("responses4xx")).pollAttribute(new JmxAttributePollConfig(RESPONSES_5XX_COUNT).objectName(statsMbeanName).attributeName("responses5xx")).pollAttribute(new JmxAttributePollConfig(TOTAL_PROCESSING_TIME).objectName(statsMbeanName).attributeName("requestTimeTotal")).pollAttribute(new JmxAttributePollConfig(MAX_PROCESSING_TIME).objectName(statsMbeanName).attributeName("requestTimeMax")).build();
            this.enrichers().add(((Enrichers.CombinerBuilder)Enrichers.builder().combining(new AttributeSensor[]{RESPONSES_4XX_COUNT, RESPONSES_5XX_COUNT}).publishing((AttributeSensor)ERROR_COUNT).computingSum()).build());
            this.jmxFeedMx = JavaAppUtils.connectMXBeanSensors((Entity)this);
        } else {
            log.warn("Jetty running without JMX monitoring; limited visibility of service available");
        }
    }

    protected void disconnectSensors() {
        if (this.jmxFeedJetty != null) {
            this.jmxFeedJetty.stop();
        }
        if (this.jmxFeedMx != null) {
            this.jmxFeedMx.stop();
        }
        super.disconnectSensors();
    }

    public Integer getJmxPort() {
        if (((Jetty6Driver)this.getDriver()).isJmxEnabled()) {
            return (Integer)this.getAttribute((AttributeSensor)UsesJmx.JMX_PORT);
        }
        return -1;
    }

    public Class getDriverInterface() {
        return Jetty6Driver.class;
    }

    public String getShortName() {
        return "Jetty";
    }

    @Override
    public void deploy(String url, String targetName) {
        super.deploy(url, targetName);
        this.restartIfRunning();
    }

    @Override
    public void undeploy(String targetName) {
        super.undeploy(targetName);
        this.restartIfRunning();
    }

    protected void restartIfRunning() {
        Lifecycle serviceState = (Lifecycle)this.getAttribute(SERVICE_STATE_ACTUAL);
        if (serviceState == Lifecycle.RUNNING) {
            this.restart();
        }
    }
}

