/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.loadbalancing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.trait.Resizable;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.policy.loadbalancing.BalanceableContainer;
import org.apache.brooklyn.policy.loadbalancing.BalanceableWorkerPool;
import org.apache.brooklyn.policy.loadbalancing.Movable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceableWorkerPoolImpl
extends AbstractEntity
implements BalanceableWorkerPool {
    private static final Logger LOG = LoggerFactory.getLogger(BalanceableWorkerPool.class);
    private Group containerGroup;
    private Group itemGroup;
    private Resizable resizable;
    private final Set<Entity> containers = Collections.synchronizedSet(new HashSet());
    private final Set<Entity> items = Collections.synchronizedSet(new HashSet());
    private final SensorEventListener<Object> eventHandler = new SensorEventListener<Object>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onEvent(SensorEvent<Object> event) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} received event {}", (Object)BalanceableWorkerPoolImpl.this, event);
            }
            Entity source = event.getSource();
            Object value = event.getValue();
            Sensor sensor = event.getSensor();
            if (sensor.equals(AbstractGroup.MEMBER_ADDED)) {
                if (source.equals(BalanceableWorkerPoolImpl.this.containerGroup)) {
                    BalanceableWorkerPoolImpl.this.onContainerAdded((BalanceableContainer)value);
                    return;
                } else {
                    if (!source.equals(BalanceableWorkerPoolImpl.this.itemGroup)) throw new IllegalStateException("unexpected event source=" + source);
                    BalanceableWorkerPoolImpl.this.onItemAdded((Entity)value);
                }
                return;
            } else if (sensor.equals(AbstractGroup.MEMBER_REMOVED)) {
                if (source.equals(BalanceableWorkerPoolImpl.this.containerGroup)) {
                    BalanceableWorkerPoolImpl.this.onContainerRemoved((BalanceableContainer)value);
                    return;
                } else {
                    if (!source.equals(BalanceableWorkerPoolImpl.this.itemGroup)) throw new IllegalStateException("unexpected event source=" + source);
                    BalanceableWorkerPoolImpl.this.onItemRemoved((Entity)value);
                }
                return;
            } else if (sensor.equals(Startable.SERVICE_UP)) {
                if (((Boolean)value).booleanValue()) {
                    BalanceableWorkerPoolImpl.this.onContainerUp((BalanceableContainer)source);
                    return;
                } else {
                    BalanceableWorkerPoolImpl.this.onContainerDown((BalanceableContainer)source);
                }
                return;
            } else {
                if (!sensor.equals(Movable.CONTAINER)) throw new IllegalStateException("Unhandled event type " + sensor + ": " + event);
                BalanceableWorkerPoolImpl.this.onItemMoved(source, (BalanceableContainer)value);
            }
        }
    };

    @Override
    public void setResizable(Resizable resizable) {
        this.resizable = resizable;
    }

    @Override
    public void setContents(Group containerGroup, Group itemGroup) {
        this.containerGroup = containerGroup;
        this.itemGroup = itemGroup;
        if (this.resizable == null && containerGroup instanceof Resizable) {
            this.resizable = (Resizable)containerGroup;
        }
        this.subscriptions().subscribe((Entity)containerGroup, (Sensor)AbstractGroup.MEMBER_ADDED, this.eventHandler);
        this.subscriptions().subscribe((Entity)containerGroup, (Sensor)AbstractGroup.MEMBER_REMOVED, this.eventHandler);
        this.subscriptions().subscribe((Entity)itemGroup, (Sensor)AbstractGroup.MEMBER_ADDED, this.eventHandler);
        this.subscriptions().subscribe((Entity)itemGroup, (Sensor)AbstractGroup.MEMBER_REMOVED, this.eventHandler);
        for (Entity existingContainer : containerGroup.getMembers()) {
            this.onContainerAdded((BalanceableContainer)existingContainer);
        }
        for (Entity existingItem : itemGroup.getMembers()) {
            this.onItemAdded(existingItem);
        }
    }

    @Override
    public Group getContainerGroup() {
        return this.containerGroup;
    }

    @Override
    public Group getItemGroup() {
        return this.itemGroup;
    }

    public Integer getCurrentSize() {
        return this.containerGroup.getCurrentSize();
    }

    public Integer resize(Integer desiredSize) {
        if (this.resizable != null) {
            return this.resizable.resize(desiredSize);
        }
        throw new UnsupportedOperationException("Container group is not resizable, and no resizable supplied: " + this.containerGroup + " of type " + (this.containerGroup != null ? this.containerGroup.getClass().getCanonicalName() : null));
    }

    private void onContainerAdded(BalanceableContainer<?> newContainer) {
        this.subscriptions().subscribe(newContainer, (Sensor)Startable.SERVICE_UP, this.eventHandler);
        if (!(newContainer instanceof Startable) || Boolean.TRUE.equals(newContainer.getAttribute(Startable.SERVICE_UP))) {
            this.onContainerUp(newContainer);
        }
    }

    private void onContainerUp(BalanceableContainer<?> newContainer) {
        if (this.containers.add(newContainer)) {
            this.sensors().emit((Sensor)CONTAINER_ADDED, newContainer);
        }
    }

    private void onContainerDown(BalanceableContainer<?> oldContainer) {
        if (this.containers.remove(oldContainer)) {
            this.sensors().emit((Sensor)CONTAINER_REMOVED, oldContainer);
        }
    }

    private void onContainerRemoved(BalanceableContainer<?> oldContainer) {
        this.subscriptions().unsubscribe(oldContainer);
        this.onContainerDown(oldContainer);
    }

    private void onItemAdded(Entity item) {
        if (this.items.add(item)) {
            this.subscriptions().subscribe(item, Movable.CONTAINER, this.eventHandler);
            this.sensors().emit((Sensor)ITEM_ADDED, (Object)new BalanceableWorkerPool.ContainerItemPair((BalanceableContainer)item.getAttribute(Movable.CONTAINER), item));
        }
    }

    private void onItemRemoved(Entity item) {
        if (this.items.remove(item)) {
            this.subscriptions().unsubscribe(item);
            this.sensors().emit((Sensor)ITEM_REMOVED, (Object)new BalanceableWorkerPool.ContainerItemPair(null, item));
        }
    }

    private void onItemMoved(Entity item, BalanceableContainer<?> container) {
        this.sensors().emit((Sensor)ITEM_MOVED, (Object)new BalanceableWorkerPool.ContainerItemPair(container, item));
    }
}

