/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.util.Utils;

public class InterpretableStatement
implements Statement {
    private String[] statements;

    public InterpretableStatement(String ... statements) {
        this.statements = (String[])Preconditions.checkNotNull((Object)statements, (Object)"statements");
    }

    @Override
    public String render(OsFamily family) {
        return Utils.replaceTokens(Joiner.on((String)ShellToken.LF.to(family)).join((Object[])this.statements), ShellToken.tokenValueMap(family));
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.statements);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterpretableStatement other = (InterpretableStatement)obj;
        return Arrays.equals(this.statements, other.statements);
    }

    public String toString() {
        return "[statements=" + Arrays.toString(this.statements) + "]";
    }
}

