/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.tools.xsd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.rat.commandline.StyleSheets;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.Description;
import org.apache.rat.config.parameters.DescriptionBuilder;
import org.apache.rat.configuration.MatcherBuilderTracker;
import org.apache.rat.configuration.XMLConfig;
import org.apache.rat.configuration.builders.AbstractBuilder;
import org.apache.rat.license.SimpleLicense;
import org.apache.rat.tools.xsd.XsdWriter;

public class XsdGenerator {
    private XsdWriter writer;
    private static final Map<ComponentType, String> TYPE_MAP = new HashMap<ComponentType, String>();

    public static void main(String[] args) throws IOException, TransformerException {
        XsdGenerator generator = new XsdGenerator();
        TransformerFactory tf = TransformerFactory.newInstance();
        try (InputStream in = generator.getInputStream();
             InputStream styleIn = StyleSheets.XML.getStyleSheet().get();){
            Transformer transformer = tf.newTransformer(new StreamSource(styleIn));
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new StreamSource(in), new StreamResult(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));
        }
    }

    public InputStream getInputStream() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ByteArrayInputStream byteArrayInputStream;
            try (OutputStreamWriter writer = new OutputStreamWriter(baos);){
                this.write(writer);
                byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            }
            return byteArrayInputStream;
        }
    }

    public void write(Writer output) throws IOException {
        this.writer = new XsdWriter(output).init();
        this.writer.open(XsdWriter.Type.ELEMENT, "name", "rat-config").open(XsdWriter.Type.COMPLEX, new String[0]).open(XsdWriter.Type.SEQUENCE, new String[0]);
        this.writeFamilies();
        this.writeLicenses();
        this.writeApproved();
        this.writeMatchers();
        this.writer.close(XsdWriter.Type.ELEMENT);
        this.writeMatcherElements();
        this.writer.finish();
    }

    private void writeFamilies() throws IOException {
        this.writer.open(XsdWriter.Type.ELEMENT, "name", "families", "maxOccurs", "1", "minOccurs", "0").open(XsdWriter.Type.COMPLEX, new String[0]).open(XsdWriter.Type.SEQUENCE, new String[0]).open(XsdWriter.Type.ELEMENT, "name", "family", "maxOccurs", "unbounded", "minOccurs", "0").open(XsdWriter.Type.COMPLEX, new String[0]).attribute("id", "type", "xs:string", "use", "required").attribute("name", "type", "xs:string", "use", "required").close(XsdWriter.Type.ELEMENT).close(XsdWriter.Type.ELEMENT);
    }

    private void writeLicenses() throws IOException {
        Description desc = DescriptionBuilder.buildMap(SimpleLicense.class);
        ArrayList<Description> children = new ArrayList<Description>();
        ArrayList<Description> attributes = new ArrayList<Description>();
        if (desc != null && desc.getChildren() != null) {
            for (Description child : desc.getChildren().values()) {
                if (XMLConfig.isLicenseChild(child.getCommonName())) {
                    children.add(child);
                    continue;
                }
                if (child.getType() != ComponentType.PARAMETER) continue;
                attributes.add(child);
            }
        }
        this.writer.open(XsdWriter.Type.ELEMENT, "name", "licenses", "maxOccurs", "1", "minOccurs", "0").open(XsdWriter.Type.COMPLEX, new String[0]).open(XsdWriter.Type.SEQUENCE, new String[0]).open(XsdWriter.Type.ELEMENT, "name", "license", "maxOccurs", "unbounded", "minOccurs", "0").open(XsdWriter.Type.COMPLEX, new String[0]).open(XsdWriter.Type.CHOICE, "maxOccurs", "unbounded", "minOccurs", "1");
        for (Description child : children) {
            if (child.getCommonName().equals("matcher")) {
                this.writer.open(XsdWriter.Type.ELEMENT, "ref", "matcher", "maxOccurs", "1", "minOccurs", "1").close(XsdWriter.Type.ELEMENT);
                continue;
            }
            this.element(child);
        }
        this.writer.close(XsdWriter.Type.CHOICE);
        for (Description child : attributes) {
            this.attribute(child);
        }
        this.writer.close(XsdWriter.Type.ELEMENT).close(XsdWriter.Type.ELEMENT);
    }

    private void writeApproved() throws IOException {
        this.writer.open(XsdWriter.Type.ELEMENT, "name", "approved", "maxOccurs", "1", "minOccurs", "0").open(XsdWriter.Type.COMPLEX, new String[0]).open(XsdWriter.Type.SEQUENCE, new String[0]).open(XsdWriter.Type.ELEMENT, "name", "family", "maxOccurs", "unbounded", "minOccurs", "0").open(XsdWriter.Type.COMPLEX, new String[0]).attribute("license_ref", "type", "xs:string", "use", "required").close(XsdWriter.Type.ELEMENT).close(XsdWriter.Type.ELEMENT);
    }

    private void writeMatchers() throws IOException {
        this.writer.open(XsdWriter.Type.ELEMENT, "name", "matchers", "maxOccurs", "1", "minOccurs", "0").open(XsdWriter.Type.COMPLEX, new String[0]).open(XsdWriter.Type.SEQUENCE, new String[0]).open(XsdWriter.Type.ELEMENT, "name", "matcher", "maxOccurs", "unbounded", "minOccurs", "0").open(XsdWriter.Type.COMPLEX, new String[0]).attribute("class", "type", "xs:string", "use", "required").close(XsdWriter.Type.ELEMENT).close(XsdWriter.Type.ELEMENT);
    }

    private void writeMatcherElements() throws IOException {
        MatcherBuilderTracker tracker = MatcherBuilderTracker.instance();
        this.writer.open(XsdWriter.Type.ELEMENT, "name", "matcher", "abstract", "true").close(XsdWriter.Type.ELEMENT);
        for (Class<? extends AbstractBuilder> clazz : tracker.getClasses()) {
            Description desc = DescriptionBuilder.buildMap(clazz);
            if (desc == null) continue;
            boolean hasResourceAttr = false;
            Description inline = null;
            ArrayList<Description> attributes = new ArrayList<Description>();
            for (Description child : desc.getChildren().values()) {
                if (XMLConfig.isInlineNode(desc.getCommonName(), child.getCommonName())) {
                    inline = child;
                    continue;
                }
                hasResourceAttr |= child.getCommonName().equals("resource");
                attributes.add(child);
            }
            this.writer.open(XsdWriter.Type.ELEMENT, "name", desc.getCommonName(), "substitutionGroup", "matcher").open(XsdWriter.Type.COMPLEX, new String[0]);
            if (inline != null) {
                if ("enclosed".equals(inline.getCommonName())) {
                    this.writer.open(XsdWriter.Type.CHOICE, new String[0]).open(XsdWriter.Type.ELEMENT, "ref", "matcher", "maxOccurs", inline.isCollection() ? "unbounded" : "1", "minOccurs", hasResourceAttr ? "0" : "1").close(XsdWriter.Type.CHOICE);
                } else {
                    this.writer.open(XsdWriter.Type.SIMPLE, new String[0]).open(XsdWriter.Type.EXTENSION, "base", "xs:string");
                }
            }
            for (Description child : attributes) {
                this.attribute(child);
            }
            this.writer.close(XsdWriter.Type.ELEMENT);
        }
    }

    private void element(Description desc) throws IOException {
        String typeName = TYPE_MAP.get((Object)desc.getType());
        if (typeName != null) {
            this.writer.open(XsdWriter.Type.ELEMENT, "name", desc.getCommonName(), "type", typeName, "minOccurs", desc.isRequired() ? "1" : "0", "maxOccurs", desc.isCollection() ? "unbounded" : "1").close(XsdWriter.Type.ELEMENT);
        }
    }

    private void attribute(Description attr) throws IOException {
        if (attr.getType() == ComponentType.PARAMETER) {
            this.writer.attribute(attr.getCommonName(), "form", "unqualified", "use", attr.isRequired() ? "required" : "optional");
        }
    }

    static {
        TYPE_MAP.put(ComponentType.MATCHER, "matcher");
        TYPE_MAP.put(ComponentType.PARAMETER, "xs:string");
        TYPE_MAP.put(ComponentType.LICENSE, "license");
    }
}

