/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.SimpleKeyManagerFactory;
import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSParameterBase;
import org.apache.cxf.transport.http.netty.client.NettyHttpClientHandler;
import org.apache.cxf.transport.http.netty.client.NettyHttpConduit;
import org.apache.cxf.transport.https.SSLContextInitParameters;
import org.apache.cxf.transport.https.SSLUtils;

public class NettyHttpClientPipelineFactory
extends ChannelInitializer<Channel> {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpClientPipelineFactory.class);
    private final TLSClientParameters tlsClientParameters;
    private final int readTimeout;
    private final int maxContentLength;
    private final boolean enableHttp2;
    private ChannelPromise readyFuture;

    public NettyHttpClientPipelineFactory(TLSClientParameters clientParameters) {
        this(clientParameters, 0);
    }

    public NettyHttpClientPipelineFactory(TLSClientParameters clientParameters, int readTimeout) {
        this(clientParameters, readTimeout, NettyHttpConduit.DEFAULT_MAX_RESPONSE_CONTENT_LENGTH);
    }

    public NettyHttpClientPipelineFactory(TLSClientParameters clientParameters, int readTimeout, int maxResponseContentLength) {
        this(clientParameters, readTimeout, maxResponseContentLength, false);
    }

    public NettyHttpClientPipelineFactory(TLSClientParameters clientParameters, int readTimeout, int maxResponseContentLength, boolean enableHttp2) {
        this.tlsClientParameters = clientParameters;
        this.readTimeout = readTimeout;
        this.maxContentLength = maxResponseContentLength;
        this.enableHttp2 = enableHttp2;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        SslHandler sslHandler = this.configureClientSSLOnDemand(ch);
        if (sslHandler != null) {
            LOG.log(Level.FINE, "Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        NettyHttpClientHandler responseHandler = new NettyHttpClientHandler();
        this.readyFuture = ch.newPromise();
        if (this.enableHttp2) {
            DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
            Http2SettingsHandler settingsHandler = new Http2SettingsHandler(this.readyFuture);
            HttpToHttp2ConnectionHandler connectionHandler = new HttpToHttp2ConnectionHandlerBuilder().connection((Http2Connection)connection).frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(this.maxContentLength).propagateSettings(true).build())).build();
            if (sslHandler != null) {
                pipeline.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("http/1.1", (Http2ConnectionHandler)connectionHandler, settingsHandler, responseHandler){
                    final /* synthetic */ Http2ConnectionHandler val$connectionHandler;
                    final /* synthetic */ Http2SettingsHandler val$settingsHandler;
                    final /* synthetic */ NettyHttpClientHandler val$responseHandler;
                    {
                        this.val$connectionHandler = http2ConnectionHandler;
                        this.val$settingsHandler = http2SettingsHandler;
                        this.val$responseHandler = nettyHttpClientHandler;
                        super(x0);
                    }

                    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                        ChannelPipeline p = ctx.pipeline();
                        if ("h2".equals(protocol)) {
                            p.addLast(new ChannelHandler[]{this.val$connectionHandler});
                            p.addLast(new ChannelHandler[]{this.val$settingsHandler});
                            p.addLast("client", (ChannelHandler)this.val$responseHandler);
                        } else if ("http/1.1".equals(protocol)) {
                            p.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
                            p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(NettyHttpClientPipelineFactory.this.maxContentLength));
                            p.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
                            p.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                            NettyHttpClientPipelineFactory.this.readyFuture.setSuccess(null);
                        } else {
                            ctx.close();
                            IllegalStateException ex = new IllegalStateException("Unknown protocol: " + protocol);
                            NettyHttpClientPipelineFactory.this.readyFuture.setFailure((Throwable)ex);
                            throw ex;
                        }
                    }
                }});
                if (this.readTimeout > 0) {
                    pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler((long)this.readTimeout, TimeUnit.MILLISECONDS));
                }
            } else {
                HttpClientCodec sourceCodec = new HttpClientCodec();
                Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)connectionHandler);
                HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, this.maxContentLength);
                pipeline.addLast(new ChannelHandler[]{sourceCodec});
                pipeline.addLast(new ChannelHandler[]{upgradeHandler});
                if (this.readTimeout > 0) {
                    pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler((long)this.readTimeout, TimeUnit.MILLISECONDS));
                }
                pipeline.addLast("client", (ChannelHandler)responseHandler);
                this.readyFuture.setSuccess(null);
            }
        } else {
            pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength));
            pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
            if (this.readTimeout > 0) {
                pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler((long)this.readTimeout, TimeUnit.MILLISECONDS));
            }
            pipeline.addLast("client", (ChannelHandler)responseHandler);
            this.readyFuture.setSuccess(null);
        }
    }

    public ChannelFuture whenReady() {
        return this.readyFuture;
    }

    private SslHandler configureClientSSLOnDemand(Channel channel) throws Exception {
        if (this.tlsClientParameters != null) {
            SSLEngine sslEngine;
            if (this.enableHttp2) {
                final SSLContextInitParameters initParams = SSLUtils.getSSLContextInitParameters((TLSParameterBase)this.tlsClientParameters);
                sslEngine = SslContextBuilder.forClient().sslProvider(SslContext.defaultClientProvider()).keyManager((KeyManagerFactory)new SimpleKeyManagerFactory(){

                    protected void engineInit(KeyStore keyStore, char[] var2) throws Exception {
                    }

                    protected void engineInit(ManagerFactoryParameters params) throws Exception {
                    }

                    protected KeyManager[] engineGetKeyManagers() {
                        KeyManager[] keyManagers = initParams.getKeyManagers();
                        if (keyManagers == null) {
                            return new KeyManager[0];
                        }
                        return keyManagers;
                    }
                }).trustManager((TrustManagerFactory)new SimpleTrustManagerFactory(){

                    protected void engineInit(KeyStore keyStore) throws Exception {
                    }

                    protected void engineInit(ManagerFactoryParameters params) throws Exception {
                    }

                    protected TrustManager[] engineGetTrustManagers() {
                        TrustManager[] trustManagers = initParams.getTrustManagers();
                        if (trustManagers == null) {
                            return new TrustManager[0];
                        }
                        return trustManagers;
                    }
                }).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build().newEngine(channel.alloc());
            } else {
                sslEngine = SSLUtils.createClientSSLEngine((TLSClientParameters)this.tlsClientParameters);
            }
            return new SslHandler(sslEngine);
        }
        return null;
    }

    private static class Http2SettingsHandler
    extends SimpleChannelInboundHandler<Http2Settings> {
        private ChannelPromise promise;

        Http2SettingsHandler(ChannelPromise promise) {
            this.promise = promise;
        }

        protected void channelRead0(ChannelHandlerContext ctx, Http2Settings msg) throws Exception {
            this.promise.setSuccess();
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }
}

