/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.Log4j2Metrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.netty.buffer.PooledByteBufAllocator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.security.impl.SecurityStoreImpl;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.metrics.NettyPooledAllocatorMetrics;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String brokerName;
    private final MeterRegistry meterRegistry;
    private final Map<String, List<Meter>> meters = new ConcurrentHashMap<String, List<Meter>>();
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;

    public MetricsManager(String brokerName, MetricsConfiguration metricsConfiguration, HierarchicalRepository<AddressSettings> addressSettingsRepository, SecurityStore securityStore) {
        this.brokerName = brokerName;
        this.meterRegistry = metricsConfiguration.getPlugin().getRegistry();
        this.addressSettingsRepository = addressSettingsRepository;
        if (this.meterRegistry != null) {
            Metrics.globalRegistry.add(this.meterRegistry);
            this.meterRegistry.config().commonTags(new String[]{"broker", brokerName});
            if (metricsConfiguration.isJvmMemory()) {
                new JvmMemoryMetrics().bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isJvmGc()) {
                new JvmGcMetrics().bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isJvmThread()) {
                new JvmThreadMetrics().bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isNettyPool()) {
                new NettyPooledAllocatorMetrics(PooledByteBufAllocator.DEFAULT.metric()).bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isFileDescriptors()) {
                new FileDescriptorMetrics().bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isProcessor()) {
                new ProcessorMetrics().bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isUptime()) {
                new UptimeMetrics().bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isLogging()) {
                new Log4j2Metrics().bindTo(this.meterRegistry);
            }
            if (metricsConfiguration.isSecurityCaches() && securityStore.isSecurityEnabled()) {
                CaffeineCacheMetrics.monitor((MeterRegistry)this.meterRegistry, ((SecurityStoreImpl)securityStore).getAuthenticationCache(), (String)"authentication", (String[])new String[0]);
                CaffeineCacheMetrics.monitor((MeterRegistry)this.meterRegistry, ((SecurityStoreImpl)securityStore).getAuthorizationCache(), (String)"authorization", (String[])new String[0]);
            }
        }
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void registerQueueGauge(String address, String queue, Consumer<MetricGaugeBuilder> builder) {
        if (this.meterRegistry == null || !this.addressSettingsRepository.getMatch(address).isEnableMetrics()) {
            return;
        }
        ArrayList<Gauge.Builder<Object>> gaugeBuilders = new ArrayList<Gauge.Builder<Object>>();
        builder.accept((metricName, state, f, description, tags) -> {
            Gauge.Builder meter = Gauge.builder((String)("artemis." + metricName), (Object)state, (ToDoubleFunction)f).tag("address", address).tag("queue", queue).tags((Iterable)tags).description(description);
            gaugeBuilders.add(meter);
        });
        this.registerMeters(gaugeBuilders, "queue." + queue);
    }

    public void registerAddressGauge(String address, Consumer<MetricGaugeBuilder> builder) {
        if (this.meterRegistry == null || !this.addressSettingsRepository.getMatch(address).isEnableMetrics()) {
            return;
        }
        ArrayList<Gauge.Builder<Object>> gaugeBuilders = new ArrayList<Gauge.Builder<Object>>();
        builder.accept((metricName, state, f, description, tags) -> {
            Gauge.Builder meter = Gauge.builder((String)("artemis." + metricName), (Object)state, (ToDoubleFunction)f).tag("address", address).tags((Iterable)tags).description(description);
            gaugeBuilders.add(meter);
        });
        this.registerMeters(gaugeBuilders, "address." + address);
    }

    public void registerBrokerGauge(Consumer<MetricGaugeBuilder> builder) {
        if (this.meterRegistry == null) {
            return;
        }
        ArrayList<Gauge.Builder<Object>> gaugeBuilders = new ArrayList<Gauge.Builder<Object>>();
        builder.accept((metricName, state, f, description, tags) -> {
            Gauge.Builder meter = Gauge.builder((String)("artemis." + metricName), (Object)state, (ToDoubleFunction)f).tags((Iterable)tags).description(description);
            gaugeBuilders.add(meter);
        });
        this.registerMeters(gaugeBuilders, "broker." + this.brokerName);
    }

    private void registerMeters(List<Gauge.Builder<Object>> gaugeBuilders, String resource) {
        if (this.meters.get(resource) != null) {
            throw ActiveMQMessageBundle.BUNDLE.metersAlreadyRegistered(resource);
        }
        logger.debug("Registering meters for {}", (Object)resource);
        ArrayList<Gauge> newMeters = new ArrayList<Gauge>(gaugeBuilders.size());
        for (Gauge.Builder<Object> gaugeBuilder : gaugeBuilders) {
            Gauge gauge = gaugeBuilder.register(this.meterRegistry);
            newMeters.add(gauge);
            logger.debug("Registered meter: {}", (Object)gauge.getId());
        }
        this.meters.put(resource, newMeters);
    }

    public void remove(String resource) {
        List<Meter> resourceMeters = this.meters.remove(resource);
        if (resourceMeters != null) {
            logger.debug("Unregistering meters for {}", (Object)resource);
            for (Meter meter : resourceMeters) {
                Meter removed = this.meterRegistry.remove(meter);
                if (removed != null) {
                    logger.debug("Unregistered meter: {}", (Object)removed.getId());
                    continue;
                }
                logger.debug("Attempted to unregister meter {}, but it wasn't found in the registry", (Object)meter);
            }
        } else {
            logger.debug("Attempted to unregister meters for {}, but none were found.", (Object)resource);
        }
    }

    @FunctionalInterface
    public static interface MetricGaugeBuilder {
        public void build(String var1, Object var2, ToDoubleFunction<Object> var3, String var4, List<Tag> var5);
    }
}

