/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.collections.MapStorageManager;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalHashMap<K, V, C>
implements Map<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    C context;
    LongFunction<C> contextProvider;
    private final Persister<MapRecord<K, V>> persister;
    private final MapStorageManager journal;
    private final long collectionId;
    private final byte recordType;
    private final LongSupplier idGenerator;
    private final Supplier<IOCompletion> completionSupplier;
    private final IOCriticalErrorListener exceptionListener;
    private final Map<K, MapRecord<K, V>> map = new HashMap<K, MapRecord<K, V>>();

    public JournalHashMap(long collectionId, MapStorageManager journal, LongSupplier idGenerator, Persister<MapRecord<K, V>> persister, byte recordType, Supplier<IOCompletion> completionSupplier, LongFunction<C> contextProvider, IOCriticalErrorListener ioExceptionListener) {
        this.collectionId = collectionId;
        this.journal = journal;
        this.idGenerator = idGenerator;
        this.persister = persister;
        this.recordType = recordType;
        this.exceptionListener = ioExceptionListener;
        this.completionSupplier = completionSupplier;
        this.contextProvider = contextProvider;
    }

    public long getCollectionId() {
        return this.collectionId;
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    public C getContext() {
        if (this.context == null && this.contextProvider != null) {
            this.context = this.contextProvider.apply(this.collectionId);
        }
        return this.context;
    }

    public JournalHashMap<K, V, C> setContext(C context) {
        this.context = context;
        return this;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        for (Map.Entry<K, MapRecord<K, V>> entry : this.map.entrySet()) {
            if (!value.equals(entry.getValue().value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized V get(Object key) {
        MapRecord<K, V> record = this.map.get(key);
        if (record == null) {
            return null;
        }
        return record.value;
    }

    public void reload(MapRecord<K, V> reloadValue) {
        this.map.put(reloadValue.getKey(), reloadValue);
    }

    @Override
    public synchronized V put(K key, V value) {
        logger.debug("adding {} = {}", key, value);
        long id = this.idGenerator.getAsLong();
        MapRecord<K, V> record = new MapRecord<K, V>(this.collectionId, id, key, value);
        this.store(record);
        MapRecord<K, V> oldRecord = this.map.put(key, record);
        if (oldRecord != null) {
            this.removed(oldRecord);
            return oldRecord.value;
        }
        return null;
    }

    private synchronized void store(MapRecord<K, V> record) {
        try {
            IOCompletion callback = null;
            if (this.completionSupplier != null) {
                callback = this.completionSupplier.get();
            }
            if (callback == null) {
                this.journal.storeMapRecord(record.id, this.recordType, this.persister, record, false);
            } else {
                this.journal.storeMapRecord(record.id, this.recordType, this.persister, record, true, callback);
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            this.exceptionListener.onIOException(e, e.getMessage(), null);
        }
    }

    private void removed(MapRecord<K, V> record) {
        if (logger.isTraceEnabled()) {
            logger.trace("Removing record {}", record);
        }
        try {
            this.journal.deleteMapRecord(record.id, false);
        }
        catch (Exception e) {
            this.exceptionListener.onIOException(e, e.getMessage(), null);
        }
    }

    private void removed(MapRecord<K, V> record, long txid) {
        try {
            this.journal.deleteMapRecordTx(txid, record.id);
        }
        catch (Exception e) {
            this.exceptionListener.onIOException(e, e.getMessage(), null);
        }
    }

    @Override
    public synchronized V remove(Object key) {
        MapRecord<K, V> record = this.map.remove(key);
        this.removed(record);
        return record.value;
    }

    public synchronized V remove(Object key, long transactionID) {
        MapRecord<K, V> record = this.map.remove(key);
        this.removed(record, transactionID);
        return record.value;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public synchronized void clear() {
        this.map.values().forEach(this::remove);
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("not implemented yet. You may use valuesCopy");
    }

    public synchronized Collection<V> valuesCopy() {
        ArrayList values = new ArrayList(this.map.size());
        this.map.values().forEach((? super T v) -> values.add(v.value));
        return values;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("not implemented yet. You may use entrySetCopy");
    }

    public synchronized Set<Map.Entry<K, V>> entrySetCopy() {
        return new HashSet<Map.Entry<K, V>>(this.map.values());
    }

    @Override
    public synchronized void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        this.map.forEach((a, b) -> action.accept((Object)b.key, (Object)b.value));
    }

    public static class MapRecord<K, V>
    implements Map.Entry<K, V> {
        final long collectionID;
        final long id;
        final K key;
        V value;

        MapRecord(long collectionID, long id, K key, V value) {
            this.collectionID = collectionID;
            this.id = id;
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return "MapRecord{collectionID=" + this.collectionID + ", id=" + this.id + ", key=" + this.key + ", value=" + this.value + "}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapRecord mapRecord = (MapRecord)o;
            if (this.collectionID != mapRecord.collectionID) {
                return false;
            }
            if (this.id != mapRecord.id) {
                return false;
            }
            if (!Objects.equals(this.key, mapRecord.key)) {
                return false;
            }
            return Objects.equals(this.value, mapRecord.value);
        }

        @Override
        public int hashCode() {
            int result = (int)(this.collectionID ^ this.collectionID >>> 32);
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

