/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.Closeable;
import org.apache.activemq.artemis.api.core.AutoCreateResult;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.json.JsonArrayBuilder;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public interface ServerSession
extends SecurityAuth {
    public String getName();

    public int getMinLargeMessageSize();

    public Object getConnectionID();

    public Executor getSessionExecutor();

    public void enableSecurity();

    public void disableSecurity();

    @Override
    public RemotingConnection getRemotingConnection();

    public void transferConnection(RemotingConnection var1);

    public Transaction newTransaction();

    public boolean removeConsumer(long var1) throws Exception;

    public List<Long> acknowledge(long var1, long var3) throws Exception;

    public void individualAcknowledge(long var1, long var3) throws Exception;

    public void individualCancel(long var1, long var3, boolean var5) throws Exception;

    public void expire(long var1, long var3) throws Exception;

    public void rollback(boolean var1) throws Exception;

    public void commit() throws Exception;

    public void xaCommit(Xid var1, boolean var2) throws Exception;

    public void xaEnd(Xid var1) throws Exception;

    public void xaForget(Xid var1) throws Exception;

    public void xaJoin(Xid var1) throws Exception;

    public void xaPrepare(Xid var1) throws Exception;

    public void xaResume(Xid var1) throws Exception;

    public void xaRollback(Xid var1) throws Exception;

    public void xaStart(Xid var1) throws Exception;

    public void xaFailed(Xid var1) throws Exception;

    public void xaSuspend() throws Exception;

    public void markTXFailed(Throwable var1);

    public List<Xid> xaGetInDoubtXids();

    public int xaGetTimeout();

    public void xaSetTimeout(int var1);

    public void start();

    public void stop();

    public void addCloseable(Closeable var1);

    public AutoCreateResult checkAutoCreate(QueueConfiguration var1) throws Exception;

    public ServerConsumer createConsumer(long var1, SimpleString var3, SimpleString var4, int var5, boolean var6, boolean var7, Integer var8) throws Exception;

    public ServerConsumer createConsumer(long var1, SimpleString var3, SimpleString var4, int var5, boolean var6, boolean var7, Integer var8, boolean var9) throws Exception;

    public void resetTX(Transaction var1);

    @Deprecated
    public Queue createQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, boolean var6) throws Exception;

    @Deprecated
    public Queue createQueue(AddressInfo var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, boolean var9) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, Boolean var9, Boolean var10, boolean var11) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, Boolean var9, Boolean var10, Integer var11, Boolean var12, SimpleString var13, Boolean var14, Integer var15, Long var16, Boolean var17, Long var18, Long var19, boolean var20) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, Boolean var9, Boolean var10, Integer var11, SimpleString var12, Boolean var13, SimpleString var14, Boolean var15, Integer var16, Long var17, Boolean var18, Long var19, Long var20, boolean var21) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, Boolean var9, Boolean var10, Integer var11, SimpleString var12, Boolean var13, SimpleString var14, Boolean var15, Integer var16, Long var17, Boolean var18, Long var19, Long var20, boolean var21, Long var22) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, boolean var6, boolean var7) throws Exception;

    @Deprecated
    public Queue createQueue(AddressInfo var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5, boolean var6) throws Exception;

    @Deprecated
    public Queue createQueue(AddressInfo var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5, Boolean var6, Boolean var7, boolean var8) throws Exception;

    public Queue createQueue(QueueConfiguration var1) throws Exception;

    public AddressInfo createAddress(SimpleString var1, EnumSet<RoutingType> var2, boolean var3) throws Exception;

    public AddressInfo createAddress(SimpleString var1, RoutingType var2, boolean var3) throws Exception;

    public AddressInfo createAddress(AddressInfo var1, boolean var2) throws Exception;

    public void deleteQueue(SimpleString var1) throws Exception;

    public void deleteQueue(SimpleString var1, boolean var2) throws Exception;

    public void deleteAddress(SimpleString var1) throws Exception;

    public ServerConsumer createConsumer(long var1, SimpleString var3, SimpleString var4, boolean var5) throws Exception;

    public ServerConsumer createConsumer(long var1, SimpleString var3, SimpleString var4, boolean var5, boolean var6, Integer var7) throws Exception;

    public QueueQueryResult executeQueueQuery(SimpleString var1) throws Exception;

    public AddressQueryResult executeAddressQuery(SimpleString var1) throws Exception;

    public BindingQueryResult executeBindingQuery(SimpleString var1) throws Exception;

    public void closeConsumer(long var1) throws Exception;

    public void receiveConsumerCredits(long var1, int var3) throws Exception;

    public RoutingStatus send(Transaction var1, Message var2, boolean var3, String var4, boolean var5) throws Exception;

    public RoutingStatus send(Transaction var1, Message var2, boolean var3, String var4, boolean var5, RoutingContext var6) throws Exception;

    public RoutingStatus send(Transaction var1, SimpleString var2, RoutingType var3, Message var4, boolean var5, String var6, boolean var7, RoutingContext var8) throws Exception;

    public RoutingStatus doSend(Transaction var1, Message var2, SimpleString var3, boolean var4, String var5, boolean var6) throws Exception;

    public RoutingStatus doSend(Transaction var1, Message var2, SimpleString var3, boolean var4, String var5, boolean var6, RoutingContext var7) throws Exception;

    public RoutingStatus doSend(Transaction var1, RoutingType var2, Message var3, SimpleString var4, boolean var5, String var6, boolean var7, RoutingContext var8) throws Exception;

    public RoutingStatus send(Message var1, boolean var2, String var3, boolean var4) throws Exception;

    public RoutingStatus send(Message var1, boolean var2, String var3) throws Exception;

    public void forceConsumerDelivery(long var1, long var3) throws Exception;

    public void requestProducerCredits(SimpleString var1, int var2) throws Exception;

    public void close(boolean var1) throws Exception;

    public void close(boolean var1, boolean var2) throws Exception;

    public void setTransferring(boolean var1);

    public Set<ServerConsumer> getServerConsumers();

    public void addMetaData(String var1, String var2) throws Exception;

    public boolean addUniqueMetaData(String var1, String var2) throws Exception;

    public String getMetaData(String var1);

    public Map<String, String> getMetaData();

    public void describeProducersInfo(JsonArrayBuilder var1);

    public long getCreationTime();

    public OperationContext getSessionContext();

    public Transaction getCurrentTransaction();

    public ServerConsumer locateConsumer(long var1) throws Exception;

    public boolean isClosed();

    @Deprecated
    public void createSharedQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, Integer var6, Boolean var7, Boolean var8, Boolean var9) throws Exception;

    @Deprecated
    public void createSharedQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, Integer var6, Boolean var7, Boolean var8, Boolean var9, Integer var10, Boolean var11, SimpleString var12, Boolean var13, Integer var14, Long var15, Boolean var16, Long var17, Long var18) throws Exception;

    @Deprecated
    public void createSharedQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, Integer var6, Boolean var7, Boolean var8, Boolean var9, Integer var10, SimpleString var11, Boolean var12, SimpleString var13, Boolean var14, Integer var15, Long var16, Boolean var17, Long var18, Long var19) throws Exception;

    @Deprecated
    public void createSharedQueue(SimpleString var1, SimpleString var2, RoutingType var3, boolean var4, SimpleString var5) throws Exception;

    @Deprecated
    public void createSharedQueue(SimpleString var1, SimpleString var2, boolean var3, SimpleString var4) throws Exception;

    public void createSharedQueue(QueueConfiguration var1) throws Exception;

    public List<MessageReference> getInTXMessagesForConsumer(long var1);

    public List<MessageReference> getInTxLingerMessages();

    public void addLingerConsumer(ServerConsumer var1);

    public String getValidatedUser();

    public SimpleString getMatchingQueue(SimpleString var1, RoutingType var2) throws Exception;

    public SimpleString getMatchingQueue(SimpleString var1, SimpleString var2, RoutingType var3) throws Exception;

    public AddressInfo getAddress(SimpleString var1);

    public SimpleString removePrefix(SimpleString var1);

    public SimpleString getPrefix(SimpleString var1);

    public AddressInfo getAddressAndRoutingType(AddressInfo var1);

    public RoutingType getRoutingTypeFromPrefix(SimpleString var1, RoutingType var2);

    public Pair<SimpleString, EnumSet<RoutingType>> getAddressAndRoutingTypes(SimpleString var1, EnumSet<RoutingType> var2);

    public void addProducer(String var1, String var2, String var3);

    public void removeProducer(String var1);

    public Collection<ServerProducer> getServerProducers();

    public String getDefaultAddress();

    public int getConsumerCount();

    public int getProducerCount();

    public int getDefaultConsumerWindowSize(SimpleString var1);

    public String toManagementString();
}

