/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import jakarta.servlet.descriptor.JspPropertyGroupDescriptor;
import jakarta.servlet.descriptor.TaglibDescriptor;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.jetty.ee11.servlet.BaseHolder;
import org.eclipse.jetty.ee11.servlet.CrossContextServletContext;
import org.eclipse.jetty.ee11.servlet.Dispatcher;
import org.eclipse.jetty.ee11.servlet.ErrorHandler;
import org.eclipse.jetty.ee11.servlet.FilterHolder;
import org.eclipse.jetty.ee11.servlet.HttpInput;
import org.eclipse.jetty.ee11.servlet.ListenerHolder;
import org.eclipse.jetty.ee11.servlet.ManagedAttributeListener;
import org.eclipse.jetty.ee11.servlet.ResponseWriter;
import org.eclipse.jetty.ee11.servlet.ServletChannel;
import org.eclipse.jetty.ee11.servlet.ServletChannelState;
import org.eclipse.jetty.ee11.servlet.ServletContainerInitializerHolder;
import org.eclipse.jetty.ee11.servlet.ServletContextRequest;
import org.eclipse.jetty.ee11.servlet.ServletContextResponse;
import org.eclipse.jetty.ee11.servlet.ServletHandler;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.ee11.servlet.SessionHandler;
import org.eclipse.jetty.ee11.servlet.Source;
import org.eclipse.jetty.ee11.servlet.security.ConstraintAware;
import org.eclipse.jetty.ee11.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee11.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.io.IOResources;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ContextRequest;
import org.eclipse.jetty.server.handler.ContextResponse;
import org.eclipse.jetty.session.AbstractSessionManager;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.DeprecationWarning;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ClassLoaderDump;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Servlet Context Handler")
public class ServletContextHandler
extends ContextHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServletContextHandler.class);
    public static final Environment ENVIRONMENT;
    @Deprecated(since="12.0.9", forRemoval=true)
    public static final Environment __environment;
    public static final Class<?>[] SERVLET_LISTENER_TYPES;
    public static final int DEFAULT_LISTENER_TYPE_INDEX = 1;
    public static final int EXTENDED_LISTENER_TYPE_INDEX = 0;
    public static final String MAX_FORM_KEYS_KEY = "org.eclipse.jetty.server.Request.maxFormKeys";
    public static final String MAX_FORM_CONTENT_SIZE_KEY = "org.eclipse.jetty.server.Request.maxFormContentSize";
    public static final int DEFAULT_MAX_FORM_KEYS = 1000;
    public static final int DEFAULT_MAX_FORM_CONTENT_SIZE = 200000;
    public static final int SESSIONS = 1;
    public static final int SECURITY = 2;
    public static final int NO_SESSIONS = 0;
    public static final int NO_SECURITY = 0;
    private Class<? extends SecurityHandler> _defaultSecurityHandlerClass = ConstraintSecurityHandler.class;
    private final ServletContextApi _servletContext;
    protected ContextStatus _contextStatus = ContextStatus.NOTSET;
    private final Map<String, String> _initParams = new HashMap<String, String>();
    private String _defaultRequestCharacterEncoding;
    private String _defaultResponseCharacterEncoding;
    private String _contextPathEncoded = "/";
    private Map<String, String> _localeEncodingMap;
    private String[] _welcomeFiles;
    private Logger _logger;
    private int _maxFormKeys = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormKeys", 1000);
    private int _maxFormContentSize = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormContentSize", 200000);
    private final List<EventListener> _programmaticListeners = new CopyOnWriteArrayList<EventListener>();
    private final List<ServletContextListener> _servletContextListeners = new CopyOnWriteArrayList<ServletContextListener>();
    private final List<ServletContextListener> _destroyServletContextListeners = new ArrayList<ServletContextListener>();
    private final List<ServletContextAttributeListener> _servletContextAttributeListeners = new CopyOnWriteArrayList<ServletContextAttributeListener>();
    private final List<ServletRequestListener> _servletRequestListeners = new CopyOnWriteArrayList<ServletRequestListener>();
    private final List<ServletRequestAttributeListener> _servletRequestAttributeListeners = new CopyOnWriteArrayList<ServletRequestAttributeListener>();
    private final List<ServletContextScopeListener> _contextListeners = new CopyOnWriteArrayList<ServletContextScopeListener>();
    private final Set<EventListener> _durableListeners = new HashSet<EventListener>();
    protected final DecoratedObjectFactory _objFactory;
    protected SessionHandler _sessionHandler;
    protected SecurityHandler _securityHandler;
    protected ServletHandler _servletHandler;
    protected int _options;
    protected JspConfigDescriptor _jspConfig;
    private boolean _startListeners;

    public static ServletContextHandler getServletContextHandler(ServletContext servletContext, String purpose) {
        if (servletContext instanceof ServletContextApi) {
            ServletContextApi servletContextApi = (ServletContextApi)servletContext;
            return servletContextApi.getContext().getServletContextHandler();
        }
        ServletContextHandler sch = ServletContextHandler.getCurrentServletContextHandler();
        if (sch != null) {
            return sch;
        }
        throw new IllegalStateException("No Jetty ServletContextHandler, " + purpose + " unavailable");
    }

    public static ServletContextHandler getServletContextHandler(ServletContext servletContext) {
        if (servletContext instanceof ServletContextApi) {
            return ((ServletContextApi)servletContext).getContext().getServletContextHandler();
        }
        return ServletContextHandler.getCurrentServletContextHandler();
    }

    public static ServletContext getCurrentServletContext() {
        return ServletContextHandler.getServletContext(ContextHandler.getCurrentContext());
    }

    public static ServletContext getServletContext(Context context) {
        if (context instanceof ServletScopedContext) {
            ServletScopedContext servletScopedContext = (ServletScopedContext)context;
            return servletScopedContext.getServletContext();
        }
        return null;
    }

    public static ServletContextHandler getCurrentServletContextHandler() {
        Context context = ContextHandler.getCurrentContext();
        if (context instanceof ServletScopedContext) {
            ServletScopedContext servletScopedContext = (ServletScopedContext)context;
            return servletScopedContext.getServletContextHandler();
        }
        return null;
    }

    public ServletContextHandler() {
        this(null, null, null, null, null);
    }

    public ServletContextHandler(String contextPath) {
        this(contextPath, null, null, null, null);
    }

    public ServletContextHandler(int options) {
        this(null, options);
    }

    public ServletContextHandler(String contextPath, int options) {
        this(contextPath, null, null, null, null, options);
    }

    public ServletContextHandler(String contextPath, boolean sessions, boolean security) {
        this(contextPath, (sessions ? 1 : 0) | (security ? 2 : 0));
    }

    public ServletContextHandler(SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this(null, sessionHandler, securityHandler, servletHandler, errorHandler);
    }

    public ServletContextHandler(String contextPath, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this(contextPath, sessionHandler, securityHandler, servletHandler, errorHandler, 0);
    }

    public ServletContextHandler(String contextPath, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler, int options) {
        this._servletContext = this.newServletContextApi();
        if (contextPath != null) {
            this.setContextPath(contextPath);
        }
        this._options = options;
        this._sessionHandler = sessionHandler;
        this._securityHandler = securityHandler;
        this._servletHandler = servletHandler;
        this.setErrorHandler((Request.Handler)errorHandler);
        this._objFactory = new DecoratedObjectFactory();
        this.installBean(this._objFactory, true);
        this.relinkHandlers();
    }

    public void setTempDirectory(File tempDirectory) {
        super.setTempDirectory(tempDirectory);
        this.setAttribute("jakarta.servlet.context.tempdir", this.getTempDirectory());
    }

    public ServletContextApi newServletContextApi() {
        return new ServletContextApi();
    }

    public Invocable.InvocationType getInvocationType() {
        return Invocable.InvocationType.BLOCKING;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new ClassLoaderDump(this.getClassLoader()), Dumpable.named((String)("context " + String.valueOf((Object)this)), (Object)((Object)this.getContext())), Dumpable.named((String)("handler attributes " + String.valueOf((Object)this)), (Object)this.getContext().getPersistentAttributes()), new DumpableCollection("initparams " + String.valueOf((Object)this), this.getInitParams().entrySet())});
    }

    @Deprecated(forRemoval=true, since="12.1.0")
    public boolean isUsingSecurityManager() {
        return false;
    }

    @Deprecated(forRemoval=true, since="12.1.0")
    public void setUsingSecurityManager(boolean usingSecurityManager) {
        if (usingSecurityManager) {
            throw new UnsupportedOperationException("SecurityManager not supported");
        }
    }

    public String getContextPathEncoded() {
        return this._contextPathEncoded;
    }

    public String getRequestContextPath() {
        String contextPathEncoded = this.getContextPathEncoded();
        return "/".equals(contextPathEncoded) ? "" : contextPathEncoded;
    }

    public String getInitParameter(String name) {
        return this._initParams.get(name);
    }

    public String setInitParameter(String name, String value) {
        return this._initParams.put(name, value);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    @ManagedAttribute(value="Initial Parameter map for the context")
    public Map<String, String> getInitParams() {
        return this._initParams;
    }

    public boolean removeEventListener(EventListener listener) {
        if (super.removeEventListener(listener)) {
            if (listener instanceof ServletContextScopeListener) {
                this._contextListeners.remove(listener);
            }
            if (listener instanceof ServletContextListener) {
                this._servletContextListeners.remove(listener);
                this._destroyServletContextListeners.remove(listener);
            }
            if (listener instanceof ServletContextAttributeListener) {
                this._servletContextAttributeListeners.remove(listener);
            }
            if (listener instanceof ServletRequestListener) {
                this._servletRequestListeners.remove(listener);
            }
            if (listener instanceof ServletRequestAttributeListener) {
                this._servletRequestAttributeListeners.remove(listener);
            }
            return true;
        }
        return false;
    }

    protected void addProgrammaticListener(EventListener listener) {
        this._programmaticListeners.add(listener);
    }

    public boolean isProgrammaticListener(EventListener listener) {
        return this._programmaticListeners.contains(listener);
    }

    public boolean isDurableListener(EventListener listener) {
        if (this.isStarted()) {
            return this._durableListeners.contains(listener);
        }
        return this.getEventListeners().contains(listener);
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    private String getLogNameSuffix() {
        String logName = this.getDisplayName();
        if (StringUtil.isBlank((String)logName)) {
            logName = this.getContextPath();
            if (logName != null && logName.startsWith("/")) {
                logName = logName.substring(1);
            }
            if (StringUtil.isBlank((String)logName)) {
                logName = "ROOT";
            }
        }
        return "." + logName.replaceAll("\\W", "_");
    }

    public void contextInitialized() throws Exception {
        if (this._contextStatus == ContextStatus.NOTSET) {
            this._contextStatus = ContextStatus.INITIALIZED;
            this._destroyServletContextListeners.clear();
            if (!this._servletContextListeners.isEmpty()) {
                ServletContextEvent event = new ServletContextEvent(this.getServletContext());
                for (ServletContextListener listener : this._servletContextListeners) {
                    this.callContextInitialized(listener, event);
                    this._destroyServletContextListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed() throws Exception {
        if (Objects.requireNonNull(this._contextStatus) == ContextStatus.INITIALIZED) {
            try {
                Throwable multiException = null;
                ServletContextEvent event = new ServletContextEvent(this.getServletContext());
                ListIterator i = TypeUtil.listIteratorAtEnd(this._destroyServletContextListeners);
                while (i.hasPrevious()) {
                    try {
                        this.callContextDestroyed((ServletContextListener)i.previous(), event);
                    }
                    catch (Exception x) {
                        multiException = ExceptionUtil.combine(multiException, (Throwable)x);
                    }
                }
                ExceptionUtil.ifExceptionThrow(multiException);
            }
            finally {
                this._contextStatus = ContextStatus.DESTROYED;
            }
        }
    }

    protected void requestInitialized(Request baseRequest, HttpServletRequest request) {
        ServletContextRequest scopedRequest = (ServletContextRequest)Request.as((Request)baseRequest, ServletContextRequest.class);
        if (!this._servletRequestAttributeListeners.isEmpty()) {
            for (ServletRequestAttributeListener l : this._servletRequestAttributeListeners) {
                scopedRequest.addEventListener((EventListener)l);
            }
        }
        if (!this._servletRequestListeners.isEmpty()) {
            ServletRequestEvent sre = new ServletRequestEvent(this.getServletContext(), (ServletRequest)request);
            for (ServletRequestListener l : this._servletRequestListeners) {
                l.requestInitialized(sre);
            }
        }
    }

    protected void requestDestroyed(Request baseRequest, HttpServletRequest request) {
        ServletContextRequest scopedRequest = (ServletContextRequest)Request.as((Request)baseRequest, ServletContextRequest.class);
        if (!this._servletRequestListeners.isEmpty()) {
            ServletRequestEvent sre = new ServletRequestEvent(this.getServletContext(), (ServletRequest)request);
            ListIterator i = TypeUtil.listIteratorAtEnd(this._servletRequestListeners);
            while (i.hasPrevious()) {
                ((ServletRequestListener)i.previous()).requestDestroyed(sre);
            }
        }
        if (!this._servletRequestAttributeListeners.isEmpty()) {
            ListIterator i = TypeUtil.listIteratorAtEnd(this._servletRequestAttributeListeners);
            while (i.hasPrevious()) {
                scopedRequest.removeEventListener((EventListener)i.previous());
            }
        }
    }

    public void setDefaultRequestCharacterEncoding(String encoding) {
        this._defaultRequestCharacterEncoding = encoding;
    }

    public String getDefaultRequestCharacterEncoding() {
        return this._defaultRequestCharacterEncoding;
    }

    public void setDefaultResponseCharacterEncoding(String encoding) {
        this._defaultResponseCharacterEncoding = encoding;
    }

    public String getDefaultResponseCharacterEncoding() {
        return this._defaultResponseCharacterEncoding;
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null) {
            throw new IllegalArgumentException("null contextPath");
        }
        if (contextPath.endsWith("/*")) {
            LOG.warn("{} contextPath ends with /*", (Object)this);
            contextPath = contextPath.substring(0, contextPath.length() - 2);
        } else if (contextPath.length() > 1 && contextPath.endsWith("/")) {
            LOG.warn("{} contextPath ends with /", (Object)this);
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        if (contextPath.isEmpty()) {
            LOG.warn("Empty contextPath");
            contextPath = "/";
        }
        super.setContextPath(contextPath);
        this._contextPathEncoded = URIUtil.canonicalPath((String)contextPath);
        if (this.getServer() != null && (this.getServer().isStarting() || this.getServer().isStarted())) {
            Class<ContextHandlerCollection> handlerClass = ContextHandlerCollection.class;
            List contextCollections = this.getServer().getDescendants(handlerClass);
            if (contextCollections != null) {
                for (Handler contextCollection : contextCollections) {
                    ((ContextHandlerCollection)handlerClass.cast(contextCollection)).mapContexts();
                }
            }
        }
    }

    public void setWelcomeFiles(String[] files) {
        this._welcomeFiles = files;
    }

    @ManagedAttribute(value="Partial URIs of directory welcome files", readonly=true)
    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    @ManagedAttribute(value="The maximum content size")
    public int getMaxFormContentSize() {
        return this._maxFormContentSize;
    }

    public void setMaxFormContentSize(int maxSize) {
        if (maxSize < 0) {
            maxSize = Integer.getInteger(MAX_FORM_CONTENT_SIZE_KEY, 200000);
        }
        this._maxFormContentSize = maxSize;
    }

    @ManagedAttribute(value="The maximum number of form keys")
    public int getMaxFormKeys() {
        return this._maxFormKeys;
    }

    public void setMaxFormKeys(int max) {
        if (max < 0) {
            max = Integer.getInteger(MAX_FORM_KEYS_KEY, 1000);
        }
        this._maxFormKeys = max;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            return Loader.loadClass((String)className);
        }
        return loader.loadClass(className);
    }

    public void addLocaleEncoding(String locale, String encoding) {
        if (this._localeEncodingMap == null) {
            this._localeEncodingMap = new HashMap<String, String>();
        }
        this._localeEncodingMap.put(locale, encoding);
    }

    public String getLocaleEncoding(String locale) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        return this._localeEncodingMap.get(locale);
    }

    public String getLocaleEncoding(Locale locale) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        String encoding = this._localeEncodingMap.get(locale.toString());
        if (encoding == null) {
            encoding = this._localeEncodingMap.get(locale.getLanguage());
        }
        return encoding;
    }

    public Map<String, String> getLocaleEncodings() {
        if (this._localeEncodingMap == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._localeEncodingMap);
    }

    public Resource getResource(String pathInContext) throws MalformedURLException {
        if (pathInContext == null || !pathInContext.startsWith("/")) {
            throw new MalformedURLException(pathInContext);
        }
        Resource baseResource = this.getBaseResource();
        if (baseResource == null) {
            return null;
        }
        try {
            return baseResource.resolve(pathInContext);
        }
        catch (Exception e) {
            LOG.trace("IGNORE", (Throwable)e);
            return null;
        }
    }

    public Resource newResource(URL url) throws IOException {
        return ResourceFactory.of((Container)this).newResource(url);
    }

    public Resource newResource(URI uri) {
        return ResourceFactory.of((Container)this).newResource(uri);
    }

    public Resource newResource(String urlOrPath) {
        return ResourceFactory.of((Container)this).newResource(urlOrPath);
    }

    public Set<String> getResourcePaths(String path) {
        try {
            Resource resource = this.getResource((String)path);
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            HashSet<String> set = new HashSet<String>();
            for (Resource item : resource.list()) {
                String entry = (String)path + item.getFileName();
                if (item.isDirectory()) {
                    entry = entry + "/";
                }
                set.add(entry);
            }
            return set;
        }
        catch (Exception e) {
            LOG.trace("IGNORED", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public ServletContext getServletContext() {
        return this.getContext().getServletContext();
    }

    protected ContextHandler.ScopedContext newContext() {
        return new ServletScopedContext();
    }

    public ServletScopedContext getContext() {
        ContextHandler.ScopedContext scopedContext = super.getContext();
        if (scopedContext instanceof ServletScopedContext) {
            ServletScopedContext servletScopedContext = (ServletScopedContext)scopedContext;
            return servletScopedContext;
        }
        throw new IllegalStateException("Context is not ServletScopedContext");
    }

    public boolean addEventListener(EventListener listener) {
        if (super.addEventListener(listener)) {
            if ((listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener || listener instanceof HttpSessionIdListener) && this._sessionHandler != null) {
                this._sessionHandler.addEventListener(listener);
            }
            if (listener instanceof ServletContextScopeListener) {
                Context currentContext = ContextHandler.getCurrentContext();
                this._contextListeners.add((ServletContextScopeListener)listener);
                if (currentContext != null) {
                    ((ServletContextScopeListener)listener).enterScope(this.getContext(), null);
                }
            }
            if (listener instanceof ServletContextListener) {
                if (this._contextStatus == ContextStatus.INITIALIZED) {
                    ServletContextListener scl = (ServletContextListener)listener;
                    this._destroyServletContextListeners.add(scl);
                    if (this.isStarting()) {
                        LOG.warn("ContextListener {} added whilst starting {}", (Object)scl, (Object)this);
                        this.callContextInitialized(scl, new ServletContextEvent(this.getServletContext()));
                    } else {
                        LOG.warn("ContextListener {} added after starting {}", (Object)scl, (Object)this);
                    }
                }
                this._servletContextListeners.add((ServletContextListener)listener);
            }
            if (listener instanceof ServletContextAttributeListener) {
                this._servletContextAttributeListeners.add((ServletContextAttributeListener)listener);
            }
            if (listener instanceof ServletRequestListener) {
                this._servletRequestListeners.add((ServletRequestListener)listener);
            }
            if (listener instanceof ServletRequestAttributeListener) {
                this._servletRequestAttributeListeners.add((ServletRequestAttributeListener)listener);
            }
            return true;
        }
        return false;
    }

    public void setHandler(Handler handler) {
        if (handler instanceof SessionHandler) {
            this.setSessionHandler((SessionHandler)handler);
        } else if (handler instanceof SecurityHandler) {
            this.setSecurityHandler((SecurityHandler)handler);
        } else if (handler instanceof ServletHandler) {
            this.setServletHandler((ServletHandler)handler);
        } else {
            if (handler != null) {
                LOG.warn("ServletContextHandler.setHandler should not be called directly. Use insertHandler or setSessionHandler etc.");
            }
            super.setHandler(handler);
            this.relinkHandlers();
        }
    }

    private void doSetHandler(Handler.Singleton wrapper, Handler handler) {
        if (wrapper == this) {
            super.setHandler(handler);
        } else {
            wrapper.setHandler(handler);
        }
    }

    private void relinkHandlers() {
        Handler.Singleton wrapped;
        Handler handler;
        Object handler2 = this;
        if (this.getSessionHandler() != null) {
            while (!(handler2.getHandler() instanceof SessionHandler) && !(handler2.getHandler() instanceof SecurityHandler) && !(handler2.getHandler() instanceof ServletHandler) && (handler = handler2.getHandler()) instanceof Handler.Singleton) {
                wrapped = (Handler.Singleton)handler;
                handler2 = wrapped;
            }
            if (handler2.getHandler() != this._sessionHandler) {
                this.doSetHandler((Handler.Singleton)handler2, (Handler)this._sessionHandler);
            }
            handler2 = this._sessionHandler;
        }
        if (this.getSecurityHandler() != null) {
            while (!(handler2.getHandler() instanceof SecurityHandler) && !(handler2.getHandler() instanceof ServletHandler) && (handler = handler2.getHandler()) instanceof Handler.Singleton) {
                wrapped = (Handler.Singleton)handler;
                handler2 = wrapped;
            }
            if (handler2.getHandler() != this._securityHandler) {
                this.doSetHandler((Handler.Singleton)handler2, (Handler)this._securityHandler);
            }
            handler2 = this._securityHandler;
        }
        if (this.getServletHandler() != null) {
            while (!(handler2.getHandler() instanceof ServletHandler) && (handler = handler2.getHandler()) instanceof Handler.Singleton) {
                wrapped = (Handler.Singleton)handler;
                handler2 = wrapped;
            }
            if (handler2.getHandler() != this._servletHandler) {
                this.doSetHandler((Handler.Singleton)handler2, (Handler)this._servletHandler);
            }
        }
    }

    protected void doStart() throws Exception {
        this._objFactory.addDecorator((Decorator)new DeprecationWarning());
        this.getServletContext().setAttribute(DecoratedObjectFactory.ATTR, (Object)this._objFactory);
        if (this.getContextPath() == null) {
            throw new IllegalStateException("Null contextPath");
        }
        Resource baseResource = this.getBaseResource();
        if (baseResource != null && baseResource.isAlias()) {
            LOG.warn("BaseResource {} is aliased to {} in {}. May not be supported in future releases.", new Object[]{baseResource, baseResource.getRealURI(), this});
        }
        if (this._logger == null) {
            this._logger = LoggerFactory.getLogger((String)(ContextHandler.class.getName() + this.getLogNameSuffix()));
        }
        if (this.getServer() != null) {
            this._servletContext.setAttribute("org.eclipse.jetty.server.Executor", this.getServer().getThreadPool());
        }
        this._durableListeners.addAll(this.getEventListeners());
        this.getContext().call(() -> {
            this.startContext();
            this.contextInitialized();
        }, null);
        LOG.info("Started {}", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        Throwable multiException = null;
        ClassLoader oldClassloader = null;
        ClassLoader oldWebapploader = null;
        Thread currentThread = null;
        Context lastContext = ContextHandler.getCurrentContext();
        ClassLoader lastLoader = this.enterScope(null);
        ServletScopedContext context = this.getContext();
        try {
            ClassLoader loader = this.getClassLoader();
            if (loader != null) {
                oldWebapploader = loader;
                currentThread = Thread.currentThread();
                oldClassloader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(loader);
            }
            this.stopContext();
            this.contextDestroyed();
            this.setEventListeners(this._durableListeners);
            this._durableListeners.clear();
            for (EventListener l : this._programmaticListeners) {
                this.removeEventListener(l);
                if (!(l instanceof ContextHandler.ContextScopeListener)) continue;
                try {
                    ((ContextHandler.ContextScopeListener)l).exitScope((Context)context, null);
                }
                catch (Throwable e) {
                    LOG.warn("Unable to exit scope", e);
                }
            }
            this._programmaticListeners.clear();
        }
        catch (Throwable x) {
            multiException = ExceptionUtil.combine(multiException, (Throwable)x);
        }
        finally {
            this._contextStatus = ContextStatus.NOTSET;
            this.exitScope(null, lastContext, lastLoader);
            LOG.info("Stopped {}", (Object)this);
            if ((oldClassloader == null || oldClassloader != oldWebapploader) && currentThread != null) {
                currentThread.setContextClassLoader(oldClassloader);
            }
        }
        ExceptionUtil.ifExceptionThrow((Throwable)multiException);
        this._objFactory.clear();
        this.getServletContext().removeAttribute(DecoratedObjectFactory.ATTR);
    }

    protected ServletContextRequest newServletContextRequest(ServletChannel servletChannel, Request request, Response response, String decodedPathInContext, MatchedResource<ServletHandler.MappedServlet> matchedResource) {
        return new ServletContextRequest(this._servletContext, servletChannel, request, response, decodedPathInContext, matchedResource, (SessionManager)this.getSessionHandler());
    }

    protected ContextRequest wrapRequest(Request request, Response response) {
        ServletChannel servletChannel;
        ServletChannel sc;
        String decodedPathInContext = URIUtil.decodePath((String)this.getContext().getPathInContext(request.getHttpURI().getCanonicalPath()));
        MatchedResource<ServletHandler.MappedServlet> matchedResource = this._servletHandler.getMatchedServlet(decodedPathInContext);
        if (matchedResource == null) {
            return this.wrapNoServlet(request, response);
        }
        ServletHandler.MappedServlet mappedServlet = (ServletHandler.MappedServlet)matchedResource.getResource();
        if (mappedServlet == null) {
            return this.wrapNoServlet(request, response);
        }
        Attributes cache = request.getComponents().getCache();
        Object cachedChannel = cache.getAttribute(ServletChannel.class.getName());
        if (cachedChannel instanceof ServletChannel && (sc = (ServletChannel)cachedChannel).getContext() == this.getContext() && !sc.isAborted()) {
            servletChannel = sc;
        } else {
            servletChannel = new ServletChannel(this, request);
            cache.setAttribute(ServletChannel.class.getName(), (Object)servletChannel);
        }
        ServletContextRequest servletContextRequest = this.newServletContextRequest(servletChannel, request, response, decodedPathInContext, matchedResource);
        servletChannel.associate(servletContextRequest);
        Request.addCompletionListener((Request)servletContextRequest, servletChannel::recycle);
        return servletContextRequest;
    }

    private ContextRequest wrapNoServlet(Request request, Response response) {
        Handler next = this.getServletHandler().getHandler();
        if (next == null) {
            return null;
        }
        return super.wrapRequest(request, response);
    }

    protected ContextResponse wrapResponse(ContextRequest request, Response response) {
        if (request instanceof ServletContextRequest) {
            ServletContextRequest servletContextRequest = (ServletContextRequest)request;
            return servletContextRequest.getServletContextResponse();
        }
        return super.wrapResponse(request, response);
    }

    protected boolean handleByContextHandler(String pathInContext, ContextRequest request, Response response, Callback callback) {
        boolean initialDispatch = request instanceof ServletContextRequest;
        if (!initialDispatch) {
            return false;
        }
        if (this.isProtectedTarget(pathInContext)) {
            Request.Handler handler = request.getContext().getErrorHandler();
            if (handler instanceof org.eclipse.jetty.server.handler.ErrorHandler) {
                org.eclipse.jetty.server.handler.ErrorHandler errorHandler = (org.eclipse.jetty.server.handler.ErrorHandler)handler;
                return errorHandler.writeError((Request)request, response, callback, 404);
            }
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)404);
            return true;
        }
        return false;
    }

    protected void notifyEnterScope(Request request) {
        super.notifyEnterScope(request);
        ServletContextRequest scopedRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        if (!this._contextListeners.isEmpty()) {
            for (ServletContextScopeListener listener : this._contextListeners) {
                try {
                    listener.enterScope(this.getContext(), scopedRequest);
                }
                catch (Throwable e) {
                    LOG.warn("Unable to enter scope", e);
                }
            }
        }
    }

    protected void notifyExitScope(Request request) {
        ServletContextRequest scopedRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        if (!this._contextListeners.isEmpty()) {
            ListIterator i = TypeUtil.listIteratorAtEnd(this._contextListeners);
            while (i.hasPrevious()) {
                try {
                    ((ServletContextScopeListener)i.previous()).exitScope(this.getContext(), scopedRequest);
                }
                catch (Throwable e) {
                    LOG.warn("Unable to exit scope", e);
                }
            }
        }
        super.notifyExitScope(request);
    }

    public Class<? extends SecurityHandler> getDefaultSecurityHandlerClass() {
        return this._defaultSecurityHandlerClass;
    }

    public void setDefaultSecurityHandlerClass(Class<? extends SecurityHandler> defaultSecurityHandlerClass) {
        this._defaultSecurityHandlerClass = defaultSecurityHandlerClass;
    }

    protected SessionHandler newSessionHandler() {
        return new SessionHandler();
    }

    protected SecurityHandler newSecurityHandler() {
        try {
            return this.getDefaultSecurityHandlerClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected ServletHandler newServletHandler() {
        return new ServletHandler();
    }

    protected void startContext() throws Exception {
        for (ServletContainerInitializerCaller sci : this.getBeans(ServletContainerInitializerCaller.class)) {
            if (!sci.isStopped()) continue;
            sci.start();
            if (!this.isAuto(sci)) continue;
            this.manage(sci);
        }
        if (this._servletHandler != null && this._servletHandler.getListeners() != null) {
            for (ListenerHolder holder : this._servletHandler.getListeners()) {
                holder.start();
            }
        }
        this._startListeners = true;
        String managedAttributes = this._initParams.get("org.eclipse.jetty.server.context.ManagedAttributes");
        if (managedAttributes != null) {
            this.addEventListener((EventListener)((Object)new ManagedAttributeListener(this, StringUtil.csvSplit((String)managedAttributes))));
        }
        super.doStart();
        if (this._servletHandler != null) {
            this._servletHandler.initialize();
        }
    }

    protected void stopContext() throws Exception {
        this._startListeners = false;
        super.doStop();
    }

    @ManagedAttribute(value="context security handler", readonly=true)
    public SecurityHandler getSecurityHandler() {
        if (this._securityHandler == null && (this._options & 2) != 0 && !this.isStarted()) {
            this._securityHandler = this.newSecurityHandler();
        }
        return this._securityHandler;
    }

    @ManagedAttribute(value="context servlet handler", readonly=true)
    public ServletHandler getServletHandler() {
        if (this._servletHandler == null && !this.isStarted()) {
            this._servletHandler = this.newServletHandler();
        }
        return this._servletHandler;
    }

    @ManagedAttribute(value="context session handler", readonly=true)
    public SessionHandler getSessionHandler() {
        if (this._sessionHandler == null && (this._options & 1) != 0 && !this.isStarted()) {
            this._sessionHandler = this.newSessionHandler();
        }
        return this._sessionHandler;
    }

    public ServletHolder addServlet(String className, String pathSpec) {
        return this.getServletHandler().addServletWithMapping(className, pathSpec);
    }

    public ServletHolder addServlet(Class<? extends Servlet> servlet, String pathSpec) {
        return this.getServletHandler().addServletWithMapping(servlet, pathSpec);
    }

    public void addServlet(ServletHolder servlet, String pathSpec) {
        this.getServletHandler().addServletWithMapping(servlet, pathSpec);
    }

    public ServletHolder addServlet(HttpServlet servlet, String pathSpec) {
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        this.getServletHandler().addServletWithMapping(servletHolder, pathSpec);
        return servletHolder;
    }

    public void addFilter(FilterHolder holder, String pathSpec, EnumSet<DispatcherType> dispatches) {
        this.getServletHandler().addFilterWithMapping(holder, pathSpec, dispatches);
    }

    public FilterHolder addFilter(Class<? extends Filter> filterClass, String pathSpec, EnumSet<DispatcherType> dispatches) {
        return this.getServletHandler().addFilterWithMapping(filterClass, pathSpec, dispatches);
    }

    public FilterHolder addFilter(String filterClass, String pathSpec, EnumSet<DispatcherType> dispatches) {
        return this.getServletHandler().addFilterWithMapping(filterClass, pathSpec, dispatches);
    }

    public FilterHolder addFilter(Filter filter, String pathSpec, EnumSet<DispatcherType> dispatches) {
        FilterHolder filterHolder = new FilterHolder(filter);
        this.getServletHandler().addFilterWithMapping(filterHolder, pathSpec, dispatches);
        return filterHolder;
    }

    public ServletContainerInitializerHolder addServletContainerInitializer(ServletContainerInitializer sci) {
        if (!this.isStopped()) {
            throw new IllegalStateException("ServletContainerInitializers should be added before starting");
        }
        ServletContainerInitializerHolder holder = new ServletContainerInitializerHolder(sci, new Class[0]);
        this.addServletContainerInitializer(holder);
        return holder;
    }

    public ServletContainerInitializerHolder addServletContainerInitializer(ServletContainerInitializer sci, Class<?> ... classes) {
        if (!this.isStopped()) {
            throw new IllegalStateException("ServletContainerInitializers should be added before starting");
        }
        ServletContainerInitializerHolder holder = new ServletContainerInitializerHolder(sci, classes);
        this.addServletContainerInitializer(holder);
        return holder;
    }

    public void addServletContainerInitializer(ServletContainerInitializerHolder ... sciHolders) {
        ServletContainerInitializerStarter starter = (ServletContainerInitializerStarter)this.getBean(ServletContainerInitializerStarter.class);
        if (starter == null) {
            starter = new ServletContainerInitializerStarter();
            this.addBean(starter, true);
        }
        starter.addServletContainerInitializerHolders(sciHolders);
    }

    protected ServletRegistration.Dynamic dynamicHolderAdded(ServletHolder holder) {
        return holder.getRegistration();
    }

    protected void addRoles(String ... roleNames) {
        if (this._securityHandler != null && this._securityHandler instanceof ConstraintAware) {
            HashSet<String> union = new HashSet<String>();
            Set<String> existing = ((ConstraintAware)this._securityHandler).getKnownRoles();
            if (existing != null) {
                union.addAll(existing);
            }
            union.addAll(Arrays.asList(roleNames));
            ((ConstraintSecurityHandler)this._securityHandler).setRoles(union);
        }
    }

    public Set<String> setServletSecurity(ServletRegistration.Dynamic registration, ServletSecurityElement servletSecurityElement) {
        Collection pathSpecs = registration.getMappings();
        if (pathSpecs != null) {
            for (String pathSpec : pathSpecs) {
                List<ConstraintMapping> mappings = ConstraintSecurityHandler.createConstraintsWithMappingsForPath(registration.getName(), pathSpec, servletSecurityElement);
                for (ConstraintMapping m : mappings) {
                    ((ConstraintAware)this.getSecurityHandler()).addConstraintMapping(m);
                }
            }
        }
        return Collections.emptySet();
    }

    public void callContextInitialized(ServletContextListener l, ServletContextEvent e) {
        try {
            if (this.isProgrammaticListener((EventListener)l)) {
                this.getContext().getServletContext().setEnabled(false);
            }
            if (this.getServer().isDryRun()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("contextInitialized: {}->{}", (Object)e, (Object)l);
            }
            l.contextInitialized(e);
        }
        finally {
            this.getContext().getServletContext().setEnabled(true);
        }
    }

    public void callContextDestroyed(ServletContextListener l, ServletContextEvent e) {
        if (this.getServer().isDryRun()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("contextDestroyed: {}->{}", (Object)e, (Object)l);
        }
        l.contextDestroyed(e);
    }

    private void replaceHandler(Handler.Singleton handler, Handler.Singleton replacement) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        Handler next = null;
        if (handler != null) {
            next = handler.getHandler();
            handler.setHandler((Handler)null);
            ServletContextHandler wrapper = this;
            while (wrapper != null) {
                Handler.Singleton wrapped;
                if (wrapper.getHandler() == handler) {
                    this.doSetHandler((Handler.Singleton)wrapper, (Handler)replacement);
                    break;
                }
                Handler handler2 = wrapper.getHandler();
                wrapper = handler2 instanceof Handler.Singleton ? (wrapped = (Handler.Singleton)handler2) : null;
            }
        }
        if (next != null && replacement.getHandler() == null) {
            replacement.setHandler(next);
        }
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.replaceHandler(this._sessionHandler, sessionHandler);
        this._sessionHandler = sessionHandler;
        this.relinkHandlers();
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this.replaceHandler((Handler.Singleton)this._securityHandler, (Handler.Singleton)securityHandler);
        this._securityHandler = securityHandler;
        this.relinkHandlers();
    }

    public void setServletHandler(ServletHandler servletHandler) {
        this.replaceHandler((Handler.Singleton)this._servletHandler, (Handler.Singleton)servletHandler);
        this._servletHandler = servletHandler;
        this.relinkHandlers();
    }

    public void insertHandler(Handler.Singleton handler) {
        if (handler instanceof SessionHandler) {
            this.setSessionHandler((SessionHandler)handler);
        } else if (handler instanceof SecurityHandler) {
            this.setSecurityHandler((SecurityHandler)handler);
        } else if (handler instanceof ServletHandler) {
            this.setServletHandler((ServletHandler)handler);
        } else {
            Handler.Singleton tail = handler.getTail();
            if (tail.getHandler() != null) {
                throw new IllegalArgumentException("bad tail of inserted wrapper chain");
            }
            tail.setHandler(this.getHandler());
            super.setHandler((Handler)handler);
            this.relinkHandlers();
        }
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this._objFactory;
    }

    void destroyServlet(Servlet servlet) {
        this.getContext().destroy(servlet);
    }

    void destroyFilter(Filter filter) {
        this.getContext().destroy(filter);
    }

    void destroyListener(EventListener listener) {
        this.getContext().destroy(listener);
    }

    static {
        __environment = ENVIRONMENT = Environment.ensure((String)"ee11", ServletContextHandler.class);
        SERVLET_LISTENER_TYPES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionIdListener.class, HttpSessionListener.class, HttpSessionAttributeListener.class};
    }

    public class ServletContextApi
    implements ServletContext {
        public static final int SERVLET_MAJOR_VERSION = 6;
        public static final int SERVLET_MINOR_VERSION = 1;
        private int _effectiveMajorVersion = 6;
        private int _effectiveMinorVersion = 1;
        protected boolean _enabled = true;
        protected boolean _extendedListenerTypes = false;

        public String getServerInfo() {
            return ServletContextHandler.this.getServer().getServerInfo();
        }

        public int getMajorVersion() {
            return 6;
        }

        public int getMinorVersion() {
            return 1;
        }

        public int getEffectiveMajorVersion() {
            return this._effectiveMajorVersion;
        }

        public int getEffectiveMinorVersion() {
            return this._effectiveMinorVersion;
        }

        public void setEffectiveMajorVersion(int v) {
            this._effectiveMajorVersion = v;
        }

        public void setEffectiveMinorVersion(int v) {
            this._effectiveMinorVersion = v;
        }

        public ServletScopedContext getContext() {
            return ServletContextHandler.this.getContext();
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            ServletContextHandler context = ServletContextHandler.this;
            if (ServletContextHandler.this._servletHandler == null) {
                return null;
            }
            ServletHolder holder = ServletContextHandler.this._servletHandler.getServlet(name);
            if (holder == null || !holder.isEnabled()) {
                return null;
            }
            return new Dispatcher(context, name);
        }

        private void checkDynamic(String name) {
            if (ServletContextHandler.this.isStarted()) {
                throw new IllegalStateException();
            }
            if (ServletContextHandler.this.getServletHandler().isInitialized()) {
                throw new IllegalStateException();
            }
            if (StringUtil.isBlank((String)name)) {
                throw new IllegalArgumentException("Missing name");
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            this.checkDynamic(filterName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterHolder holder = handler.getFilter(filterName);
            if (holder == null) {
                holder = handler.newFilterHolder(Source.JAKARTA_API);
                holder.setName(filterName);
                holder.setHeldClass(filterClass);
                handler.addFilter(holder);
                return holder.getRegistration();
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                holder.setHeldClass(filterClass);
                return holder.getRegistration();
            }
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            this.checkDynamic(filterName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterHolder holder = handler.getFilter(filterName);
            if (holder == null) {
                holder = handler.newFilterHolder(Source.JAKARTA_API);
                holder.setName(filterName);
                holder.setClassName(className);
                handler.addFilter(holder);
                return holder.getRegistration();
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                holder.setClassName(className);
                return holder.getRegistration();
            }
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            this.checkDynamic(filterName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterHolder holder = handler.getFilter(filterName);
            if (holder == null) {
                holder = handler.newFilterHolder(Source.JAKARTA_API);
                holder.setName(filterName);
                holder.setFilter(filter);
                handler.addFilter(holder);
                return holder.getRegistration();
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                holder.setFilter(filter);
                return holder.getRegistration();
            }
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            this.checkDynamic(servletName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder holder = handler.getServlet(servletName);
            if (holder == null) {
                holder = handler.newServletHolder(Source.JAKARTA_API);
                holder.setName(servletName);
                holder.setHeldClass(servletClass);
                handler.addServlet(holder);
                return ServletContextHandler.this.dynamicHolderAdded(holder);
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                holder.setHeldClass(servletClass);
                return holder.getRegistration();
            }
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            this.checkDynamic(servletName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder holder = handler.getServlet(servletName);
            if (holder == null) {
                holder = handler.newServletHolder(Source.JAKARTA_API);
                holder.setName(servletName);
                holder.setClassName(className);
                handler.addServlet(holder);
                return ServletContextHandler.this.dynamicHolderAdded(holder);
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                holder.setClassName(className);
                return holder.getRegistration();
            }
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            this.checkDynamic(servletName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder holder = handler.getServlet(servletName);
            if (holder == null) {
                holder = handler.newServletHolder(Source.JAKARTA_API);
                holder.setName(servletName);
                holder.setServlet(servlet);
                handler.addServlet(holder);
                return ServletContextHandler.this.dynamicHolderAdded(holder);
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                holder.setServlet(servlet);
                return holder.getRegistration();
            }
            return null;
        }

        public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
            this.checkDynamic(servletName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder holder = handler.getServlet(servletName);
            if (holder == null) {
                holder = handler.newServletHolder(Source.JAKARTA_API);
                holder.setName(servletName);
                holder.setForcedPath(jspFile);
                handler.addServlet(holder);
                return ServletContextHandler.this.dynamicHolderAdded(holder);
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null && holder.getForcedPath() == null) {
                holder.setForcedPath(jspFile);
                return holder.getRegistration();
            }
            return null;
        }

        public String getInitParameter(String name) {
            Objects.requireNonNull(name);
            return ServletContextHandler.this.getInitParameter(name);
        }

        public boolean setInitParameter(String name, String value) {
            Objects.requireNonNull(name);
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            if (ServletContextHandler.this.getInitParameter(name) != null) {
                return false;
            }
            ServletContextHandler.this.getInitParams().put(name, value);
            return true;
        }

        public <T> T createInstance(Class<T> clazz) throws ServletException {
            try {
                return (T)this.getContext().decorate(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            if (ServletContextHandler.this._sessionHandler != null) {
                return ServletContextHandler.this._sessionHandler.getDefaultSessionTrackingModes();
            }
            return null;
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            if (ServletContextHandler.this._sessionHandler != null) {
                return ServletContextHandler.this._sessionHandler.getEffectiveSessionTrackingModes();
            }
            return null;
        }

        public FilterRegistration getFilterRegistration(String filterName) {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            FilterHolder holder = ServletContextHandler.this.getServletHandler().getFilter(filterName);
            return holder == null ? null : holder.getRegistration();
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            HashMap<String, FilterRegistration.Dynamic> registrations = new HashMap<String, FilterRegistration.Dynamic>();
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterHolder[] holders = handler.getFilters();
            if (holders != null) {
                for (FilterHolder holder : holders) {
                    registrations.put(holder.getName(), holder.getRegistration());
                }
            }
            return registrations;
        }

        public ServletRegistration getServletRegistration(String servletName) {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            ServletHolder holder = ServletContextHandler.this.getServletHandler().getServlet(servletName);
            return holder == null ? null : holder.getRegistration();
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            HashMap<String, ServletHolder.Registration> registrations = new HashMap<String, ServletHolder.Registration>();
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder[] holders = handler.getServlets();
            if (holders != null) {
                for (ServletHolder holder : holders) {
                    registrations.put(holder.getName(), holder.getRegistration());
                }
            }
            return registrations;
        }

        public SessionCookieConfig getSessionCookieConfig() {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            if (ServletContextHandler.this._sessionHandler != null) {
                return ServletContextHandler.this._sessionHandler.getSessionCookieConfig();
            }
            return null;
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            if (ServletContextHandler.this._sessionHandler != null) {
                ServletContextHandler.this._sessionHandler.setSessionTrackingModes(sessionTrackingModes);
            }
        }

        public int getSessionTimeout() {
            int timeout = -1;
            if (ServletContextHandler.this._sessionHandler != null) {
                timeout = ServletContextHandler.this._sessionHandler.getMaxInactiveInterval();
            }
            return (int)TimeUnit.SECONDS.toMinutes(timeout);
        }

        public void setSessionTimeout(int sessionTimeout) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            if (ServletContextHandler.this._sessionHandler != null) {
                long tmp = TimeUnit.MINUTES.toSeconds(sessionTimeout);
                if (tmp > Integer.MAX_VALUE) {
                    tmp = Integer.MAX_VALUE;
                }
                if (tmp < Integer.MIN_VALUE) {
                    tmp = Integer.MIN_VALUE;
                }
                ServletContextHandler.this._sessionHandler.setMaxInactiveInterval((int)tmp);
            }
        }

        public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            try {
                return (T)((Servlet)this.createInstance(clazz));
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }

        public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            try {
                return (T)((Filter)this.createInstance(clazz));
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }

        public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
            block5: {
                if (!this._enabled) {
                    throw new UnsupportedOperationException();
                }
                try {
                    this.checkListener(clazz);
                }
                catch (IllegalArgumentException e) {
                    if (ServletContextListener.class.isAssignableFrom(clazz)) break block5;
                    throw e;
                }
            }
            try {
                return (T)((EventListener)this.createInstance(clazz));
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }

        public void addListener(String className) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            try {
                Class<?> clazz;
                ClassLoader classLoader = ServletContextHandler.this.getClassLoader();
                Class<?> clazz2 = clazz = classLoader == null ? Loader.loadClass((String)className) : classLoader.loadClass(className);
                if (!this._enabled) {
                    throw new UnsupportedOperationException();
                }
                try {
                    EventListener result;
                    try {
                        result = (EventListener)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                    EventListener el = result;
                    this.addListener(el);
                }
                catch (ServletException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public <T extends EventListener> void addListener(T t) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            this.checkListener(t.getClass());
            ListenerHolder holder = ServletContextHandler.this.getServletHandler().newListenerHolder(Source.JAKARTA_API);
            holder.setListener(t);
            ServletContextHandler.this.addProgrammaticListener(t);
            ServletContextHandler.this.getServletHandler().addListener(holder);
            if (ServletContextHandler.this._startListeners) {
                try {
                    holder.start();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        public void addListener(Class<? extends EventListener> listenerClass) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            try {
                EventListener result;
                try {
                    result = listenerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                EventListener el = result;
                this.addListener(el);
            }
            catch (ServletException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            return ServletContextHandler.this._jspConfig;
        }

        public void setJspConfigDescriptor(JspConfigDescriptor d) {
            ServletContextHandler.this._jspConfig = d;
        }

        public void declareRoles(String ... roleNames) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            ServletContextHandler.this.addRoles(roleNames);
        }

        public String getRequestCharacterEncoding() {
            return ServletContextHandler.this.getDefaultRequestCharacterEncoding();
        }

        public void setRequestCharacterEncoding(String encoding) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            ServletContextHandler.this.setDefaultRequestCharacterEncoding(encoding);
        }

        public String getResponseCharacterEncoding() {
            return ServletContextHandler.this.getDefaultResponseCharacterEncoding();
        }

        public void setResponseCharacterEncoding(String encoding) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            ServletContextHandler.this.setDefaultResponseCharacterEncoding(encoding);
        }

        public ContextHandler getContextHandler() {
            return ServletContextHandler.this;
        }

        public ServletContext getContext(String path) {
            ContextHandler context = this.getContextHandler().getCrossContextHandler(path);
            if (context == null) {
                return null;
            }
            if (context == ServletContextHandler.this) {
                return this;
            }
            return new CrossContextServletContext(ServletContextHandler.this, context.getContext());
        }

        public String getMimeType(String file) {
            return this.getContext().getMimeTypes().getMimeByExtension(file);
        }

        public RequestDispatcher getRequestDispatcher(String uriInContext) {
            if (uriInContext == null) {
                return null;
            }
            if (!uriInContext.startsWith("/")) {
                return null;
            }
            try {
                String contextPath = this.getContextPath();
                HttpURI.Mutable uri = HttpURI.build((String)uriInContext);
                String encodedPathInContext = uri.getCanonicalPath();
                if (StringUtil.isEmpty((String)encodedPathInContext)) {
                    return null;
                }
                if (!StringUtil.isEmpty((String)contextPath)) {
                    uri.path(URIUtil.addPaths((String)contextPath, (String)uri.getPath()));
                    encodedPathInContext = uri.getCanonicalPath().substring(contextPath.length());
                }
                return new Dispatcher(ServletContextHandler.this, (HttpURI)uri, URIUtil.decodePath((String)encodedPathInContext));
            }
            catch (Exception e) {
                LOG.trace("IGNORED", (Throwable)e);
                return null;
            }
        }

        public String getRealPath(String path) {
            if ((path = URIUtil.normalizePath((String)path)) == null) {
                return null;
            }
            if (((String)path).isEmpty()) {
                path = "/";
            } else if (((String)path).charAt(0) != '/') {
                path = "/" + (String)path;
            }
            try {
                Resource resource = ServletContextHandler.this.getResource((String)path);
                if (resource == null) {
                    return null;
                }
                for (Resource r : resource) {
                    Path resourcePath;
                    if (!Resources.exists((Resource)r) || (resourcePath = r.getPath()) == null) continue;
                    Object realPath = resourcePath.normalize().toString();
                    if (Files.isDirectory(resourcePath, new LinkOption[0])) {
                        realPath = (String)realPath + "/";
                    }
                    return realPath;
                }
                return null;
            }
            catch (Exception e) {
                LOG.trace("IGNORED", (Throwable)e);
                return null;
            }
        }

        public URL getResource(String path) throws MalformedURLException {
            if ((path = URIUtil.normalizePath((String)path)) == null) {
                return null;
            }
            Resource resource = ServletContextHandler.this.getResource(path);
            if (resource == null) {
                return null;
            }
            for (Resource r : resource) {
                if (!Resources.exists((Resource)r)) continue;
                return r.getURI().toURL();
            }
            return null;
        }

        public InputStream getResourceAsStream(String path) {
            try {
                URL url = this.getResource(path);
                if (url == null) {
                    return null;
                }
                Resource r = ResourceFactory.of((Container)ServletContextHandler.this).newResource(url);
                if (r.isDirectory()) {
                    return null;
                }
                return IOResources.asInputStream((Resource)r);
            }
            catch (Exception e) {
                LOG.trace("IGNORED", (Throwable)e);
                return null;
            }
        }

        public Set<String> getResourcePaths(String path) {
            if ((path = URIUtil.normalizePath((String)path)) == null) {
                return null;
            }
            return ServletContextHandler.this.getResourcePaths(path);
        }

        public void log(String msg) {
            ServletContextHandler.this.getLogger().info(msg);
        }

        public void log(String message, Throwable throwable) {
            if (throwable == null) {
                ServletContextHandler.this.getLogger().warn(message);
            } else {
                ServletContextHandler.this.getLogger().warn(message, throwable);
            }
        }

        public Enumeration<String> getInitParameterNames() {
            return ServletContextHandler.this.getInitParameterNames();
        }

        public Object getAttribute(String name) {
            return this.getContext().getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.getContext().getAttributeNameSet());
        }

        public void setAttribute(String name, Object value) {
            Object oldValue = this.getContext().setAttribute(name, value);
            if (!ServletContextHandler.this._servletContextAttributeListeners.isEmpty()) {
                ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)ServletContextHandler.this._servletContext, name, oldValue == null ? value : oldValue);
                for (ServletContextAttributeListener listener : ServletContextHandler.this._servletContextAttributeListeners) {
                    if (oldValue == null) {
                        listener.attributeAdded(event);
                        continue;
                    }
                    if (value == null) {
                        listener.attributeRemoved(event);
                        continue;
                    }
                    listener.attributeReplaced(event);
                }
            }
        }

        public void removeAttribute(String name) {
            Object oldValue = this.getContext().removeAttribute(name);
            if (oldValue != null && !ServletContextHandler.this._servletContextAttributeListeners.isEmpty()) {
                ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)ServletContextHandler.this._servletContext, name, oldValue);
                for (ServletContextAttributeListener listener : ServletContextHandler.this._servletContextAttributeListeners) {
                    listener.attributeRemoved(event);
                }
            }
        }

        public String getServletContextName() {
            String name = ServletContextHandler.this.getDisplayName();
            if (name == null) {
                name = ServletContextHandler.this.getContextPath();
            }
            return name;
        }

        public String getContextPath() {
            return ServletContextHandler.this.getRequestContextPath();
        }

        public String toString() {
            return "ServletContext@" + String.valueOf((Object)ServletContextHandler.this);
        }

        public void checkListener(Class<? extends EventListener> listener) throws IllegalStateException {
            int startIndex;
            boolean ok = false;
            for (int i = startIndex = this.isExtendedListenerTypes() ? 0 : 1; i < SERVLET_LISTENER_TYPES.length; ++i) {
                if (!SERVLET_LISTENER_TYPES[i].isAssignableFrom(listener)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new IllegalArgumentException("Inappropriate listener class " + listener.getName());
            }
        }

        public void setExtendedListenerTypes(boolean extended) {
            this._extendedListenerTypes = extended;
        }

        public boolean isExtendedListenerTypes() {
            return this._extendedListenerTypes;
        }

        public ClassLoader getClassLoader() {
            return ServletContextHandler.this.getClassLoader();
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public String getVirtualServerName() {
            List hosts = ServletContextHandler.this.getVirtualHosts();
            if (hosts != null && !hosts.isEmpty()) {
                return (String)hosts.get(0);
            }
            return null;
        }
    }

    public class ServletScopedContext
    extends ContextHandler.ScopedContext {
        public ServletScopedContext() {
            super((ContextHandler)ServletContextHandler.this);
        }

        public ServletContextApi getServletContext() {
            return ServletContextHandler.this._servletContext;
        }

        public ServletContextHandler getServletContextHandler() {
            return ServletContextHandler.this;
        }

        protected DecoratedObjectFactory getDecoratedObjectFactory() {
            return ServletContextHandler.this._objFactory;
        }

        public <T> T createInstance(BaseHolder<T> holder) throws ServletException {
            try {
                Object object;
                DecoratedObjectFactory.associateInfo(holder);
                try {
                    T t = holder.getHeldClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    object = this.decorate(t);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                return (T)object;
            }
            finally {
                DecoratedObjectFactory.disassociateInfo();
            }
        }

        public <T extends Filter> void destroyFilter(T f) {
            ServletContextHandler.this._objFactory.destroy(f);
        }

        public <T extends Servlet> void destroyServlet(T s) {
            ServletContextHandler.this._objFactory.destroy(s);
        }

        public void setExtendedListenerTypes(boolean b) {
            ServletContextHandler.this._servletContext.setExtendedListenerTypes(b);
        }
    }

    public static enum ContextStatus {
        NOTSET,
        INITIALIZED,
        DESTROYED;

    }

    public static interface ServletContextScopeListener
    extends EventListener {
        public void enterScope(ServletScopedContext var1, ServletContextRequest var2);

        public void exitScope(ServletScopedContext var1, ServletContextRequest var2);
    }

    public static interface ServletContainerInitializerCaller
    extends LifeCycle {
    }

    public static class ServletContainerInitializerStarter
    extends ContainerLifeCycle
    implements ServletContainerInitializerCaller {
        public void addServletContainerInitializerHolders(ServletContainerInitializerHolder ... holders) {
            for (ServletContainerInitializerHolder holder : holders) {
                this.addBean((Object)holder, true);
            }
        }

        public Collection<ServletContainerInitializerHolder> getServletContainerInitializerHolders() {
            return this.getContainedBeans(ServletContainerInitializerHolder.class);
        }

        protected void doStart() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting SCIs");
            }
            super.doStart();
        }

        protected void doStop() throws Exception {
            Collection<ServletContainerInitializerHolder> holders = this.getServletContainerInitializerHolders();
            for (ServletContainerInitializerHolder h : holders) {
                if (h.getSource().getOrigin() == Source.Origin.EMBEDDED) continue;
                this.removeBean((Object)h);
            }
            super.doStop();
        }
    }

    public static interface ServletResponseInfo {
        public String getCharacterEncoding(boolean var1);

        public String getCharacterEncoding();

        public String getContentType();

        public ServletContextResponse.EncodingFrom getEncodingFrom();

        public Locale getLocale();

        public ServletContextResponse.OutputType getOutputType();

        public Response getResponse();

        public Supplier<Map<String, String>> getTrailers();

        public ResponseWriter getWriter();

        public boolean isWriting();

        public void setCharacterEncoding(String var1, ServletContextResponse.EncodingFrom var2);

        public void setLocale(Locale var1);

        public void setOutputType(ServletContextResponse.OutputType var1);

        public void setTrailers(Supplier<Map<String, String>> var1);

        public void setWriter(ResponseWriter var1);
    }

    public static interface ServletRequestInfo {
        public String getDecodedPathInContext();

        public ManagedSession getManagedSession();

        public Charset getQueryEncoding();

        default public Request getRequest() {
            return this.getServletChannel().getRequest();
        }

        public List<ServletRequestAttributeListener> getRequestAttributeListeners();

        public ServletScopedContext getServletContext();

        public HttpInput getHttpInput();

        public MatchedResource<ServletHandler.MappedServlet> getMatchedResource();

        public AbstractSessionManager.RequestedSession getRequestedSession();

        public ServletChannel getServletChannel();

        public ServletContextHandler getServletContextHandler();

        public ServletChannelState getServletRequestState();

        public SessionManager getSessionManager();

        public ServletChannelState getState();

        public void setQueryEncoding(String var1);
    }

    public static class JspConfig
    implements JspConfigDescriptor {
        private final List<TaglibDescriptor> _taglibs = new ArrayList<TaglibDescriptor>();
        private final List<JspPropertyGroupDescriptor> _jspPropertyGroups = new ArrayList<JspPropertyGroupDescriptor>();

        public Collection<TaglibDescriptor> getTaglibs() {
            return new ArrayList<TaglibDescriptor>(this._taglibs);
        }

        public void addTaglibDescriptor(TaglibDescriptor d) {
            this._taglibs.add(d);
        }

        public Collection<JspPropertyGroupDescriptor> getJspPropertyGroups() {
            return new ArrayList<JspPropertyGroupDescriptor>(this._jspPropertyGroups);
        }

        public void addJspPropertyGroup(JspPropertyGroupDescriptor g) {
            this._jspPropertyGroups.add(g);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("JspConfigDescriptor: \n");
            for (TaglibDescriptor taglib : this._taglibs) {
                sb.append(taglib).append("\n");
            }
            for (JspPropertyGroupDescriptor jpg : this._jspPropertyGroups) {
                sb.append(jpg).append("\n");
            }
            return sb.toString();
        }
    }

    public static class TagLib
    implements TaglibDescriptor {
        private String _uri;
        private String _location;

        public String getTaglibURI() {
            return this._uri;
        }

        public void setTaglibURI(String uri) {
            this._uri = uri;
        }

        public String getTaglibLocation() {
            return this._location;
        }

        public void setTaglibLocation(String location) {
            this._location = location;
        }

        public String toString() {
            return "TagLibDescriptor: taglib-uri=" + this._uri + " location=" + this._location;
        }
    }

    public static class JspPropertyGroup
    implements JspPropertyGroupDescriptor {
        private final List<String> _urlPatterns = new ArrayList<String>();
        private String _elIgnored;
        private String _pageEncoding;
        private String _scriptingInvalid;
        private String _isXml;
        private final List<String> _includePreludes = new ArrayList<String>();
        private final List<String> _includeCodas = new ArrayList<String>();
        private String _deferredSyntaxAllowedAsLiteral;
        private String _trimDirectiveWhitespaces;
        private String _defaultContentType;
        private String _buffer;
        private String _errorOnUndeclaredNamespace;
        private String _errorOnELNotFound;

        public Collection<String> getUrlPatterns() {
            return new ArrayList<String>(this._urlPatterns);
        }

        public void addUrlPattern(String s) {
            if (!this._urlPatterns.contains(s)) {
                this._urlPatterns.add(s);
            }
        }

        public String getElIgnored() {
            return this._elIgnored;
        }

        public String getErrorOnELNotFound() {
            return this._errorOnELNotFound;
        }

        public void setElIgnored(String s) {
            this._elIgnored = s;
        }

        public String getPageEncoding() {
            return this._pageEncoding;
        }

        public void setPageEncoding(String pageEncoding) {
            this._pageEncoding = pageEncoding;
        }

        public void setScriptingInvalid(String scriptingInvalid) {
            this._scriptingInvalid = scriptingInvalid;
        }

        public void setIsXml(String isXml) {
            this._isXml = isXml;
        }

        public void setDeferredSyntaxAllowedAsLiteral(String deferredSyntaxAllowedAsLiteral) {
            this._deferredSyntaxAllowedAsLiteral = deferredSyntaxAllowedAsLiteral;
        }

        public void setTrimDirectiveWhitespaces(String trimDirectiveWhitespaces) {
            this._trimDirectiveWhitespaces = trimDirectiveWhitespaces;
        }

        public void setDefaultContentType(String defaultContentType) {
            this._defaultContentType = defaultContentType;
        }

        public void setBuffer(String buffer) {
            this._buffer = buffer;
        }

        public void setErrorOnUndeclaredNamespace(String errorOnUndeclaredNamespace) {
            this._errorOnUndeclaredNamespace = errorOnUndeclaredNamespace;
        }

        public void setErrorOnELNotFound(String errorOnELNotFound) {
            this._errorOnELNotFound = errorOnELNotFound;
        }

        public String getScriptingInvalid() {
            return this._scriptingInvalid;
        }

        public String getIsXml() {
            return this._isXml;
        }

        public Collection<String> getIncludePreludes() {
            return new ArrayList<String>(this._includePreludes);
        }

        public void addIncludePrelude(String prelude) {
            if (!this._includePreludes.contains(prelude)) {
                this._includePreludes.add(prelude);
            }
        }

        public Collection<String> getIncludeCodas() {
            return new ArrayList<String>(this._includeCodas);
        }

        public void addIncludeCoda(String coda) {
            if (!this._includeCodas.contains(coda)) {
                this._includeCodas.add(coda);
            }
        }

        public String getDeferredSyntaxAllowedAsLiteral() {
            return this._deferredSyntaxAllowedAsLiteral;
        }

        public String getTrimDirectiveWhitespaces() {
            return this._trimDirectiveWhitespaces;
        }

        public String getDefaultContentType() {
            return this._defaultContentType;
        }

        public String getBuffer() {
            return this._buffer;
        }

        public String getErrorOnUndeclaredNamespace() {
            return this._errorOnUndeclaredNamespace;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("JspPropertyGroupDescriptor:");
            sb.append(" error-on-el-not-found=").append(this._errorOnELNotFound);
            sb.append(" el-ignored=").append(this._elIgnored);
            sb.append(" is-xml=").append(this._isXml);
            sb.append(" page-encoding=").append(this._pageEncoding);
            sb.append(" scripting-invalid=").append(this._scriptingInvalid);
            sb.append(" deferred-syntax-allowed-as-literal=").append(this._deferredSyntaxAllowedAsLiteral);
            sb.append(" trim-directive-whitespaces").append(this._trimDirectiveWhitespaces);
            sb.append(" default-content-type=").append(this._defaultContentType);
            sb.append(" buffer=").append(this._buffer);
            sb.append(" error-on-undeclared-namespace=").append(this._errorOnUndeclaredNamespace);
            for (String prelude : this._includePreludes) {
                sb.append(" include-prelude=").append(prelude);
            }
            for (String coda : this._includeCodas) {
                sb.append(" include-coda=").append(coda);
            }
            return sb.toString();
        }
    }
}

