/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import org.apache.daffodil.runtime1.dsom.DPathElementCompileInfo;
import org.apache.daffodil.runtime1.processors.CalendarLanguageEv;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.Evaluatable$;
import org.apache.daffodil.runtime1.processors.InfosetCachedEvaluatable;
import org.apache.daffodil.runtime1.processors.ParseOrUnparseState;
import scala.Option;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;

public class CalendarEv
extends Evaluatable<Calendar>
implements InfosetCachedEvaluatable<Calendar> {
    private final CalendarLanguageEv localeEv;
    private final Option<TimeZone> calendarTz;
    private final int firstDay;
    private final int calendarDaysInFirstWeek;
    private final boolean calendarCheckPolicy;

    public CalendarEv(CalendarLanguageEv localeEv, Option<TimeZone> calendarTz, int firstDay, int calendarDaysInFirstWeek, boolean calendarCheckPolicy, DPathElementCompileInfo eci) {
        this.localeEv = localeEv;
        this.calendarTz = calendarTz;
        this.firstDay = firstDay;
        this.calendarDaysInFirstWeek = calendarDaysInFirstWeek;
        this.calendarCheckPolicy = calendarCheckPolicy;
        super(eci, Evaluatable$.MODULE$.$lessinit$greater$default$2());
    }

    @Override
    public Seq<Evaluatable<Object>> runtimeDependencies() {
        return (Seq)((SeqOps)new .colon.colon((Object)this.localeEv, (List)Nil$.MODULE$));
    }

    @Override
    public Calendar compute(ParseOrUnparseState state) {
        ULocale locale = (ULocale)this.localeEv.evaluate(state);
        Calendar cal = Calendar.getInstance((ULocale)locale);
        cal.setFirstDayOfWeek(this.firstDay);
        cal.setMinimalDaysInFirstWeek(this.calendarDaysInFirstWeek);
        cal.setLenient(this.calendarCheckPolicy);
        TimeZone tz = this.calendarTz.isDefined() ? (TimeZone)this.calendarTz.get() : TimeZone.UNKNOWN_ZONE;
        cal.setTimeZone(tz);
        cal.clear();
        return cal;
    }
}

