/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ConcurrentHeapQuickSelectSketch;
import org.apache.datasketches.theta.ConcurrentHeapThetaBuffer;
import org.apache.datasketches.theta.ConcurrentPropagationService;
import org.apache.datasketches.theta.ConcurrentSharedThetaSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConcurrentHeapQuickSelectSketchTest {
    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int lgK = 9;
        int k = 512;
        int u = 512;
        SharedLocal sl = new SharedLocal(9);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < 512; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertEquals((double)local.getEstimate(), (double)512.0, (double)0.0);
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)512);
        byte[] serArr = shared.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(serArr);
        ThetaSketch sk = ThetaSketch.heapify((MemorySegment)seg, (long)sl.seed);
        Assert.assertTrue((boolean)(sk instanceof HeapQuickSelectSketch));
        seg.set(ValueLayout.JAVA_BYTE, 1L, (byte)0);
        ThetaSketch.heapify((MemorySegment)seg, (long)sl.seed);
    }

    @Test
    public void checkPropagationNotOrdered() {
        int lgK = 8;
        int k = 256;
        int u = 51200;
        SharedLocal sl = new SharedLocal(8, 4, false, false);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertEquals((int)sl.bldr.getConCurLgNominalEntries(), (int)4);
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < 51200; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((shared.getRetainedEntries(true) <= 51200 ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSketchID_UpdateSketch() {
        int lgK = 9;
        int k = 512;
        int u = 512;
        SharedLocal sl = new SharedLocal(9);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        Assert.assertTrue((boolean)(shared instanceof ConcurrentHeapQuickSelectSketch));
        for (int i = 0; i < 512; ++i) {
            local.update((long)i);
        }
        Assert.assertTrue((boolean)shared.compact().isCompact());
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertEquals((double)local.getEstimate(), (double)512.0, (double)0.0);
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)512);
        byte[] byteArray = shared.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        seg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        ThetaSketch.heapify((MemorySegment)seg, (long)sl.seed);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifySeedConflict() {
        int lgK = 9;
        long seed = 1021L;
        long seed2 = 9001L;
        SharedLocal sl = new SharedLocal(9, 9, 1021L);
        byte[] byteArray = sl.shared.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(byteArray);
        ThetaSketch.heapify((MemorySegment)srcSeg, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyCorruptLgNomLongs() {
        int lgK = 4;
        SharedLocal sl = new SharedLocal(4);
        byte[] serArr = sl.shared.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(serArr);
        srcSeg.set(ValueLayout.JAVA_BYTE, 3L, (byte)2);
        ThetaSketch.heapify((MemorySegment)srcSeg, (long)9001L);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void checkIllegalHashUpdate() {
        int lgK = 4;
        SharedLocal sl = new SharedLocal(4);
        sl.shared.hashUpdate(1L);
    }

    @Test
    public void checkHeapifyByteArrayExact() {
        int lgK = 9;
        int k = 512;
        int u = 512;
        SharedLocal sl = new SharedLocal(9);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        for (int i = 0; i < 512; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        byte[] serArr = shared.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(serArr).asReadOnly();
        UpdatableThetaSketch recoveredShared = UpdatableThetaSketch.heapify((MemorySegment)srcSeg);
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)512);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        shared = sl.bldr.buildSharedFromSketch(recoveredShared, wseg);
        UpdatableThetaSketch local2 = sl.bldr.buildLocal(shared);
        Assert.assertEquals((double)local2.getEstimate(), (double)512.0, (double)0.0);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)512.0, (double)0.0);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)512.0, (double)0.0);
        Assert.assertFalse((boolean)local2.isEmpty());
        Assert.assertFalse((boolean)local2.isEstimationMode());
        Assert.assertEquals((Object)local2.getResizeFactor(), (Object)local.getResizeFactor());
        local2.toString(true, true, 8, true);
    }

    @Test
    public void checkHeapifyByteArrayEstimating() {
        int lgK = 12;
        int k = 4096;
        int u = 8192;
        SharedLocal sl = new SharedLocal(12);
        UpdatableThetaSketch local = sl.local;
        UpdatableThetaSketch shared = sl.shared;
        for (int i = 0; i < 8192; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        Assert.assertTrue((boolean)local.isEstimationMode());
        byte[] serArr = shared.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(serArr).asReadOnly();
        UpdatableThetaSketch recoveredShared = UpdatableThetaSketch.heapify((MemorySegment)srcSeg, (long)sl.seed);
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)4096);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        shared = sl.bldr.buildSharedFromSketch(recoveredShared, wseg);
        UpdatableThetaSketch local2 = sl.bldr.buildLocal(shared);
        Assert.assertEquals((double)local2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)localUB);
        Assert.assertFalse((boolean)local2.isEmpty());
        Assert.assertTrue((boolean)local2.isEstimationMode());
        Assert.assertEquals((Object)local2.getResizeFactor(), (Object)local.getResizeFactor());
    }

    @Test
    public void checkHeapifyMemorySegmentEstimating() {
        int lgK = 9;
        int k = 512;
        int u = 1024;
        SharedLocal sl = new SharedLocal(9);
        UpdatableThetaSketch local = sl.local;
        UpdatableThetaSketch shared = sl.shared;
        for (int i = 0; i < 1024; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        Assert.assertTrue((boolean)local.isEstimationMode());
        Assert.assertFalse((boolean)local.isOffHeap());
        Assert.assertFalse((boolean)local.hasMemorySegment());
        byte[] serArr = shared.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(serArr).asReadOnly();
        UpdatableThetaSketch recoveredShared = UpdatableThetaSketch.heapify((MemorySegment)srcSeg, (long)9001L);
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)512);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        shared = sl.bldr.buildSharedFromSketch(recoveredShared, wseg);
        UpdatableThetaSketch local2 = sl.bldr.buildLocal(shared);
        Assert.assertEquals((double)local2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)local2.isEstimationMode());
    }

    @Test
    public void checkHQStoCompactForms() {
        int lgK = 9;
        int k = 512;
        int u = 2048;
        int maxBytes = 8192 + (Family.QUICKSELECT.getMinPreLongs() << 3);
        SharedLocal sl = new SharedLocal(9);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
        Assert.assertFalse((boolean)local.isOffHeap());
        Assert.assertFalse((boolean)local.hasMemorySegment());
        for (int i = 0; i < 2048; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        shared.rebuild();
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        int sharedBytes = shared.getCurrentBytes();
        int sharedCompBytes = shared.getCompactBytes();
        Assert.assertEquals((int)sharedBytes, (int)maxBytes);
        Assert.assertTrue((boolean)local.isEstimationMode());
        CompactThetaSketch comp1 = shared.compact(false, null);
        Assert.assertEquals((double)comp1.getEstimate(), (double)localEst);
        Assert.assertEquals((double)comp1.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)comp1.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)comp1.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp1.isEstimationMode());
        Assert.assertEquals((int)comp1.getCompactBytes(), (int)sharedCompBytes);
        Assert.assertEquals((String)comp1.getClass().getSimpleName(), (String)"HeapCompactSketch");
        CompactThetaSketch comp2 = shared.compact(true, null);
        Assert.assertEquals((double)comp2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)comp2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)comp2.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)comp2.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp2.isEstimationMode());
        Assert.assertEquals((int)comp2.getCompactBytes(), (int)sharedCompBytes);
        Assert.assertEquals((String)comp2.getClass().getSimpleName(), (String)"HeapCompactSketch");
        byte[] segArr2 = new byte[sharedCompBytes];
        MemorySegment seg2 = MemorySegment.ofArray(segArr2);
        CompactThetaSketch comp3 = shared.compact(false, seg2);
        Assert.assertEquals((double)comp3.getEstimate(), (double)localEst);
        Assert.assertEquals((double)comp3.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)comp3.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)comp3.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp3.isEstimationMode());
        Assert.assertEquals((int)comp3.getCompactBytes(), (int)sharedCompBytes);
        Assert.assertEquals((String)comp3.getClass().getSimpleName(), (String)"DirectCompactSketch");
        Util.clear((MemorySegment)seg2);
        CompactThetaSketch comp4 = shared.compact(true, seg2);
        Assert.assertEquals((double)comp4.getEstimate(), (double)localEst);
        Assert.assertEquals((double)comp4.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)comp4.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)comp4.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp4.isEstimationMode());
        Assert.assertEquals((int)comp4.getCompactBytes(), (int)sharedCompBytes);
        Assert.assertEquals((String)comp4.getClass().getSimpleName(), (String)"DirectCompactSketch");
        comp4.toString(false, true, 0, false);
    }

    @Test
    public void checkHQStoCompactEmptyForms() {
        int lgK = 9;
        SharedLocal sl = new SharedLocal(9);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        ConcurrentHeapQuickSelectSketchTest.println("lgArr: " + local.getLgArrLongs());
        local.toString(false, true, 0, false);
        boolean estimating = false;
        Assert.assertTrue((boolean)(local instanceof ConcurrentHeapThetaBuffer));
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        int compBytes = local.getCompactBytes();
        Assert.assertEquals((int)compBytes, (int)8);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)false);
        byte[] arr2 = new byte[compBytes];
        MemorySegment seg2 = MemorySegment.ofArray(arr2);
        CompactThetaSketch csk2 = shared.compact(false, seg2);
        Assert.assertEquals((double)csk2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk2.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)csk2.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk2.isEstimationMode(), (boolean)false);
        Assert.assertTrue((boolean)csk2.isOrdered());
        CompactThetaSketch csk3 = shared.compact(true, seg2);
        csk3.toString(false, true, 0, false);
        csk3.toString();
        Assert.assertEquals((double)csk3.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk3.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk3.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)csk3.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk3.isEstimationMode(), (boolean)false);
        Assert.assertTrue((boolean)csk3.isOrdered());
    }

    @Test
    public void checkExactMode() {
        int lgK = 12;
        int u = 4096;
        SharedLocal sl = new SharedLocal(12);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < 4096; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertEquals((double)local.getEstimate(), (double)4096.0, (double)0.0);
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)4096);
    }

    @Test
    public void checkEstMode() {
        int lgK = 12;
        int k = 4096;
        SharedLocal sl = new SharedLocal(12);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 12288;
        for (int i = 0; i < 12288; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        int retained = shared.getRetainedEntries(false);
        Assert.assertTrue((retained > 4096 ? 1 : 0) != 0);
    }

    @Test
    public void checkErrorBounds() {
        int lgK = 9;
        int k = 512;
        SharedLocal sl = new SharedLocal(9);
        UpdatableThetaSketch local = sl.local;
        UpdatableThetaSketch shared = sl.shared;
        for (int i = 0; i < 512; ++i) {
            local.update((long)i);
        }
        double est = local.getEstimate();
        double lb = local.getLowerBound(2);
        double ub = local.getUpperBound(2);
        Assert.assertEquals((double)est, (double)ub, (double)0.0);
        Assert.assertEquals((double)est, (double)lb, (double)0.0);
        int u = 1024;
        for (int i = 512; i < 1024; ++i) {
            local.update((long)i);
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        est = local.getEstimate();
        lb = local.getLowerBound(2);
        ub = local.getUpperBound(2);
        Assert.assertTrue((est <= ub ? 1 : 0) != 0);
        Assert.assertTrue((est >= lb ? 1 : 0) != 0);
    }

    @Test
    public void checkRebuild() {
        int lgK = 4;
        int k = 16;
        SharedLocal sl = new SharedLocal(4);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int t = ((ConcurrentHeapThetaBuffer)local).getHashTableThreshold();
        for (int i = 0; i < t; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((local.getEstimate() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((shared.getRetainedEntries(false) > 16 ? 1 : 0) != 0);
        shared.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)16);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)16);
        shared.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)16);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)16);
    }

    @Test
    public void checkBuilder() {
        int lgK = 4;
        SharedLocal sl = new SharedLocal(4);
        Assert.assertEquals((int)sl.bldr.getConCurLgNominalEntries(), (int)4);
        Assert.assertEquals((int)sl.bldr.getLgNominalEntries(), (int)4);
        ConcurrentHeapQuickSelectSketchTest.println(sl.bldr.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderSmallNominal() {
        int lgK = 2;
        new SharedLocal(2);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNegativeHashes() {
        int lgK = 9;
        SharedLocal sl = new SharedLocal(9);
        UpdatableThetaSketch local = sl.local;
        local.hashUpdate(-1L);
    }

    @Test
    public void checkResetAndStartingSubMultiple() {
        int lgK = 9;
        int k = 512;
        SharedLocal sl = new SharedLocal(9);
        UpdatableThetaSketch shared = sl.shared;
        UpdatableThetaSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 1536;
        for (int i = 0; i < 1536; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((shared.getRetainedEntries(false) >= 512 ? 1 : 0) != 0);
        Assert.assertTrue((local.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0);
        shared.reset();
        local.reset();
        Assert.assertTrue((boolean)local.isEmpty());
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)0);
        Assert.assertEquals((double)local.getEstimate(), (double)0.0, (double)0.0);
        Assert.assertEquals((long)local.getThetaLong(), (long)Long.MAX_VALUE);
    }

    @Test
    public void checkDQStoCompactEmptyForms() {
        int lgK = 9;
        SharedLocal sl = new SharedLocal(9);
        UpdatableThetaSketch local = sl.local;
        UpdatableThetaSketch shared = sl.shared;
        local.toString(false, true, 0, false);
        Assert.assertTrue((boolean)(local instanceof ConcurrentHeapThetaBuffer));
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double uskUB = local.getUpperBound(2);
        Assert.assertFalse((boolean)local.isEstimationMode());
        int bytes = local.getCompactBytes();
        Assert.assertEquals((int)bytes, (int)8);
        byte[] segArr2 = new byte[bytes];
        MemorySegment seg2 = MemorySegment.ofArray(segArr2);
        CompactThetaSketch csk2 = shared.compact(false, seg2);
        Assert.assertEquals((double)csk2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk2.getUpperBound(2), (double)uskUB);
        Assert.assertTrue((boolean)csk2.isEmpty());
        Assert.assertFalse((boolean)csk2.isEstimationMode());
        Assert.assertTrue((boolean)csk2.isOrdered());
        CompactThetaSketch csk3 = shared.compact(true, seg2);
        csk3.toString(false, true, 0, false);
        csk3.toString();
        Assert.assertEquals((double)csk3.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk3.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk3.getUpperBound(2), (double)uskUB);
        Assert.assertTrue((boolean)csk3.isEmpty());
        Assert.assertFalse((boolean)csk3.isEstimationMode());
        Assert.assertTrue((boolean)csk2.isOrdered());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMinReqBytes() {
        int lgK = 4;
        int k = 16;
        SharedLocal sl = new SharedLocal(4);
        for (int i = 0; i < 64; ++i) {
            sl.local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(sl.shared);
        byte[] byteArray = sl.shared.toByteArray();
        byte[] badBytes = Arrays.copyOfRange(byteArray, 0, 24);
        MemorySegment seg = MemorySegment.ofArray(badBytes).asReadOnly();
        ThetaSketch.heapify((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkThetaAndLgArrLongs() {
        int lgK = 4;
        int k = 16;
        SharedLocal sl = new SharedLocal(4);
        for (int i = 0; i < 16; ++i) {
            sl.local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(sl.shared);
        byte[] badArray = sl.shared.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(badArray);
        PreambleUtil.insertLgArrLongs((MemorySegment)seg, (int)4);
        PreambleUtil.insertThetaLong((MemorySegment)seg, (long)0x3FFFFFFFFFFFFFFFL);
        ThetaSketch.heapify((MemorySegment)seg);
    }

    @Test
    public void checkFamily() {
        SharedLocal sl = new SharedLocal();
        UpdatableThetaSketch local = sl.local;
        Assert.assertEquals((Object)local.getFamily(), (Object)Family.QUICKSELECT);
    }

    @Test
    public void checkBackgroundPropagation() {
        int i;
        int lgK = 4;
        int k = 16;
        int u = 80;
        SharedLocal sl = new SharedLocal(4);
        Assert.assertTrue((boolean)sl.local.isEmpty());
        for (i = 0; i < 16; ++i) {
            sl.local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(sl.shared);
        Assert.assertFalse((boolean)sl.local.isEmpty());
        Assert.assertTrue((sl.local.getEstimate() > 0.0 ? 1 : 0) != 0);
        long theta1 = sl.sharedIf.getVolatileTheta();
        while (i < 80) {
            sl.local.update((long)i);
            ++i;
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(sl.shared);
        long theta2 = sl.sharedIf.getVolatileTheta();
        int entries = sl.shared.getRetainedEntries(false);
        Assert.assertTrue((entries > 16 || theta2 < theta1 ? 1 : 0) != 0, (String)("entries= " + entries + " k= 16 theta1= " + theta1 + " theta2= " + theta2));
        sl.shared.rebuild();
        Assert.assertEquals((int)sl.shared.getRetainedEntries(false), (int)16);
        Assert.assertEquals((int)sl.shared.getRetainedEntries(true), (int)16);
        sl.local.rebuild();
        Assert.assertEquals((int)sl.shared.getRetainedEntries(false), (int)16);
        Assert.assertEquals((int)sl.shared.getRetainedEntries(true), (int)16);
    }

    @Test
    public void checkBuilderExceptions() {
        UpdatableThetaSketchBuilder bldr = new UpdatableThetaSketchBuilder();
        try {
            bldr.setNominalEntries(8);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            bldr.setConCurNominalEntries(8);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            bldr.setConCurLogNominalEntries(3);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        bldr.setNumPoolThreads(4);
        Assert.assertEquals((int)bldr.getNumPoolThreads(), (int)4);
        bldr.setMaxConcurrencyError(0.04);
        Assert.assertEquals((double)bldr.getMaxConcurrencyError(), (double)0.04);
        bldr.setMaxNumLocalThreads(4);
        Assert.assertEquals((int)bldr.getMaxNumLocalThreads(), (int)4);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void checkToByteArray() {
        SharedLocal sl = new SharedLocal();
        sl.local.toByteArray();
    }

    @Test
    public void printlnTest() {
        ConcurrentHeapQuickSelectSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    static void waitForBgPropagationToComplete(UpdatableThetaSketch shared) {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ConcurrentSharedThetaSketch csts = (ConcurrentSharedThetaSketch)shared;
        csts.awaitBgPropagationTermination();
        ConcurrentPropagationService.resetExecutorService((long)Thread.currentThread().getId());
        csts.initBgPropagationService();
    }

    static class SharedLocal {
        static final long DefaultSeed = 9001L;
        final UpdatableThetaSketch shared;
        final ConcurrentSharedThetaSketch sharedIf;
        final UpdatableThetaSketch local;
        final int sharedLgK;
        final int localLgK;
        final long seed;
        final MemorySegment wseg;
        final UpdatableThetaSketchBuilder bldr = new UpdatableThetaSketchBuilder();

        SharedLocal() {
            this(9, 9, 9001L, false, true, 1);
        }

        SharedLocal(int lgK) {
            this(lgK, lgK, 9001L, false, true, 1);
        }

        SharedLocal(int sharedLgK, int localLgK) {
            this(sharedLgK, localLgK, 9001L, false, true, 1);
        }

        SharedLocal(int sharedLgK, int localLgK, long seed) {
            this(sharedLgK, localLgK, seed, false, true, 1);
        }

        SharedLocal(int sharedLgK, int localLgK, boolean useSeg) {
            this(sharedLgK, localLgK, 9001L, useSeg, true, 1);
        }

        SharedLocal(int sharedLgK, int localLgK, boolean useSeg, boolean ordered) {
            this(sharedLgK, localLgK, 9001L, useSeg, ordered, 1);
        }

        SharedLocal(int sharedLgK, int localLgK, long seed, boolean useSeg, boolean ordered, int segMult) {
            this.sharedLgK = sharedLgK;
            this.localLgK = localLgK;
            this.seed = seed;
            if (useSeg) {
                int bytes = (4 << sharedLgK) * segMult + Family.QUICKSELECT.getMaxPreLongs() << 3;
                this.wseg = MemorySegment.ofArray(new byte[bytes]);
            } else {
                this.wseg = null;
            }
            this.bldr.setLogNominalEntries(sharedLgK);
            this.bldr.setConCurLogNominalEntries(localLgK);
            this.bldr.setPropagateOrderedCompact(ordered);
            this.bldr.setSeed(this.seed);
            this.shared = this.bldr.buildShared(this.wseg);
            this.local = this.bldr.buildLocal(this.shared);
            this.sharedIf = (ConcurrentSharedThetaSketch)this.shared;
        }
    }
}

