/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.SocketFactory;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NetworkServerControlApiTest
extends BaseJDBCTestCase {
    private static final String NON_ASCII_USER = "bj\u00f8rn";
    private static final String NON_ASCII_PASSWORD = "l\u00f8yndom";
    private static final String POLICY_FILE_NAME = "org/apache/derbyTesting/functionTests/tests/derbynet/NetworkServerControlApiTest.policy";

    public NetworkServerControlApiTest(String name) {
        super(name);
    }

    public void test_01_WrongUsage() throws Exception {
        String nsc = "org.apache.derby.drda.NetworkServerControl";
        String usage = "Usage: ";
        String[] cmd = new String[]{"org.apache.derby.drda.NetworkServerControl"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"No command given.", "Usage: "}, cmd, 1);
        cmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "-h", "localhost"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"No command given.", "Usage: "}, cmd, 1);
        cmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "unknowncmd"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Command unknowncmd is unknown.", "Usage: "}, cmd, 1);
        cmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "-unknownarg"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Argument -unknownarg is unknown.", "Usage: "}, cmd, 1);
        cmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping", "arg1"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Invalid number of arguments for command ping.", "Usage: "}, cmd, 1);
    }

    public void test_02_TraceCommands() throws Exception {
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        String derbySystemHome = NetworkServerControlApiTest.getSystemProperty("derby.system.home");
        nsctrl.setTraceDirectory(derbySystemHome);
        nsctrl.trace(true);
        nsctrl.ping();
        NetworkServerControlApiTest.assertTrue((boolean)this.fileExists(derbySystemHome + "/Server3.trace"));
        nsctrl.trace(false);
        nsctrl.setTraceDirectory("/");
        try {
            nsctrl.trace(true);
            NetworkServerControlApiTest.fail((String)"Should have gotten an exception turning on tracing");
        }
        catch (Exception exception) {
            // empty catch block
        }
        nsctrl.ping();
    }

    public void xtestTraceSystemPropertiesNoPermission() throws SQLException {
        NetworkServerControlApiTest.assertEquals((String)NetworkServerControlApiTest.getSystemProperty("derby.drda.traceAll"), (String)"true");
        NetworkServerControlApiTest.assertEquals((String)NetworkServerControlApiTest.getSystemProperty("derby.drda.traceDirectory"), (String)"/");
        Connection conn = this.getConnection();
        NetworkServerControlApiTest.assertFalse((boolean)conn.getMetaData().isReadOnly());
    }

    public void xtestTraceSystemPropertiesHasPermission() throws SQLException {
        String derbysystemhome = NetworkServerControlApiTest.getSystemProperty("derby.system.home");
        NetworkServerControlApiTest.assertEquals((String)NetworkServerControlApiTest.getSystemProperty("derby.drda.traceAll"), (String)"true");
        NetworkServerControlApiTest.assertEquals((String)NetworkServerControlApiTest.getSystemProperty("derby.drda.traceDirectory"), (String)(derbysystemhome + "/trace"));
        Connection conn = this.getConnection();
        NetworkServerControlApiTest.assertFalse((boolean)conn.getMetaData().isReadOnly());
        NetworkServerControlApiTest.assertTrue((boolean)this.fileExists(derbysystemhome + "/trace/Server1.trace"));
    }

    public void xtestShutdownWithNonASCIICredentials() throws Exception {
        NetworkServerControl control = NetworkServerTestSetup.getNetworkServerControl();
        NetworkServerTestSetup.pingForServerStart(control);
        control.shutdown();
        NetworkServerTestSetup.pingForServerUp(control, null, false);
    }

    public void test_03_Ping() throws Exception {
        String currentHost = TestConfiguration.getCurrent().getHostName();
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        nsctrl.ping();
        nsctrl = new NetworkServerControl(this.privInetAddressGetByName(currentHost), 9393);
        try {
            nsctrl.ping();
            NetworkServerControlApiTest.fail((String)"Should not have been able to ping on port 9393");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void test_03_ping_args() throws Exception {
        String response = this.tryPingDbError("mydatabase", "myuser", "mypassword");
        NetworkServerControlApiTest.assertEquals((String)"Usage", (String)response.substring(0, 5));
        response = this.tryPingDbError("some/sorta/db", "someone", "somecredentials");
        NetworkServerControlApiTest.assertEquals((String)"Usage", (String)response.substring(0, 5));
        response = this.tryPingDbError("\\\\192.168.1.2\\guest\\db1", "tata", "tata");
        NetworkServerControlApiTest.assertEquals((String)"Usage", (String)response.substring(0, 5));
        response = this.tryPingDbError("my/nocred/db", "", "");
        NetworkServerControlApiTest.assertEquals((String)"Usage", (String)response.substring(0, 5));
        response = this.tryPingDbOK("", "scarface", "evildoer");
        NetworkServerControlApiTest.assertEquals((String)"OK", (String)response.substring(0, 2));
    }

    private Socket privilegedClientSocket(final String host, final int port) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Socket>(){

                @Override
                public Socket run() throws Exception {
                    return SocketFactory.getDefault().createSocket(InetAddress.getByName(host), port);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (Exception)pae.getCause();
        }
    }

    private static String byteArrayToHex(byte[] ba, int l) {
        if (l < 0) {
            return "STRING OF NEGATIVE LENGTH(" + l + ")";
        }
        StringBuilder sb = new StringBuilder(l * 2);
        for (int i = 0; i < l; ++i) {
            sb.append(String.format("%02x", ba[i]));
        }
        return sb.toString();
    }

    private String tryPingDbError(String d, String u, String p) throws Exception {
        return this.tryPingDbTest(2, d, u, p);
    }

    private String tryPingDbOK(String d, String u, String p) throws Exception {
        return this.tryPingDbTest(0, d, u, p);
    }

    private String tryPingDbTest(int rc, String d, String u, String p) throws Exception {
        Socket clientSocket = this.privilegedClientSocket(TestConfiguration.getCurrent().getHostName(), TestConfiguration.getCurrent().getPort());
        ByteArrayOutputStream byteArrayOs = new ByteArrayOutputStream();
        DataOutputStream commandOs = new DataOutputStream(byteArrayOs);
        byte[] msgBytes = "CMD:".getBytes("UTF8");
        commandOs.write(msgBytes, 0, msgBytes.length);
        commandOs.writeByte(0);
        commandOs.writeByte(2);
        commandOs.writeByte(0);
        commandOs.writeByte(0);
        commandOs.writeByte(4);
        msgBytes = d.getBytes("UTF8");
        commandOs.writeByte((byte)(msgBytes.length >> 8));
        commandOs.writeByte((byte)msgBytes.length);
        commandOs.write(msgBytes, 0, msgBytes.length);
        msgBytes = u.getBytes("UTF8");
        commandOs.writeByte((byte)(msgBytes.length >> 8));
        commandOs.writeByte((byte)msgBytes.length);
        commandOs.write(msgBytes, 0, msgBytes.length);
        msgBytes = p.getBytes("UTF8");
        commandOs.writeByte((byte)(msgBytes.length >> 8));
        commandOs.writeByte((byte)msgBytes.length);
        commandOs.write(msgBytes, 0, msgBytes.length);
        byteArrayOs.writeTo(clientSocket.getOutputStream());
        commandOs.flush();
        byteArrayOs.reset();
        clientSocket.shutdownOutput();
        byte[] result = new byte[1024];
        int resultLen = clientSocket.getInputStream().read(result);
        clientSocket.close();
        if (resultLen < 0) {
            return "DISCONNECT";
        }
        String r = "RPY:";
        int rl = r.length();
        NetworkServerControlApiTest.assertTrue((resultLen > rl ? 1 : 0) != 0);
        String header = new String(result, 0, rl, "UTF8");
        NetworkServerControlApiTest.assertEquals((String)r, (String)header);
        NetworkServerControlApiTest.assertEquals((int)rc, (int)result[rl++]);
        if (rc == 0) {
            return "OK";
        }
        int l = ((result[rl++] & 0xFF) << 8) + (result[rl++] & 0xFF);
        String response = new String(result, rl, l, "UTF8");
        return response;
    }

    private InetAddress privInetAddressGetByName(final String host) throws UnknownHostException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress>(){

                @Override
                public InetAddress run() throws UnknownHostException {
                    return InetAddress.getByName(host);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (UnknownHostException)pae.getCause();
        }
    }

    private boolean fileExists(String filename) {
        return PrivilegedFileOpsForTests.exists(new File(filename));
    }

    private static Test decorateTest() {
        Test test = TestConfiguration.clientServerDecorator((Test)new BaseTestSuite(NetworkServerControlApiTest.class));
        return new SecurityManagerSetup(test, POLICY_FILE_NAME);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("NetworkServerControlApiTest");
        if (!Derby.hasServer()) {
            return suite;
        }
        suite.addTest(NetworkServerControlApiTest.decorateTest());
        suite = NetworkServerControlApiTest.decorateSystemPropertyTests(suite);
        suite.addTest(NetworkServerControlApiTest.decorateShutdownTest("xtestShutdownWithNonASCIICredentials", NON_ASCII_USER, NON_ASCII_PASSWORD));
        return suite;
    }

    private static BaseTestSuite decorateSystemPropertyTests(BaseTestSuite suite) {
        Properties traceProps = new Properties();
        traceProps.put("derby.drda.traceDirectory", "/");
        traceProps.put("derby.drda.traceAll", "true");
        suite.addTest((Test)new SystemPropertyTestSetup(TestConfiguration.clientServerDecorator((Test)new NetworkServerControlApiTest("xtestTraceSystemPropertiesNoPermission")), traceProps));
        Properties traceProps2 = new Properties();
        traceProps2.put("derby.drda.traceDirectory", NetworkServerControlApiTest.getSystemProperty("derby.system.home") + "/trace");
        traceProps2.put("derby.drda.traceAll", "true");
        suite.addTest((Test)new SystemPropertyTestSetup(TestConfiguration.clientServerDecorator((Test)new NetworkServerControlApiTest("xtestTraceSystemPropertiesHasPermission")), traceProps2));
        return suite;
    }

    private static Test decorateShutdownTest(String testName, String user, String password) {
        Properties props = new Properties();
        props.setProperty("derby.connection.requireAuthentication", "true");
        props.setProperty("derby.authentication.provider", "BUILTIN");
        props.setProperty("derby.user." + user, password);
        Object test = new NetworkServerControlApiTest(testName);
        test = TestConfiguration.clientServerDecorator((Test)test);
        test = new SystemPropertyTestSetup((Test)test, props, true);
        test = TestConfiguration.changeUserDecorator((Test)test, user, password);
        return test;
    }

    public void test_04_MaxThreads_0() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] maxthreadsCmd1 = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "0", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Max threads changed to 0."}, maxthreadsCmd1, 0);
        int maxValue = server.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)0, (int)maxValue);
    }

    public void test_05_MaxThreads_Neg1() throws Exception {
        String host;
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] maxthreadsCmd2 = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "-1", "-h", "localhost", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        maxthreadsCmd2[4] = host = TestUtil.getHostName();
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Max threads changed to 0."}, maxthreadsCmd2, 0);
        int maxValue = server.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)0, (int)maxValue);
    }

    public void test_06_MaxThreads_Neg12() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] maxthreadsCmd3 = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "-12", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Invalid value, -12, for maxthreads.", "Usage: NetworkServerControl <commands>", "Commands:", "start [-h <host>] [-p <port number>] [-noSecurityManager] [-ssl <ssl mode>]", "shutdown [-h <host>][-p <port number>] [-ssl <ssl mode>] [-user <username>] [-password <password>]", "ping [-h <host>][-p <port number>] [-ssl <ssl mode>]", "sysinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "runtimeinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "logconnections { on|off } [-h <host>][-p <port number>] [-ssl <ssl mode>]", "maxthreads <max>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "timeslice <milliseconds>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "trace { on|off } [-s <session id>][-h <host>][-p <port number>] [-ssl <ssl mode>]", "tracedirectory <trace directory>[-h <host>][-p <port number>] [-ssl <ssl mode>]"}, maxthreadsCmd3, 1);
        int maxValue = server.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)0, (int)maxValue);
    }

    public void test_07_MaxThreads_2147483647() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] maxthreadsCmd4 = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "2147483647", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Max threads changed to 2147483647."}, maxthreadsCmd4, 0);
        int maxValue = server.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)Integer.MAX_VALUE, (int)maxValue);
    }

    public void test_08_MaxThreads_9000() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] maxthreadsCmd5 = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "9000", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Max threads changed to 9000."}, maxthreadsCmd5, 0);
        int maxValue = server.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)9000, (int)maxValue);
    }

    public void test_09_MaxThreads_Invalid() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] maxthreadsCmd5 = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "10000", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Max threads changed to 10000."}, maxthreadsCmd5, 0);
        int maxValue = server.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)10000, (int)maxValue);
        String[] maxthreadsCmd6 = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "a"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Invalid value, a, for maxthreads.", "Usage: NetworkServerControl <commands>", "Commands:", "start [-h <host>] [-p <port number>] [-noSecurityManager] [-ssl <ssl mode>]", "shutdown [-h <host>][-p <port number>] [-ssl <ssl mode>] [-user <username>] [-password <password>]", "ping [-h <host>][-p <port number>] [-ssl <ssl mode>]", "sysinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "runtimeinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "logconnections { on|off } [-h <host>][-p <port number>] [-ssl <ssl mode>]", "maxthreads <max>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "timeslice <milliseconds>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "trace { on|off } [-s <session id>][-h <host>][-p <port number>] [-ssl <ssl mode>]", "tracedirectory <trace directory>[-h <host>][-p <port number>] [-ssl <ssl mode>]"}, maxthreadsCmd6, 1);
        maxValue = server.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)10000, (int)maxValue);
    }

    public void test_10_MaxThreadsCallable_0() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        server.setMaxThreads(0);
        int maxValue = server.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)0, (int)maxValue);
    }

    public void test_11_MaxThreadsCallable_Neg1() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        server.setMaxThreads(-1);
        int maxValue = server.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)0, (int)maxValue);
    }

    public void test_12_MaxThreadsCallable_Neg12() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        try {
            server.setMaxThreads(-2);
            NetworkServerControlApiTest.fail((String)"Should have thrown an exception with 'DRDA_InvalidValue.U:Invalid value, -2, for maxthreads.'");
        }
        catch (Exception e) {
            NetworkServerControlApiTest.assertEquals((String)"DRDA_InvalidValue.U:Invalid value, -2, for maxthreads.", (String)e.getMessage());
        }
    }

    public void test_13_MaxThreadsCallable_2147483647() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        server.setMaxThreads(Integer.MAX_VALUE);
        int maxValue = server.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)Integer.MAX_VALUE, (int)maxValue);
    }

    public void test_14_MaxThreadsCallable_9000() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        server.setMaxThreads(9000);
        int maxValue = server.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)9000, (int)maxValue);
    }

    public void test_15_TimeSlice_0() throws Exception {
        int value = 0;
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] timesliceCmd1 = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "0", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Time slice changed to 0."}, timesliceCmd1, 0);
        int timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
    }

    public void test_16_TimeSlice_Neg1() throws Exception {
        String host;
        int value = 0;
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] timesliceCmd2 = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "-1", "-h", "localhost", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        timesliceCmd2[4] = host = TestUtil.getHostName();
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Time slice changed to 0."}, timesliceCmd2, 0);
        int timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
    }

    public void test_17_TimeSlice_Neg12() throws Exception {
        int value = 0;
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] timesliceCmd3 = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "-12", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Invalid value, -12, for timeslice.", "Usage: NetworkServerControl <commands> ", "Commands:", "start [-h <host>] [-p <port number>] [-noSecurityManager] [-ssl <ssl mode>]", "shutdown [-h <host>][-p <port number>] [-ssl <ssl mode>] [-user <username>] [-password <password>]", "ping [-h <host>][-p <port number>] [-ssl <ssl mode>]", "sysinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "runtimeinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "logconnections { on|off } [-h <host>][-p <port number>] [-ssl <ssl mode>]", "maxthreads <max>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "timeslice <milliseconds>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "trace { on|off } [-s <session id>][-h <host>][-p <port number>] [-ssl <ssl mode>]", "tracedirectory <trace directory>[-h <host>][-p <port number>] [-ssl <ssl mode>]"}, timesliceCmd3, 1);
        int timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
    }

    public void test_18_TimeSlice_2147483647() throws Exception {
        int value = Integer.MAX_VALUE;
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] timesliceCmd4 = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "2147483647", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Time slice changed to 2147483647."}, timesliceCmd4, 0);
        int timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
    }

    public void test_19_TimeSlice_9000() throws Exception {
        int value = 9000;
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] timesliceCmd5 = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "9000", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Time slice changed to 9000."}, timesliceCmd5, 0);
        int timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
    }

    public void test_20_TimeSlice_a() throws Exception {
        int value = 8000;
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        String[] timesliceCmd5 = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "8000", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Time slice changed to 8000."}, timesliceCmd5, 0);
        int timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
        String[] timesliceCmd6 = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "a"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Invalid value, a, for timeslice.", "Usage: NetworkServerControl <commands> ", "Commands:", "start [-h <host>] [-p <port number>] [-noSecurityManager] [-ssl <ssl mode>]", "shutdown [-h <host>][-p <port number>] [-ssl <ssl mode>] [-user <username>] [-password <password>]", "ping [-h <host>][-p <port number>] [-ssl <ssl mode>]", "sysinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "runtimeinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "logconnections { on|off } [-h <host>][-p <port number>] [-ssl <ssl mode>]", "maxthreads <max>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "timeslice <milliseconds>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "trace { on|off } [-s <session id>][-h <host>][-p <port number>] [-ssl <ssl mode>]", "tracedirectory <trace directory>[-h <host>][-p <port number>] [-ssl <ssl mode>]"}, timesliceCmd6, 1);
        timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
    }

    public void test_21_TimeSliceCallable_0() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        int value = 0;
        server.setTimeSlice(0);
        int timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
    }

    public void test_22_TimeSliceCallable_Neg1() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        int value = 0;
        server.setTimeSlice(-1);
        int timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
    }

    public void test_23_TimeSliceCallable_Neg2() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        int value = 0;
        try {
            server.setTimeSlice(-2);
        }
        catch (Exception e) {
            NetworkServerControlApiTest.assertTrue((e.getMessage().indexOf("Invalid value") != -1 ? 1 : 0) != 0);
        }
        int timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
    }

    public void test_24_TimeSliceCallable_2147483647() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        int value = Integer.MAX_VALUE;
        server.setTimeSlice(Integer.MAX_VALUE);
        int timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
    }

    public void test_25_TimeSliceCallable_9000() throws Exception {
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), TestConfiguration.getCurrent().getPort());
        int value = 9000;
        server.setTimeSlice(9000);
        int timeSliceValue = server.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)value, (int)timeSliceValue);
    }
}

