/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;

public class ConglomerateDescriptorList
extends ArrayList<ConglomerateDescriptor> {
    public ConglomerateDescriptor getConglomerateDescriptor(long conglomerateNumber) {
        ConglomerateDescriptor returnValue = null;
        for (ConglomerateDescriptor conglomerateDescriptor : this) {
            if (conglomerateNumber != conglomerateDescriptor.getConglomerateNumber()) continue;
            returnValue = conglomerateDescriptor;
            break;
        }
        return returnValue;
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(long conglomerateNumber) {
        int size = this.size();
        int j = 0;
        ConglomerateDescriptor[] draft = new ConglomerateDescriptor[size];
        for (ConglomerateDescriptor conglomerateDescriptor : this) {
            if (conglomerateNumber != conglomerateDescriptor.getConglomerateNumber()) continue;
            draft[j++] = conglomerateDescriptor;
        }
        if (j == size) {
            return draft;
        }
        return Arrays.copyOf(draft, j);
    }

    public ConglomerateDescriptor getConglomerateDescriptor(String conglomerateName) {
        ConglomerateDescriptor returnValue = null;
        for (ConglomerateDescriptor conglomerateDescriptor : this) {
            if (!conglomerateName.equals(conglomerateDescriptor.getConglomerateName())) continue;
            returnValue = conglomerateDescriptor;
            break;
        }
        return returnValue;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(UUID uuid) throws StandardException {
        ConglomerateDescriptor returnValue = null;
        for (ConglomerateDescriptor conglomerateDescriptor : this) {
            if (!uuid.equals(conglomerateDescriptor.getUUID())) continue;
            returnValue = conglomerateDescriptor;
            break;
        }
        return returnValue;
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID uuid) {
        int size = this.size();
        int j = 0;
        ConglomerateDescriptor[] draft = new ConglomerateDescriptor[size];
        for (ConglomerateDescriptor conglomerateDescriptor : this) {
            if (!uuid.equals(conglomerateDescriptor.getUUID())) continue;
            draft[j++] = conglomerateDescriptor;
        }
        if (j == size) {
            return draft;
        }
        return Arrays.copyOf(draft, j);
    }

    public void dropConglomerateDescriptor(UUID tableID, ConglomerateDescriptor cgDesc) throws StandardException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ConglomerateDescriptor localCgDesc = (ConglomerateDescriptor)iterator.next();
            if (localCgDesc.getConglomerateNumber() != cgDesc.getConglomerateNumber() || !localCgDesc.getConglomerateName().equals(cgDesc.getConglomerateName()) || !localCgDesc.getSchemaID().equals(cgDesc.getSchemaID())) continue;
            iterator.remove();
            break;
        }
    }

    public void dropConglomerateDescriptorByUUID(UUID conglomerateID) throws StandardException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ConglomerateDescriptor localCgDesc = (ConglomerateDescriptor)iterator.next();
            if (!conglomerateID.equals(localCgDesc.getUUID())) continue;
            iterator.remove();
            break;
        }
    }
}

