/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiIterations;
import org.apache.derbyTesting.unitTests.services.T_L1;
import org.apache.derbyTesting.unitTests.services.T_L2;
import org.apache.derbyTesting.unitTests.services.T_User;

public class T_LockFactory
extends T_MultiIterations {
    protected static final int ITERATIONS = 100;
    protected LockFactory lf;

    @Override
    protected String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.services.locks.LockFactory";
    }

    @Override
    protected void setupTest() throws T_Fail {
        try {
            this.lf = (LockFactory)T_LockFactory.startSystemModule(this.getModuleToTestProtocolName());
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
        if (this.lf == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " module not started.");
        }
    }

    @Override
    protected void runTestSet() throws T_Fail {
        try {
            this.S001();
            this.S002();
            this.S003();
            this.S004();
            this.S005();
            this.S007();
            this.M001();
            this.M002();
            this.M003();
            this.M004();
        }
        catch (StandardException se) {
            throw T_Fail.exceptionFail(se);
        }
    }

    void S001() throws StandardException, T_Fail {
        CompatibilitySpace cs = this.lf.createCompatibilitySpace(null);
        Object g0 = new Object();
        T_L1 l0 = new T_L1();
        this.checkLockCount(cs, 0);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.checkLockCount(cs, 1);
        int count = this.lf.unlock(cs, g0, (Lockable)l0, null);
        if (count != 1) {
            throw T_Fail.testFailMsg("invalid unlock count, expected 1, got " + count);
        }
        this.checkLockCount(cs, 0);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.checkLockCount(cs, 2);
        this.lf.unlock(cs, g0, (Lockable)l0, null);
        this.lf.unlock(cs, g0, (Lockable)l0, null);
        this.checkLockCount(cs, 0);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.checkLockCount(cs, 3);
        this.lf.unlockGroup(cs, g0);
        this.checkLockCount(cs, 0);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.checkLockCount(cs, 3);
        this.lf.unlock(cs, g0, (Lockable)l0, null);
        this.checkLockCount(cs, 2);
        this.lf.unlock(cs, g0, (Lockable)l0, null);
        this.checkLockCount(cs, 1);
        this.lf.unlock(cs, g0, (Lockable)l0, null);
        this.checkLockCount(cs, 0);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, 1000);
        this.checkLockCount(cs, 1);
        count = this.lf.unlock(cs, g0, (Lockable)l0, null);
        if (count != 1) {
            throw T_Fail.testFailMsg("invalid unlock count, expected 1, got " + count);
        }
        this.PASS("S001");
    }

    void S002() throws StandardException, T_Fail {
        CompatibilitySpace cs = this.lf.createCompatibilitySpace(null);
        Object g0 = new Object();
        Object g1 = new Object();
        T_L1 l0 = new T_L1();
        this.checkLockCount(cs, 0);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.lf.lockObject(cs, g1, (Lockable)l0, null, -1);
        this.checkLockGroupCount(cs, g0, 1);
        this.checkLockGroupCount(cs, g1, 1);
        this.checkLockCount(cs, 2);
        int count = this.lf.unlock(cs, g0, (Lockable)l0, null);
        if (count != 1) {
            throw T_Fail.testFailMsg("invalid unlock count, expected 1, got " + count);
        }
        this.checkLockGroupCount(cs, g0, 0);
        this.checkLockGroupCount(cs, g1, 1);
        this.checkLockCount(cs, 1);
        count = this.lf.unlock(cs, g1, (Lockable)l0, null);
        if (count != 1) {
            throw T_Fail.testFailMsg("invalid unlock count, expected 1, got " + count);
        }
        this.checkLockGroupCount(cs, g0, 0);
        this.checkLockGroupCount(cs, g1, 0);
        this.checkLockCount(cs, 0);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.lf.lockObject(cs, g1, (Lockable)l0, null, -1);
        this.checkLockCount(cs, 2);
        this.lf.unlockGroup(cs, g1);
        this.checkLockGroupCount(cs, g0, 1);
        this.checkLockGroupCount(cs, g1, 0);
        this.checkLockCount(cs, 1);
        this.lf.unlockGroup(cs, g0);
        this.checkLockGroupCount(cs, g0, 0);
        this.checkLockGroupCount(cs, g1, 0);
        this.checkLockCount(cs, 0);
        this.PASS("S002");
    }

    void S003() throws StandardException, T_Fail {
        CompatibilitySpace cs = this.lf.createCompatibilitySpace(null);
        Object g0 = new Object();
        Object g1 = new Object();
        T_L1 l0 = new T_L1();
        T_L1 l1 = new T_L1();
        T_L1 l2 = new T_L1();
        this.checkLockCount(cs, 0);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.lf.lockObject(cs, g1, (Lockable)l0, null, -1);
        this.lf.lockObject(cs, g1, (Lockable)l1, null, -1);
        this.lf.lockObject(cs, g1, (Lockable)l2, null, -1);
        this.checkLockGroupCount(cs, g0, 1);
        this.checkLockGroupCount(cs, g1, 3);
        this.checkLockCount(cs, 4);
        if (this.lf.anyoneBlocked()) {
            throw T_Fail.testFailMsg("anyoneBlocked() returned true on a set of private locks");
        }
        this.lf.unlock(cs, g1, (Lockable)l1, null);
        this.checkLockGroupCount(cs, g0, 1);
        this.checkLockGroupCount(cs, g1, 2);
        this.checkLockCount(cs, 3);
        this.lf.unlockGroup(cs, g1);
        this.checkLockGroupCount(cs, g0, 1);
        this.checkLockGroupCount(cs, g1, 0);
        this.checkLockCount(cs, 1);
        this.lf.unlockGroup(cs, g0);
        this.checkLockGroupCount(cs, g0, 0);
        this.checkLockGroupCount(cs, g1, 0);
        this.checkLockCount(cs, 0);
        this.PASS("S003");
    }

    void S004() throws StandardException, T_Fail {
        CompatibilitySpace cs = this.lf.createCompatibilitySpace(null);
        Object g0 = new Object();
        Object g1 = new Object();
        Object g2 = new Object();
        T_L1 l0 = new T_L1();
        T_L1 l1 = new T_L1();
        T_L1 l2 = new T_L1();
        boolean count = false;
        this.checkLockCount(cs, 0);
        this.lf.lockObject(cs, g0, (Lockable)l0, null, -1);
        this.lf.lockObject(cs, g1, (Lockable)l0, null, -1);
        this.lf.lockObject(cs, g1, (Lockable)l1, null, -1);
        this.lf.lockObject(cs, g1, (Lockable)l2, null, -1);
        this.checkLockGroupCount(cs, g0, 1);
        this.checkLockGroupCount(cs, g1, 3);
        this.checkLockCount(cs, 4);
        this.lf.transfer(cs, g0, g1);
        this.checkLockGroupCount(cs, g0, 0);
        this.checkLockGroupCount(cs, g1, 4);
        this.checkLockCount(cs, 4);
        this.lf.transfer(cs, g0, g2);
        this.checkLockGroupCount(cs, g0, 0);
        this.checkLockGroupCount(cs, g1, 4);
        this.checkLockGroupCount(cs, g2, 0);
        this.checkLockCount(cs, 4);
        this.lf.lockObject(cs, g2, (Lockable)l0, null, -1);
        this.checkLockGroupCount(cs, g2, 1);
        this.checkLockCount(cs, 5);
        this.lf.transfer(cs, g1, g2);
        this.checkLockGroupCount(cs, g1, 0);
        this.checkLockGroupCount(cs, g2, 5);
        this.checkLockCount(cs, 5);
        this.lf.transfer(cs, g2, g1);
        this.checkLockGroupCount(cs, g1, 5);
        this.checkLockGroupCount(cs, g2, 0);
        this.checkLockCount(cs, 5);
        this.lf.unlockGroup(cs, g2);
        this.checkLockGroupCount(cs, g1, 5);
        this.checkLockGroupCount(cs, g2, 0);
        this.checkLockCount(cs, 5);
        this.lf.unlockGroup(cs, g1);
        this.checkLockGroupCount(cs, g1, 0);
        this.checkLockGroupCount(cs, g2, 0);
        this.checkLockCount(cs, 0);
        this.PASS("S004");
    }

    void S005() throws StandardException, T_Fail {
        CompatibilitySpace cs0 = this.lf.createCompatibilitySpace(null);
        CompatibilitySpace cs1 = this.lf.createCompatibilitySpace(null);
        Object g0 = new Object();
        Object g1 = new Object();
        T_L1 l0 = new T_L1();
        T_L1 l1 = new T_L1();
        T_L1 l2 = new T_L1();
        this.checkLockCount(cs0, 0);
        this.checkLockCount(cs1, 0);
        this.lf.lockObject(cs0, g0, (Lockable)l0, null, -1);
        this.lf.lockObject(cs1, g1, (Lockable)l1, null, -1);
        this.checkLockCount(cs0, 1);
        this.checkLockCount(cs1, 1);
        this.lf.lockObject(cs0, g0, (Lockable)l2, null, -1);
        this.checkLockCount(cs0, 2);
        this.checkLockCount(cs1, 1);
        try {
            this.lf.lockObject(cs1, g1, (Lockable)l2, null, 200);
            throw T_Fail.testFailMsg("lock succeeded on already locked object");
        }
        catch (StandardException lfe) {
            if (!lfe.getMessageId().equals("40XL1")) {
                throw lfe;
            }
            this.checkLockCount(cs0, 2);
            this.checkLockCount(cs1, 1);
            this.lf.unlock(cs0, g0, (Lockable)l2, null);
            this.checkLockCount(cs0, 1);
            this.checkLockCount(cs1, 1);
            this.lf.lockObject(cs1, g1, (Lockable)l2, null, -1);
            this.checkLockCount(cs0, 1);
            this.checkLockCount(cs1, 2);
            this.lf.unlockGroup(cs0, g0);
            this.lf.unlockGroup(cs1, g1);
            this.checkLockCount(cs0, 0);
            this.checkLockCount(cs1, 0);
            this.PASS("S005");
            return;
        }
    }

    void S007() throws StandardException, T_Fail {
        CompatibilitySpace cs = this.lf.createCompatibilitySpace(null);
        Object g0 = new Object();
        Object g1 = new Object();
        T_L1 l0 = new T_L1();
        this.checkLockCount(cs, 0);
        this.checkLockGroupCount(cs, g0, 0);
        this.lf.unlockGroup(cs, g0);
        this.lf.unlockGroup(cs, (Object)cs);
        this.lf.unlock(cs, g0, (Lockable)l0, null);
        this.lf.transfer(cs, g0, g1);
        this.lf.transfer(cs, g1, g0);
        if (this.lf.anyoneBlocked()) {
            throw T_Fail.testFailMsg("anyoneBlocked() returned true on an empty space");
        }
        this.checkLockCount(cs, 0);
        this.checkLockGroupCount(cs, g0, 0);
        this.checkLockGroupCount(cs, g1, 0);
        this.PASS("S007");
    }

    void M001() throws StandardException, T_Fail {
        Lockable[] locks = new T_L1[]{new T_L1(), new T_L1()};
        T_User u1 = new T_User(1, this.lf, locks, 100L, 1000L);
        T_User u2 = new T_User(1, this.lf, locks, 100L, 2000L);
        Thread t1 = new Thread(u1);
        Thread t2 = new Thread(u2);
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch (InterruptedException ie) {
            throw T_Fail.exceptionFail(ie);
        }
        if (u1.error != null) {
            throw T_Fail.exceptionFail(u1.error);
        }
        if (u2.error != null) {
            throw T_Fail.exceptionFail(u2.error);
        }
        this.PASS("M001");
    }

    void M002() throws StandardException, T_Fail {
        Lockable[] locks = new T_L1[]{new T_L1()};
        T_User u1 = new T_User(2, this.lf, locks, 100L, 1000L);
        T_User u2 = new T_User(2, this.lf, locks, 100L, 2000L);
        T_User u3 = new T_User(2, this.lf, locks, 100L, 3000L);
        Thread t1 = new Thread(u1);
        Thread t2 = new Thread(u2);
        Thread t3 = new Thread(u3);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
            t2.join();
            t3.join();
        }
        catch (InterruptedException ie) {
            throw T_Fail.exceptionFail(ie);
        }
        if (u1.error != null) {
            throw T_Fail.exceptionFail(u1.error);
        }
        if (u2.error != null) {
            throw T_Fail.exceptionFail(u2.error);
        }
        if (u3.error != null) {
            throw T_Fail.exceptionFail(u3.error);
        }
        this.PASS("M002");
    }

    void M003() throws StandardException, T_Fail {
        Lockable[] locks = new Lockable[]{new T_L2(2)};
        T_User u1 = new T_User(3, this.lf, locks, 100L, 0L);
        T_User u2 = new T_User(3, this.lf, locks, 100L, 0L);
        T_User u3 = new T_User(3, this.lf, locks, 100L, 0L);
        Thread t1 = new Thread(u1);
        Thread t2 = new Thread(u2);
        Thread t3 = new Thread(u3);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
            t2.join();
            t3.join();
        }
        catch (InterruptedException ie) {
            throw T_Fail.exceptionFail(ie);
        }
        if (u1.error != null) {
            throw T_Fail.exceptionFail(u1.error);
        }
        if (u2.error != null) {
            throw T_Fail.exceptionFail(u2.error);
        }
        if (u3.error != null) {
            throw T_Fail.exceptionFail(u3.error);
        }
        this.PASS("M003");
    }

    void M004() throws StandardException, T_Fail {
        Lockable[] locks = new Lockable[]{new T_L2(2)};
        T_User u1 = new T_User(4, this.lf, locks, 100L, 0L);
        T_User u2 = new T_User(4, this.lf, locks, 100L, 0L);
        T_User u3 = new T_User(4, this.lf, locks, 100L, 0L);
        Thread t1 = new Thread(u1);
        Thread t2 = new Thread(u2);
        Thread t3 = new Thread(u3);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
            t2.join();
            t3.join();
        }
        catch (InterruptedException ie) {
            throw T_Fail.exceptionFail(ie);
        }
        if (u1.error != null) {
            throw T_Fail.exceptionFail(u1.error);
        }
        if (u2.error != null) {
            throw T_Fail.exceptionFail(u2.error);
        }
        if (u3.error != null) {
            throw T_Fail.exceptionFail(u3.error);
        }
        this.PASS("M004");
    }

    void checkLockCount(CompatibilitySpace cs, int expected) throws T_Fail {
        boolean expect = expected != 0;
        boolean got = this.lf.areLocksHeld(cs);
        if (got != expect) {
            throw T_Fail.testFailMsg("Expected lock count (" + expect + "), got (" + got + ")");
        }
    }

    void checkLockGroupCount(CompatibilitySpace cs, Object group, int expected) throws T_Fail {
        boolean expect = expected != 0;
        boolean got = this.lf.areLocksHeld(cs, group);
        if (got != expect) {
            throw T_Fail.testFailMsg("Expected lock count (" + expect + "), got (" + got + ")");
        }
    }

    private static Object startSystemModule(final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.startSystemModule((String)factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }
}

