/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ShutdownWithoutDeregisterPermissionTest
extends BaseJDBCTestCase {
    public ShutdownWithoutDeregisterPermissionTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new SecurityManagerSetup(TestConfiguration.embeddedSuite(ShutdownWithoutDeregisterPermissionTest.class), "org/apache/derbyTesting/functionTests/tests/engine/noDeregisterPermission.policy");
    }

    public void testShutdownWithoutPermission() throws SQLException {
        this.getConnection().close();
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        testConfiguration.shutdownEngine();
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        Driver driver = null;
        while (driver == null && enumeration.hasMoreElements()) {
            Driver driver2 = enumeration.nextElement();
            if (!driver2.getClass().getName().startsWith("org.apache.derby.iapi.jdbc.AutoloadedDriver")) continue;
            driver = driver2;
        }
        if (JDBC.vmSupportsJDBC42()) {
            ShutdownWithoutDeregisterPermissionTest.assertNotNull((String)"Expected driver to be registered", driver);
        } else {
            ShutdownWithoutDeregisterPermissionTest.assertNull((String)"Expected driver to be deregistered", driver);
        }
    }
}

