/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.IndexStatsUtil;

public class AutomaticIndexStatisticsMultiTest
extends BaseJDBCTestCase {
    private static final String TAB = "MTSEL";
    private static final int _100K = 100000;

    public AutomaticIndexStatisticsMultiTest(String string) {
        super(string);
    }

    public void testMTSelect() throws Exception {
        Object object;
        int n;
        this.prepareTable(true);
        int n2 = 5;
        long l = 10000L;
        MTCompileThread[] mTCompileThreadArray = new MTCompileThread[n2];
        for (int i = 0; i < n2; ++i) {
            mTCompileThreadArray[i] = new MTCompileThread(this.openDefaultConnection(), l);
        }
        Thread[] threadArray = new Thread[n2];
        for (n = 0; n < n2; ++n) {
            threadArray[n] = new Thread(mTCompileThreadArray[n]);
            threadArray[n].start();
        }
        for (n = 0; n < n2; ++n) {
            threadArray[n].join(600000L);
        }
        n = 0;
        int n3 = 0;
        ArrayList<SQLException> arrayList = new ArrayList<SQLException>();
        for (int i = 0; i < n2; ++i) {
            object = mTCompileThreadArray[i];
            int n4 = ((MTCompileThread)object).getCount();
            int n5 = ((MTCompileThread)object).getErrorCount();
            n += n4;
            n3 += n5;
            arrayList.addAll(((MTCompileThread)object).getErrors());
        }
        AutomaticIndexStatisticsMultiTest.println("TOTAL = " + n + " (of which " + n3 + " errors)");
        if (n3 > 0) {
            StringWriter stringWriter = new StringWriter();
            object = new PrintWriter(stringWriter);
            ((PrintWriter)object).println(n3 + " select/compile errors reported:");
            for (SQLException sQLException : arrayList) {
                ((PrintWriter)object).println("------");
                sQLException.printStackTrace((PrintWriter)object);
            }
            ((PrintWriter)object).close();
            AutomaticIndexStatisticsMultiTest.fail((String)stringWriter.toString());
        }
        this.verifyStatistics();
        this.getTestConfiguration().shutdownDatabase();
    }

    public void testMTSelectWithDDL() throws Exception {
        Object object;
        int n;
        this.prepareTable(true);
        int n2 = 5;
        long l = 10000L;
        MTCompileThread[] mTCompileThreadArray = new MTCompileThread[n2];
        for (int i = 0; i < n2; ++i) {
            mTCompileThreadArray[i] = new MTCompileThread(this.openDefaultConnection(), l);
        }
        MTCreateDropThread mTCreateDropThread = new MTCreateDropThread(this.openDefaultConnection(), l);
        Thread[] threadArray = new Thread[n2 + 1];
        threadArray[0] = new Thread(mTCreateDropThread);
        threadArray[0].start();
        for (n = 0; n < n2; ++n) {
            threadArray[n + 1] = new Thread(mTCompileThreadArray[n]);
            threadArray[n + 1].start();
        }
        for (n = 0; n < n2; ++n) {
            threadArray[n].join(600000L);
        }
        n = 0;
        int n3 = 0;
        ArrayList<SQLException> arrayList = new ArrayList<SQLException>();
        for (int i = 0; i < n2; ++i) {
            object = mTCompileThreadArray[i];
            int n4 = ((MTCompileThread)object).getCount();
            int n5 = ((MTCompileThread)object).getErrorCount();
            n += n4;
            n3 += n5;
            arrayList.addAll(((MTCompileThread)object).getErrors());
        }
        AutomaticIndexStatisticsMultiTest.println("TOTAL = " + n + " (of which " + n3 + " errors) CREATES = " + mTCreateDropThread.getCreates());
        if (n3 > 0 || mTCreateDropThread.failed()) {
            StringWriter stringWriter = new StringWriter();
            object = new PrintWriter(stringWriter);
            ((PrintWriter)object).println("create/drop thread " + (mTCreateDropThread.failed() ? "died" : "survived") + ", " + n3 + " select/compile errors reported:");
            if (mTCreateDropThread.failed()) {
                ((PrintWriter)object).println("create/drop thread error: ");
                mTCreateDropThread.getError().printStackTrace((PrintWriter)object);
            }
            ((PrintWriter)object).println("select/compile errors:");
            for (SQLException sQLException : arrayList) {
                ((PrintWriter)object).println("------");
                sQLException.printStackTrace((PrintWriter)object);
            }
            ((PrintWriter)object).close();
            AutomaticIndexStatisticsMultiTest.fail((String)stringWriter.toString());
        }
        this.verifyStatistics();
        this.getTestConfiguration().shutdownDatabase();
    }

    private void verifyStatistics() throws SQLException {
        IndexStatsUtil indexStatsUtil = new IndexStatsUtil(this.getConnection(), 5000L);
        IndexStatsUtil.IdxStats[] idxStatsArray = indexStatsUtil.getStatsTable(TAB, 2);
        block4: for (int i = 0; i < idxStatsArray.length; ++i) {
            IndexStatsUtil.IdxStats idxStats = idxStatsArray[i];
            AutomaticIndexStatisticsMultiTest.assertEquals((long)100000L, (long)idxStats.rows);
            switch (idxStats.lcols) {
                case 1: {
                    AutomaticIndexStatisticsMultiTest.assertEquals((long)10L, (long)idxStats.card);
                    continue block4;
                }
                case 2: {
                    AutomaticIndexStatisticsMultiTest.assertEquals((long)100000L, (long)idxStats.card);
                    continue block4;
                }
                default: {
                    AutomaticIndexStatisticsMultiTest.fail((String)("unexpected number of leading columns: " + idxStats.lcols));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prepareTable(boolean bl) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = this.getConnection().getMetaData().getTables(null, null, TAB, null);
        if (resultSet.next()) {
            AutomaticIndexStatisticsMultiTest.assertFalse((boolean)resultSet.next());
            resultSet.close();
            if (!bl) {
                AutomaticIndexStatisticsMultiTest.println("table MTSEL already exists, reusing");
                return;
            }
            AutomaticIndexStatisticsMultiTest.println("table MTSEL already exists, dropping");
            statement.executeUpdate("drop table MTSEL");
        } else {
            resultSet.close();
        }
        statement.executeUpdate("create table MTSEL (val1 int, val2 int)");
        statement.executeUpdate("create index mtsel_idx on MTSEL (val1, val2)");
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into MTSEL values (?,?)");
        int n = 10;
        int n2 = 10000;
        int n3 = 0;
        while (true) {
            if (n3 >= n) {
                this.setAutoCommit(true);
                return;
            }
            preparedStatement.setInt(1, n3);
            for (int i = 0; i < n2; ++i) {
                preparedStatement.setInt(2, i);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            this.commit();
            AutomaticIndexStatisticsMultiTest.println("inserted block " + (n3 + 1) + "/" + n);
            ++n3;
        }
    }

    public static Test suite() {
        return new BaseTestSuite(AutomaticIndexStatisticsMultiTest.class);
    }

    private static class MTCreateDropThread
    implements Runnable {
        private final Connection con;
        private final long runTime;
        private volatile long creates;
        private volatile SQLException error;

        public MTCreateDropThread(Connection connection, long l) throws SQLException {
            this.con = connection;
            this.runTime = l;
        }

        @Override
        public void run() {
            long l = System.currentTimeMillis();
            try {
                ResultSet resultSet = this.con.getMetaData().getTables(null, null, "TMPTABLE", null);
                boolean bl = resultSet.next();
                resultSet.close();
                Statement statement = this.con.createStatement();
                while (System.currentTimeMillis() - l < this.runTime) {
                    if (bl) {
                        statement.executeUpdate("drop table TMPTABLE");
                    } else {
                        statement.executeUpdate("create table TMPTABLE(i int primary key, v varchar(30), b blob)");
                        ++this.creates;
                    }
                    bl = !bl;
                }
            }
            catch (SQLException sQLException) {
                this.error = sQLException;
                BaseTestCase.println("create/drop thread failed: " + sQLException.getMessage());
            }
        }

        public long getCreates() {
            return this.creates;
        }

        public boolean failed() {
            return this.error != null;
        }

        public SQLException getError() {
            return this.error;
        }
    }

    private static class MTCompileThread
    implements Runnable {
        private final Random rand = new Random();
        private final Connection con;
        private final long runTime;
        private final ArrayList<SQLException> errors = new ArrayList();
        private volatile int count;

        public MTCompileThread(Connection connection, long l) throws SQLException {
            this.con = connection;
            this.runTime = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = System.currentTimeMillis();
            int n = 0;
            while (System.currentTimeMillis() - l < this.runTime) {
                try {
                    this.con.prepareStatement("select * from mtsel where " + ++n + " = " + n + " AND val2 = " + (1 + this.rand.nextInt(10)));
                }
                catch (SQLException sQLException) {
                    MTCompileThread mTCompileThread = this;
                    synchronized (mTCompileThread) {
                        this.errors.add(sQLException);
                    }
                }
                ++this.count;
            }
        }

        public int getCount() {
            return this.count;
        }

        public synchronized int getErrorCount() {
            return this.errors.size();
        }

        public synchronized List<SQLException> getErrors() {
            return new ArrayList<SQLException>(this.errors);
        }
    }
}

