/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.storetests;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Barrier;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class st_derby715
extends BaseJDBCTestCase {
    private Barrier barrier;
    private List<Throwable> errors;

    public st_derby715(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = TestConfiguration.embeddedSuite(st_derby715.class);
        object = DatabasePropertyTestSetup.setLockTimeouts(object, 1, 60);
        object = new CleanDatabaseTestSetup((Test)object);
        return object;
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(8);
    }

    public void test_st_derby715() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table a (a integer)");
        statement.executeUpdate("create table b (b integer)");
        statement.close();
        this.commit();
        Connection connection = this.openDefaultConnection();
        Connection connection2 = this.openDefaultConnection();
        Statement statement2 = connection.createStatement();
        Statement statement3 = connection2.createStatement();
        for (int i = 0; i < 5; ++i) {
            Object object;
            this.barrier = new Barrier(2);
            this.errors = Collections.synchronizedList(new ArrayList());
            WorkerThread workerThread = new WorkerThread(statement2, "Thread 1", "a", "b");
            WorkerThread workerThread2 = new WorkerThread(statement3, "Thread 2", "b", "a");
            workerThread.start();
            workerThread2.start();
            workerThread.join();
            workerThread2.join();
            st_derby715.assertFalse((String)"Both threads succeeded", (boolean)this.errors.isEmpty());
            if (this.errors.size() > 1) {
                object = this.errors.iterator();
                while (object.hasNext()) {
                    Throwable throwable = (Throwable)object.next();
                    st_derby715.printStackTrace(throwable);
                }
                st_derby715.fail((String)"Both threads failed");
            }
            if ((object = this.errors.get(0)) instanceof SQLException) {
                st_derby715.assertSQLState("40001", (SQLException)object);
                st_derby715.println("Got expected deadlock: " + (Throwable)object);
                continue;
            }
            st_derby715.fail("Unexpected exception", (Throwable)object);
        }
        statement2.close();
        statement3.close();
    }

    @Override
    protected void tearDown() throws Exception {
        this.barrier = null;
        this.errors = null;
        super.tearDown();
    }

    private class WorkerThread
    extends Thread {
        private final Statement stmt;
        private final String id;
        private final String readTable;
        private final String writeTable;

        WorkerThread(Statement statement, String string, String string2, String string3) {
            this.stmt = statement;
            this.id = string;
            this.readTable = string2;
            this.writeTable = string3;
        }

        @Override
        public void run() {
            try {
                this._run();
            }
            catch (Throwable throwable) {
                st_derby715.this.errors.add(throwable);
            }
        }

        private void _run() throws SQLException, InterruptedException {
            BaseTestCase.println(this.id + " before selecting from " + this.readTable);
            JDBC.assertEmpty(this.stmt.executeQuery("select * from " + this.readTable));
            BaseTestCase.println(this.id + " after reading all rows");
            st_derby715.this.barrier.await();
            BaseTestCase.println(this.id + " before inserting into " + this.writeTable);
            this.stmt.execute("insert into " + this.writeTable + " values (1)");
            BaseTestCase.println(this.id + " after inserting");
            this.stmt.getConnection().rollback();
        }
    }
}

