/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derbyTesting.functionTests.tests.jdbc4.StatementTestSetup;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SetQueryTimeoutTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.Wrapper41Statement;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementTest
extends BaseJDBCTestCase {
    private Statement stmt = null;

    public StatementTest(String string) {
        super(string);
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        this.stmt = this.createStatement();
        StatementTest.assertFalse((String)"First statement must be open initially", (boolean)this.stmt.isClosed());
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.stmt != null) {
            this.stmt.close();
            this.stmt = null;
        }
        super.tearDown();
    }

    public void testIsClosedBasic() throws SQLException {
        ResultSet resultSet = this.stmt.executeQuery("select count(*) from stmtTable");
        StatementTest.assertFalse((String)"Statement should still be open", (boolean)this.stmt.isClosed());
        resultSet.close();
        StatementTest.assertFalse((String)"Statement should be open after ResultSet has been closed", (boolean)this.stmt.isClosed());
        this.stmt.close();
        StatementTest.assertTrue((String)"Statement should be closed, close() has been called", (boolean)this.stmt.isClosed());
    }

    public void testIsClosedWithTwoStatementsOnSameConnection() throws SQLException {
        Statement statement = this.createStatement();
        StatementTest.assertFalse((String)"Second statement must be open initially", (boolean)statement.isClosed());
        StatementTest.assertFalse((String)"First statement should not be closed when creating a second statement", (boolean)this.stmt.isClosed());
        ResultSet resultSet = statement.executeQuery("select count(*) from stmtTable");
        StatementTest.assertFalse((String)"Second statement should be open after call to execute()", (boolean)statement.isClosed());
        StatementTest.assertFalse((String)"First statement should be open after call to second statment's execute()", (boolean)this.stmt.isClosed());
        statement.close();
        StatementTest.assertTrue((String)"Second statement should be closed, close() has been called!", (boolean)statement.isClosed());
        StatementTest.assertFalse((String)"First statement should be open after call to second statment's close()", (boolean)this.stmt.isClosed());
    }

    public void testIsClosedWhenClosingConnection() throws SQLException {
        Statement statement = this.createStatement();
        StatementTest.assertFalse((String)"Second statement must be open initially", (boolean)statement.isClosed());
        statement.execute("select count(*) from stmtTable");
        StatementTest.assertFalse((String)"Second statement should be open after call to execute()", (boolean)statement.isClosed());
        this.rollback();
        Connection connection = this.getConnection();
        connection.close();
        StatementTest.assertTrue((String)"Connection should be closed after close()", (boolean)connection.isClosed());
        StatementTest.assertTrue((String)"First statement should be closed, as parent connection has been closed", (boolean)this.stmt.isClosed());
        StatementTest.assertTrue((String)"Second statement should be closed, as parent connection has been closed", (boolean)statement.isClosed());
    }

    public void testIsClosedWhenClosingConnectionInInvalidState() throws SQLException {
        this.stmt.executeQuery("select count(*) from stmtTable");
        Connection connection = this.stmt.getConnection();
        try {
            connection.close();
            StatementTest.fail((String)"Invalid transaction state exception was not thrown");
        }
        catch (SQLException sQLException) {
            String string = "25001";
            StatementTest.assertSQLState(string, sQLException);
        }
        StatementTest.assertFalse((String)"Statement should still be open, because Connection.close() failed", (boolean)this.stmt.isClosed());
        StatementTest.assertFalse((String)"Connection should still be open", (boolean)connection.isClosed());
        connection.commit();
        connection.close();
        StatementTest.assertTrue((String)"Connection should be closed after close()", (boolean)connection.isClosed());
        StatementTest.assertTrue((String)"Statement should be closed, because the connection has been closed", (boolean)this.stmt.isClosed());
        this.stmt.close();
        StatementTest.assertTrue((String)"Statement should still be closed", (boolean)this.stmt.isClosed());
    }

    public void testStatementExecuteAfterConnectionClose() throws SQLException {
        Connection connection = this.stmt.getConnection();
        connection.close();
        StatementTest.assertTrue((String)"Connection should be closed after close()", (boolean)connection.isClosed());
        try {
            this.stmt.executeQuery("select count(*) from stmtTable");
        }
        catch (SQLException sQLException) {
            StatementTest.assertEquals((String)"Unexpected SQL state for performing operations on a closed statement.", (String)"08003", (String)sQLException.getSQLState());
        }
        StatementTest.assertTrue((String)"Statement should be closed, because the connection has been closed", (boolean)this.stmt.isClosed());
    }

    public void testIsWrapperForStatement() throws SQLException {
        StatementTest.assertTrue((boolean)this.stmt.isWrapperFor(Statement.class));
    }

    public void testIsNotWrapperForPreparedStatement() throws SQLException {
        StatementTest.assertFalse((boolean)this.stmt.isWrapperFor(PreparedStatement.class));
    }

    public void testIsNotWrapperForCallableStatement() throws SQLException {
        StatementTest.assertFalse((boolean)this.stmt.isWrapperFor(CallableStatement.class));
    }

    public void testIsNotWrapperForResultSet() throws SQLException {
        StatementTest.assertFalse((boolean)this.stmt.isWrapperFor(ResultSet.class));
    }

    public void testUnwrapStatement() throws SQLException {
        Statement statement = this.stmt.unwrap(Statement.class);
        StatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.stmt, (Object)statement);
    }

    public void testUnwrapPreparedStatement() {
        try {
            PreparedStatement preparedStatement = this.stmt.unwrap(PreparedStatement.class);
            StatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException sQLException) {
            StatementTest.assertSQLState("XJ128", sQLException);
        }
    }

    public void testUnwrapCallableStatement() {
        try {
            CallableStatement callableStatement = this.stmt.unwrap(CallableStatement.class);
            StatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException sQLException) {
            StatementTest.assertSQLState("XJ128", sQLException);
        }
    }

    public void testUnwrapResultSet() throws SQLException {
        try {
            ResultSet resultSet = this.stmt.unwrap(ResultSet.class);
            StatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException sQLException) {
            StatementTest.assertSQLState("XJ128", sQLException);
        }
    }

    public void testPoolable() throws SQLException {
        StatementTest.assertFalse((String)"Statement cannot be poolable by default", (boolean)this.stmt.isPoolable());
        this.stmt.setPoolable(true);
        StatementTest.assertTrue((String)"Statement must be poolable", (boolean)this.stmt.isPoolable());
        this.stmt.setPoolable(false);
        StatementTest.assertFalse((String)"Statement cannot be poolable", (boolean)this.stmt.isPoolable());
    }

    public void test_jdbc4_1_queryTimeoutException() throws Exception {
        SQLException sQLException = null;
        PreparedStatement preparedStatement = this.prepareStatement("select columnnumber from sys.syscolumns c, sys.systables t\nwhere t.tablename = 'SYSTABLES'\nand t.tableid = c.referenceid\nand mod( delay_st( 5, c.columnnumber ), 3 ) = 0");
        StatementTest.println("Testing timeout exception for a " + preparedStatement.getClass().getName());
        SetQueryTimeoutTest.StatementExecutor statementExecutor = new SetQueryTimeoutTest.StatementExecutor(preparedStatement, true, 1);
        statementExecutor.start();
        statementExecutor.join();
        preparedStatement.close();
        sQLException = statementExecutor.getSQLException();
        StatementTest.assertNotNull((Object)sQLException);
        StatementTest.assertEquals((String)SQLTimeoutException.class.getName(), (String)sQLException.getClass().getName());
    }

    public void testCompletionClosure_jdbc4_1_implicitRSClosure() throws Exception {
        Connection connection = this.getConnection();
        connection.setHoldability(2);
        connection.setAutoCommit(true);
        PreparedStatement preparedStatement = connection.prepareStatement("values ( 1 )");
        StatementTest.println("Testing implicit closure WITH autocommit on a " + preparedStatement.getClass().getName());
        Wrapper41Statement wrapper41Statement = new Wrapper41Statement(preparedStatement);
        wrapper41Statement.closeOnCompletion();
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        resultSet.next();
        StatementTest.assertTrue((boolean)resultSet.isClosed());
        StatementTest.assertTrue((boolean)preparedStatement.isClosed());
        connection.setAutoCommit(false);
        preparedStatement = connection.prepareStatement("values ( 1 )");
        StatementTest.println("Testing implicit closure WITHOUT autocommit on a " + preparedStatement.getClass().getName());
        wrapper41Statement = new Wrapper41Statement(preparedStatement);
        wrapper41Statement.closeOnCompletion();
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        resultSet.next();
        StatementTest.assertFalse((boolean)resultSet.isClosed());
        StatementTest.assertFalse((boolean)preparedStatement.isClosed());
        connection.commit();
        StatementTest.assertTrue((boolean)resultSet.isClosed());
        StatementTest.assertTrue((boolean)preparedStatement.isClosed());
    }

    public void testLargeUpdate_jdbc4_2() throws Exception {
        Connection connection = this.getConnection();
        StatementTest.largeUpdate_jdbc4_2(connection);
    }

    public static void largeUpdate_jdbc4_2(Connection connection) throws Exception {
    }

    private static void largeUpdateTest(StatementWrapper statementWrapper, long l) throws Exception {
    }

    private static void largeUpdateTest(StatementWrapper statementWrapper, long l, long l2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("insert into bigintTable( col2 ) values ");
        for (long i = 0L; i < l2; ++i) {
            if (i > 0L) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("( " + i + " )");
        }
        String string = stringBuffer.toString();
        long l3 = l + l2;
        StatementTest.vetUpdateSize(statementWrapper, (int)l3, statementWrapper.getWrappedStatement().executeUpdate(string), l3);
        StatementTest.vetUpdateSize(statementWrapper, (int)l3, statementWrapper.getWrappedStatement().executeUpdate(string, 1), l3);
        StatementTest.vetUpdateSize(statementWrapper, (int)l3, statementWrapper.getWrappedStatement().executeUpdate(string, new int[]{1}), l3);
        StatementTest.vetUpdateSize(statementWrapper, (int)l3, statementWrapper.getWrappedStatement().executeUpdate(string, new String[]{"COL1"}), l3);
        StatementTest.vetUpdateSize(statementWrapper, l3, statementWrapper.executeLargeUpdate(string), l3);
        StatementTest.vetUpdateSize(statementWrapper, l3, statementWrapper.executeLargeUpdate(string, 1), l3);
        StatementTest.vetUpdateSize(statementWrapper, l3, statementWrapper.executeLargeUpdate(string, new int[]{1}), l3);
        StatementTest.vetUpdateSize(statementWrapper, l3, statementWrapper.executeLargeUpdate(string, new String[]{"COL1"}), l3);
    }

    private static void vetUpdateSize(StatementWrapper statementWrapper, int n, int n2, long l) throws Exception {
        StatementTest.assertEquals((int)n, (int)n2);
        StatementTest.assertEquals((int)n, (int)statementWrapper.getWrappedStatement().getUpdateCount());
        StatementTest.assertEquals((long)l, (long)statementWrapper.getLargeUpdateCount());
    }

    private static void vetUpdateSize(StatementWrapper statementWrapper, long l, long l2, long l3) throws Exception {
        StatementTest.assertEquals((long)l, (long)l2);
        StatementTest.assertEquals((int)((int)l), (int)statementWrapper.getWrappedStatement().getUpdateCount());
        StatementTest.assertEquals((long)l3, (long)statementWrapper.getLargeUpdateCount());
    }

    private static void largeBatchTest(StatementWrapper statementWrapper, long l) throws Exception {
    }

    private static void createBatch(StatementWrapper statementWrapper) throws Exception {
        statementWrapper.getWrappedStatement().clearBatch();
        StatementTest.truncate(statementWrapper);
        statementWrapper.getWrappedStatement().addBatch("insert into bigintTable( col2 ) values ( 1 )");
        statementWrapper.getWrappedStatement().addBatch("update bigintTable set col2 = 2");
        statementWrapper.getWrappedStatement().addBatch("insert into bigintTable( col2 ) values ( 3 ), ( 4 )");
    }

    private static void largeMaxRowsTest(StatementWrapper statementWrapper, long l) throws Exception {
    }

    private static void largeBatchUpdateExceptionTest(StatementWrapper statementWrapper, long l) throws Exception {
    }

    public static void setRowCountBase(Statement statement, boolean bl, long l) throws Exception {
        if (bl) {
            ClientStatement.setFetchedRowBase((long)l);
        } else {
            statement.execute("call setRowCountBase( " + l + " )");
        }
    }

    private static void truncate(StatementWrapper statementWrapper) throws Exception {
        statementWrapper.getWrappedStatement().execute("truncate table bigintTable");
    }

    private static int[] squashLongs(long[] lArray) {
        int n = lArray == null ? 0 : lArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("StatementTest suite");
        baseTestSuite.addTest((Test)new StatementTestSetup((Test)new BaseTestSuite(StatementTest.class)));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)new StatementTestSetup((Test)new BaseTestSuite(StatementTest.class))));
        return baseTestSuite;
    }

    public static void setRowCountBase(long l) {
        EmbedResultSet.setFetchedRowBase((long)l);
        RowUtil.setRowCountBase((long)l);
    }

    public static class StatementWrapper {
        private Statement _wrappedStatement;

        public StatementWrapper(Statement statement) {
            this._wrappedStatement = statement;
        }

        public Statement getWrappedStatement() {
            return this._wrappedStatement;
        }

        public long[] executeLargeBatch() throws SQLException {
            return (long[])this.invoke("executeLargeBatch", new Class[0], new Object[0]);
        }

        public long executeLargeUpdate(String string) throws SQLException {
            return (Long)this.invoke("executeLargeUpdate", new Class[]{String.class}, new Object[]{string});
        }

        public long executeLargeUpdate(String string, int n) throws SQLException {
            return (Long)this.invoke("executeLargeUpdate", new Class[]{String.class, Integer.TYPE}, new Object[]{string, n});
        }

        public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
            return (Long)this.invoke("executeLargeUpdate", new Class[]{String.class, nArray.getClass()}, new Object[]{string, nArray});
        }

        public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
            return (Long)this.invoke("executeLargeUpdate", new Class[]{String.class, stringArray.getClass()}, new Object[]{string, stringArray});
        }

        public long getLargeMaxRows() throws SQLException {
            return (Long)this.invoke("getLargeMaxRows", new Class[0], new Object[0]);
        }

        public long getLargeUpdateCount() throws SQLException {
            return (Long)this.invoke("getLargeUpdateCount", new Class[0], new Object[0]);
        }

        public void setLargeMaxRows(long l) throws SQLException {
            this.invoke("setLargeMaxRows", new Class[]{Long.TYPE}, new Object[]{l});
        }

        protected Object invoke(String string, Class[] classArray, Object[] objectArray) throws SQLException {
            try {
                Method method = this._wrappedStatement.getClass().getMethod(string, classArray);
                return method.invoke((Object)this._wrappedStatement, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw this.wrap(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.wrap(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.wrap(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.wrap(invocationTargetException);
            }
        }

        private SQLException wrap(Throwable throwable) {
            return new SQLException(throwable.getMessage(), throwable);
        }
    }
}

