/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.SocketFactory;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NetworkServerControlApiTest
extends BaseJDBCTestCase {
    private static final String NON_ASCII_USER = "bj\u00f8rn";
    private static final String NON_ASCII_PASSWORD = "l\u00f8yndom";

    public NetworkServerControlApiTest(String string) {
        super(string);
    }

    public void test_01_WrongUsage() throws Exception {
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"No command given.", "Usage: "}, stringArray, 1);
        stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "-h", "localhost"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"No command given.", "Usage: "}, stringArray, 1);
        stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "unknowncmd"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Command unknowncmd is unknown.", "Usage: "}, stringArray, 1);
        stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "-unknownarg"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Argument -unknownarg is unknown.", "Usage: "}, stringArray, 1);
        stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping", "arg1"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Invalid number of arguments for command ping.", "Usage: "}, stringArray, 1);
    }

    public void test_02_TraceCommands() throws Exception {
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl();
        String string = NetworkServerControlApiTest.getSystemProperty("derby.system.home");
        networkServerControl.setTraceDirectory(string);
        networkServerControl.trace(true);
        networkServerControl.ping();
        NetworkServerControlApiTest.assertTrue((boolean)this.fileExists(string + "/Server3.trace"));
        networkServerControl.trace(false);
        networkServerControl.setTraceDirectory("/");
        try {
            networkServerControl.trace(true);
            NetworkServerControlApiTest.fail((String)"Should have gotten an exception turning on tracing");
        }
        catch (Exception exception) {
            // empty catch block
        }
        networkServerControl.ping();
    }

    public void xtestTraceSystemPropertiesNoPermission() throws SQLException {
        NetworkServerControlApiTest.assertEquals((String)NetworkServerControlApiTest.getSystemProperty("derby.drda.traceAll"), (String)"true");
        NetworkServerControlApiTest.assertEquals((String)NetworkServerControlApiTest.getSystemProperty("derby.drda.traceDirectory"), (String)"/");
        Connection connection = this.getConnection();
        NetworkServerControlApiTest.assertFalse((boolean)connection.getMetaData().isReadOnly());
    }

    public void xtestTraceSystemPropertiesHasPermission() throws SQLException {
        String string = NetworkServerControlApiTest.getSystemProperty("derby.system.home");
        NetworkServerControlApiTest.assertEquals((String)NetworkServerControlApiTest.getSystemProperty("derby.drda.traceAll"), (String)"true");
        NetworkServerControlApiTest.assertEquals((String)NetworkServerControlApiTest.getSystemProperty("derby.drda.traceDirectory"), (String)(string + "/trace"));
        Connection connection = this.getConnection();
        NetworkServerControlApiTest.assertFalse((boolean)connection.getMetaData().isReadOnly());
        NetworkServerControlApiTest.assertTrue((boolean)this.fileExists(string + "/trace/Server1.trace"));
    }

    public void xtestShutdownWithNonASCIICredentials() throws Exception {
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl();
        NetworkServerTestSetup.pingForServerStart(networkServerControl);
        networkServerControl.shutdown();
        NetworkServerTestSetup.pingForServerUp(networkServerControl, null, false);
    }

    public void test_03_Ping() throws Exception {
        String string = TestConfiguration.getCurrent().getHostName();
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl();
        networkServerControl.ping();
        networkServerControl = new NetworkServerControl(this.privInetAddressGetByName(string), 9393);
        try {
            networkServerControl.ping();
            NetworkServerControlApiTest.fail((String)"Should not have been able to ping on port 9393");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void test_03_ping_args() throws Exception {
        String string = this.tryPingDbError("mydatabase", "myuser", "mypassword");
        NetworkServerControlApiTest.assertEquals((String)"Usage", (String)string.substring(0, 5));
        string = this.tryPingDbError("some/sorta/db", "someone", "somecredentials");
        NetworkServerControlApiTest.assertEquals((String)"Usage", (String)string.substring(0, 5));
        string = this.tryPingDbError("\\\\192.168.1.2\\guest\\db1", "tata", "tata");
        NetworkServerControlApiTest.assertEquals((String)"Usage", (String)string.substring(0, 5));
        string = this.tryPingDbError("my/nocred/db", "", "");
        NetworkServerControlApiTest.assertEquals((String)"Usage", (String)string.substring(0, 5));
        string = this.tryPingDbOK("", "scarface", "evildoer");
        NetworkServerControlApiTest.assertEquals((String)"OK", (String)string.substring(0, 2));
    }

    private Socket privilegedClientSocket(String string, int n) throws Exception {
        return SocketFactory.getDefault().createSocket(InetAddress.getByName(string), n);
    }

    private static String byteArrayToHex(byte[] byArray, int n) {
        if (n < 0) {
            return "STRING OF NEGATIVE LENGTH(" + n + ")";
        }
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(String.format("%02x", byArray[i]));
        }
        return stringBuilder.toString();
    }

    private String tryPingDbError(String string, String string2, String string3) throws Exception {
        return this.tryPingDbTest(2, string, string2, string3);
    }

    private String tryPingDbOK(String string, String string2, String string3) throws Exception {
        return this.tryPingDbTest(0, string, string2, string3);
    }

    private String tryPingDbTest(int n, String string, String string2, String string3) throws Exception {
        Socket socket = this.privilegedClientSocket(TestConfiguration.getCurrent().getHostName(), TestConfiguration.getCurrent().getPort());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = "CMD:".getBytes("UTF8");
        dataOutputStream.write(byArray, 0, byArray.length);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(2);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(4);
        byArray = string.getBytes("UTF8");
        dataOutputStream.writeByte((byte)(byArray.length >> 8));
        dataOutputStream.writeByte((byte)byArray.length);
        dataOutputStream.write(byArray, 0, byArray.length);
        byArray = string2.getBytes("UTF8");
        dataOutputStream.writeByte((byte)(byArray.length >> 8));
        dataOutputStream.writeByte((byte)byArray.length);
        dataOutputStream.write(byArray, 0, byArray.length);
        byArray = string3.getBytes("UTF8");
        dataOutputStream.writeByte((byte)(byArray.length >> 8));
        dataOutputStream.writeByte((byte)byArray.length);
        dataOutputStream.write(byArray, 0, byArray.length);
        byteArrayOutputStream.writeTo(socket.getOutputStream());
        dataOutputStream.flush();
        byteArrayOutputStream.reset();
        socket.shutdownOutput();
        byte[] byArray2 = new byte[1024];
        int n2 = socket.getInputStream().read(byArray2);
        socket.close();
        if (n2 < 0) {
            return "DISCONNECT";
        }
        String string4 = "RPY:";
        int n3 = string4.length();
        NetworkServerControlApiTest.assertTrue((n2 > n3 ? 1 : 0) != 0);
        String string5 = new String(byArray2, 0, n3, "UTF8");
        NetworkServerControlApiTest.assertEquals((String)string4, (String)string5);
        NetworkServerControlApiTest.assertEquals((int)n, (int)byArray2[n3++]);
        if (n == 0) {
            return "OK";
        }
        int n4 = ((byArray2[n3++] & 0xFF) << 8) + (byArray2[n3++] & 0xFF);
        String string6 = new String(byArray2, n3, n4, "UTF8");
        return string6;
    }

    private InetAddress privInetAddressGetByName(String string) throws UnknownHostException {
        return InetAddress.getByName(string);
    }

    private boolean fileExists(String string) {
        return PrivilegedFileOpsForTests.exists(new File(string));
    }

    private static Test decorateTest() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(NetworkServerControlApiTest.class);
        baseTestSuite = TestConfiguration.clientServerDecorator((Test)baseTestSuite);
        return baseTestSuite;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("NetworkServerControlApiTest");
        if (!Derby.hasServer()) {
            return baseTestSuite;
        }
        baseTestSuite.addTest(NetworkServerControlApiTest.decorateTest());
        baseTestSuite = NetworkServerControlApiTest.decorateSystemPropertyTests(baseTestSuite);
        baseTestSuite.addTest(NetworkServerControlApiTest.decorateShutdownTest("xtestShutdownWithNonASCIICredentials", NON_ASCII_USER, NON_ASCII_PASSWORD));
        return baseTestSuite;
    }

    private static BaseTestSuite decorateSystemPropertyTests(BaseTestSuite baseTestSuite) {
        Properties properties = new Properties();
        properties.put("derby.drda.traceDirectory", "/");
        properties.put("derby.drda.traceAll", "true");
        baseTestSuite.addTest((Test)new SystemPropertyTestSetup(TestConfiguration.clientServerDecorator((Test)new NetworkServerControlApiTest("xtestTraceSystemPropertiesNoPermission")), properties));
        Properties properties2 = new Properties();
        properties2.put("derby.drda.traceDirectory", NetworkServerControlApiTest.getSystemProperty("derby.system.home") + "/trace");
        properties2.put("derby.drda.traceAll", "true");
        baseTestSuite.addTest((Test)new SystemPropertyTestSetup(TestConfiguration.clientServerDecorator((Test)new NetworkServerControlApiTest("xtestTraceSystemPropertiesHasPermission")), properties2));
        return baseTestSuite;
    }

    private static Test decorateShutdownTest(String string, String string2, String string3) {
        Properties properties = new Properties();
        properties.setProperty("derby.connection.requireAuthentication", "true");
        properties.setProperty("derby.authentication.provider", "BUILTIN");
        properties.setProperty("derby.user." + string2, string3);
        Object object = new NetworkServerControlApiTest(string);
        object = TestConfiguration.clientServerDecorator((Test)object);
        object = new SystemPropertyTestSetup((Test)object, properties, true);
        object = TestConfiguration.changeUserDecorator((Test)object, string2, string3);
        return object;
    }

    public void test_04_MaxThreads_0() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "0", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Max threads changed to 0."}, stringArray, 0);
        int n = networkServerControl.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)0, (int)n);
    }

    public void test_05_MaxThreads_Neg1() throws Exception {
        String string;
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "-1", "-h", "localhost", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        stringArray[4] = string = TestUtil.getHostName();
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Max threads changed to 0."}, stringArray, 0);
        int n = networkServerControl.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)0, (int)n);
    }

    public void test_06_MaxThreads_Neg12() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "-12", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Invalid value, -12, for maxthreads.", "Usage: NetworkServerControl <commands>", "Commands:", "start [-h <host>] [-p <port number>] [-noSecurityManager] [-ssl <ssl mode>]", "shutdown [-h <host>][-p <port number>] [-ssl <ssl mode>] [-user <username>] [-password <password>]", "ping [-h <host>][-p <port number>] [-ssl <ssl mode>]", "sysinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "runtimeinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "logconnections { on|off } [-h <host>][-p <port number>] [-ssl <ssl mode>]", "maxthreads <max>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "timeslice <milliseconds>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "trace { on|off } [-s <session id>][-h <host>][-p <port number>] [-ssl <ssl mode>]", "tracedirectory <trace directory>[-h <host>][-p <port number>] [-ssl <ssl mode>]"}, stringArray, 1);
        int n = networkServerControl.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)0, (int)n);
    }

    public void test_07_MaxThreads_2147483647() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "2147483647", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Max threads changed to 2147483647."}, stringArray, 0);
        int n = networkServerControl.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)Integer.MAX_VALUE, (int)n);
    }

    public void test_08_MaxThreads_9000() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "9000", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Max threads changed to 9000."}, stringArray, 0);
        int n = networkServerControl.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)9000, (int)n);
    }

    public void test_09_MaxThreads_Invalid() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "10000", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Max threads changed to 10000."}, stringArray, 0);
        int n = networkServerControl.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)10000, (int)n);
        String[] stringArray2 = new String[]{"org.apache.derby.drda.NetworkServerControl", "maxthreads", "a"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Invalid value, a, for maxthreads.", "Usage: NetworkServerControl <commands>", "Commands:", "start [-h <host>] [-p <port number>] [-noSecurityManager] [-ssl <ssl mode>]", "shutdown [-h <host>][-p <port number>] [-ssl <ssl mode>] [-user <username>] [-password <password>]", "ping [-h <host>][-p <port number>] [-ssl <ssl mode>]", "sysinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "runtimeinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "logconnections { on|off } [-h <host>][-p <port number>] [-ssl <ssl mode>]", "maxthreads <max>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "timeslice <milliseconds>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "trace { on|off } [-s <session id>][-h <host>][-p <port number>] [-ssl <ssl mode>]", "tracedirectory <trace directory>[-h <host>][-p <port number>] [-ssl <ssl mode>]"}, stringArray2, 1);
        n = networkServerControl.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)10000, (int)n);
    }

    public void test_10_MaxThreadsCallable_0() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        networkServerControl.setMaxThreads(0);
        int n = networkServerControl.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)0, (int)n);
    }

    public void test_11_MaxThreadsCallable_Neg1() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        networkServerControl.setMaxThreads(-1);
        int n = networkServerControl.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)0, (int)n);
    }

    public void test_12_MaxThreadsCallable_Neg12() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        try {
            networkServerControl.setMaxThreads(-2);
            NetworkServerControlApiTest.fail((String)"Should have thrown an exception with 'DRDA_InvalidValue.U:Invalid value, -2, for maxthreads.'");
        }
        catch (Exception exception) {
            NetworkServerControlApiTest.assertEquals((String)"DRDA_InvalidValue.U:Invalid value, -2, for maxthreads.", (String)exception.getMessage());
        }
    }

    public void test_13_MaxThreadsCallable_2147483647() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        networkServerControl.setMaxThreads(Integer.MAX_VALUE);
        int n = networkServerControl.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)Integer.MAX_VALUE, (int)n);
    }

    public void test_14_MaxThreadsCallable_9000() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        networkServerControl.setMaxThreads(9000);
        int n = networkServerControl.getMaxThreads();
        NetworkServerControlApiTest.assertEquals((String)"Fail! Max threads value incorrect!", (int)9000, (int)n);
    }

    public void test_15_TimeSlice_0() throws Exception {
        int n = 0;
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "0", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Time slice changed to 0."}, stringArray, 0);
        int n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
    }

    public void test_16_TimeSlice_Neg1() throws Exception {
        String string;
        int n = 0;
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "-1", "-h", "localhost", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        stringArray[4] = string = TestUtil.getHostName();
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Time slice changed to 0."}, stringArray, 0);
        int n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
    }

    public void test_17_TimeSlice_Neg12() throws Exception {
        int n = 0;
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "-12", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Invalid value, -12, for timeslice.", "Usage: NetworkServerControl <commands> ", "Commands:", "start [-h <host>] [-p <port number>] [-noSecurityManager] [-ssl <ssl mode>]", "shutdown [-h <host>][-p <port number>] [-ssl <ssl mode>] [-user <username>] [-password <password>]", "ping [-h <host>][-p <port number>] [-ssl <ssl mode>]", "sysinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "runtimeinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "logconnections { on|off } [-h <host>][-p <port number>] [-ssl <ssl mode>]", "maxthreads <max>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "timeslice <milliseconds>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "trace { on|off } [-s <session id>][-h <host>][-p <port number>] [-ssl <ssl mode>]", "tracedirectory <trace directory>[-h <host>][-p <port number>] [-ssl <ssl mode>]"}, stringArray, 1);
        int n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
    }

    public void test_18_TimeSlice_2147483647() throws Exception {
        int n = Integer.MAX_VALUE;
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "2147483647", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Time slice changed to 2147483647."}, stringArray, 0);
        int n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
    }

    public void test_19_TimeSlice_9000() throws Exception {
        int n = 9000;
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "9000", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Time slice changed to 9000."}, stringArray, 0);
        int n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
    }

    public void test_20_TimeSlice_a() throws Exception {
        int n = 8000;
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "8000", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Time slice changed to 8000."}, stringArray, 0);
        int n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
        String[] stringArray2 = new String[]{"org.apache.derby.drda.NetworkServerControl", "timeslice", "a"};
        NetworkServerControlApiTest.assertExecJavaCmdAsExpected(new String[]{"Invalid value, a, for timeslice.", "Usage: NetworkServerControl <commands> ", "Commands:", "start [-h <host>] [-p <port number>] [-noSecurityManager] [-ssl <ssl mode>]", "shutdown [-h <host>][-p <port number>] [-ssl <ssl mode>] [-user <username>] [-password <password>]", "ping [-h <host>][-p <port number>] [-ssl <ssl mode>]", "sysinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "runtimeinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "logconnections { on|off } [-h <host>][-p <port number>] [-ssl <ssl mode>]", "maxthreads <max>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "timeslice <milliseconds>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "trace { on|off } [-s <session id>][-h <host>][-p <port number>] [-ssl <ssl mode>]", "tracedirectory <trace directory>[-h <host>][-p <port number>] [-ssl <ssl mode>]"}, stringArray2, 1);
        n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
    }

    public void test_21_TimeSliceCallable_0() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        int n = 0;
        networkServerControl.setTimeSlice(0);
        int n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
    }

    public void test_22_TimeSliceCallable_Neg1() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        int n = 0;
        networkServerControl.setTimeSlice(-1);
        int n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
    }

    public void test_23_TimeSliceCallable_Neg2() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        int n = 0;
        try {
            networkServerControl.setTimeSlice(-2);
        }
        catch (Exception exception) {
            NetworkServerControlApiTest.assertTrue((exception.getMessage().indexOf("Invalid value") != -1 ? 1 : 0) != 0);
        }
        int n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
    }

    public void test_24_TimeSliceCallable_2147483647() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        int n = Integer.MAX_VALUE;
        networkServerControl.setTimeSlice(Integer.MAX_VALUE);
        int n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
    }

    public void test_25_TimeSliceCallable_9000() throws Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(this.getMachineAddress(), TestConfiguration.getCurrent().getPort());
        int n = 9000;
        networkServerControl.setTimeSlice(9000);
        int n2 = networkServerControl.getTimeSlice();
        NetworkServerControlApiTest.assertEquals((int)n, (int)n2);
    }

    private InetAddress getMachineAddress() throws Exception {
        return InetAddress.getByName("localhost");
    }
}

