/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.storetests;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Barrier;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class st_derby715
extends BaseJDBCTestCase {
    private Barrier barrier;
    private List<Throwable> errors;

    public st_derby715(String name) {
        super(name);
    }

    public static Test suite() {
        Object test = TestConfiguration.embeddedSuite(st_derby715.class);
        test = DatabasePropertyTestSetup.setLockTimeouts(test, 1, 60);
        test = new CleanDatabaseTestSetup((Test)test);
        return test;
    }

    @Override
    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(8);
    }

    public void test_st_derby715() throws Exception {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table a (a integer)");
        stmt.executeUpdate("create table b (b integer)");
        stmt.close();
        this.commit();
        Connection c1 = this.openDefaultConnection();
        Connection c2 = this.openDefaultConnection();
        Statement stmt1 = c1.createStatement();
        Statement stmt2 = c2.createStatement();
        for (int i = 0; i < 5; ++i) {
            Throwable t;
            this.barrier = new Barrier(2);
            this.errors = Collections.synchronizedList(new ArrayList());
            WorkerThread test1 = new WorkerThread(stmt1, "Thread 1", "a", "b");
            WorkerThread test2 = new WorkerThread(stmt2, "Thread 2", "b", "a");
            test1.start();
            test2.start();
            test1.join();
            test2.join();
            st_derby715.assertFalse((String)"Both threads succeeded", (boolean)this.errors.isEmpty());
            if (this.errors.size() > 1) {
                for (Throwable t2 : this.errors) {
                    st_derby715.printStackTrace(t2);
                }
                st_derby715.fail((String)"Both threads failed");
            }
            if ((t = this.errors.get(0)) instanceof SQLException) {
                st_derby715.assertSQLState("40001", (SQLException)t);
                st_derby715.println("Got expected deadlock: " + String.valueOf(t));
                continue;
            }
            st_derby715.fail("Unexpected exception", t);
        }
        stmt1.close();
        stmt2.close();
    }

    @Override
    protected void tearDown() throws Exception {
        this.barrier = null;
        this.errors = null;
        super.tearDown();
    }

    private class WorkerThread
    extends Thread {
        private final Statement stmt;
        private final String id;
        private final String readTable;
        private final String writeTable;

        WorkerThread(Statement stmt, String id, String readTable, String writeTable) {
            this.stmt = stmt;
            this.id = id;
            this.readTable = readTable;
            this.writeTable = writeTable;
        }

        @Override
        public void run() {
            try {
                this._run();
            }
            catch (Throwable t) {
                st_derby715.this.errors.add(t);
            }
        }

        private void _run() throws SQLException, InterruptedException {
            BaseTestCase.println(this.id + " before selecting from " + this.readTable);
            JDBC.assertEmpty(this.stmt.executeQuery("select * from " + this.readTable));
            BaseTestCase.println(this.id + " after reading all rows");
            st_derby715.this.barrier.await();
            BaseTestCase.println(this.id + " before inserting into " + this.writeTable);
            this.stmt.execute("insert into " + this.writeTable + " values (1)");
            BaseTestCase.println(this.id + " after inserting");
            this.stmt.getConnection().rollback();
        }
    }
}

