/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.ValidationPercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.StaticPropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableFObj;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthPairProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class Table
extends TableFObj {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginBlock commonMarginBlock;
    private LengthRangeProperty blockProgressionDimension;
    private int borderCollapse;
    private LengthPairProperty borderSeparation;
    private int breakAfter;
    private int breakBefore;
    private String id;
    private LengthRangeProperty inlineProgressionDimension;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private int tableLayout;
    private int tableOmitFooterAtBreak;
    private int tableOmitHeaderAtBreak;
    private Length widowContentLimit;
    private Length orphanContentLimit;
    private static final int MINCOLWIDTH = 10000;
    protected List columns = null;
    private int columnIndex = 1;
    private BitSet usedColumnIndices = new BitSet();
    private TableBody tableHeader = null;
    private TableBody tableFooter = null;
    private boolean tableColumnFound = false;
    private boolean tableHeaderFound = false;
    private boolean tableFooterFound = false;
    private boolean tableBodyFound = false;
    private PropertyList propList;

    public Table(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonMarginBlock = pList.getMarginBlockProps();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.borderCollapse = pList.get(31).getEnum();
        this.borderSeparation = pList.get(45).getLengthPair();
        this.breakAfter = pList.get(58).getEnum();
        this.breakBefore = pList.get(59).getEnum();
        this.id = pList.get(113).getString();
        this.inlineProgressionDimension = pList.get(116).getLengthRange();
        this.keepTogether = pList.get(118).getKeep();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.tableLayout = pList.get(217).getEnum();
        this.tableOmitFooterAtBreak = pList.get(218).getEnum();
        this.tableOmitHeaderAtBreak = pList.get(219).getEnum();
        super.bind(pList);
        this.widowContentLimit = pList.get(252).getLength();
        this.orphanContentLimit = pList.get(253).getLength();
        if (this.borderCollapse != 129) {
            this.borderCollapse = 129;
            log.debug((Object)"A table has been forced to use the separate border model (border-collapse=\"separate\") as the collapsing border model is not implemented, yet.");
        }
        if (this.tableLayout == 9) {
            this.attributeWarning("table-layout=\"auto\" is currently not supported by FOP");
        }
        if (!this.isSeparateBorderModel() && this.getCommonBorderPaddingBackground().hasPadding(ValidationPercentBaseContext.getPseudoContextForValidationPurposes())) {
            this.attributeWarning("In collapsing border model a table does not have padding (see http://www.w3.org/TR/REC-CSS2/tables.html#collapsing-borders), but a non-zero value for padding was found. The padding will be ignored.");
        }
        this.propList = pList;
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
        this.getFOEventHandler().startTable(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            if ("marker".equals(localName)) {
                if (this.tableColumnFound || this.tableHeaderFound || this.tableFooterFound || this.tableBodyFound) {
                    this.nodesOutOfOrderError(loc, "fo:marker", "(table-column*,table-header?,table-footer?,table-body+)");
                }
            } else if ("table-column".equals(localName)) {
                this.tableColumnFound = true;
                if (this.tableHeaderFound || this.tableFooterFound || this.tableBodyFound) {
                    this.nodesOutOfOrderError(loc, "fo:table-column", "(table-header?,table-footer?,table-body+)");
                }
            } else if ("table-header".equals(localName)) {
                if (this.tableHeaderFound) {
                    this.tooManyNodesError(loc, "table-header");
                } else {
                    this.tableHeaderFound = true;
                    if (this.tableFooterFound || this.tableBodyFound) {
                        this.nodesOutOfOrderError(loc, "fo:table-header", "(table-footer?,table-body+)");
                    }
                }
            } else if ("table-footer".equals(localName)) {
                if (this.tableFooterFound) {
                    this.tooManyNodesError(loc, "table-footer");
                } else {
                    this.tableFooterFound = true;
                    if (this.tableBodyFound) {
                        this.nodesOutOfOrderError(loc, "fo:table-footer", "(table-body+)");
                    }
                }
            } else if ("table-body".equals(localName)) {
                this.tableBodyFound = true;
            } else {
                this.invalidChildError(loc, nsURI, localName);
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    protected void endOfNode() throws FOPException {
        if (!this.tableBodyFound) {
            this.missingChildElementError("(marker*,table-column*,table-header?,table-footer?,table-body+)");
        }
        if (!this.inMarker()) {
            int i = this.columns.size();
            while (--i >= 0) {
                TableColumn col = (TableColumn)this.columns.get(i);
                if (col == null) continue;
                col.releasePropertyList();
            }
            this.propList = null;
        }
        this.getFOEventHandler().endTable(this);
    }

    protected void addChildNode(FONode child) throws FOPException {
        int childId = child.getNameId();
        switch (childId) {
            case 51: {
                if (this.columns == null) {
                    this.columns = new ArrayList();
                }
                if (!this.inMarker()) {
                    this.addColumnNode((TableColumn)child);
                } else {
                    this.columns.add((TableColumn)child);
                }
                return;
            }
            case 24: {
                super.addChildNode(child);
                return;
            }
        }
        switch (childId) {
            case 52: {
                this.tableFooter = (TableBody)child;
                break;
            }
            case 53: {
                this.tableHeader = (TableBody)child;
                break;
            }
            default: {
                super.addChildNode(child);
            }
        }
    }

    protected void addDefaultColumn(Length colWidth, int colNr) throws FOPException {
        TableColumn defaultColumn = new TableColumn(this, true);
        StaticPropertyList pList = new StaticPropertyList(defaultColumn, this.propList);
        pList.setWritingMode();
        defaultColumn.bind(pList);
        if (colWidth != null) {
            defaultColumn.setColumnWidth(colWidth);
        }
        if (colNr != 0) {
            defaultColumn.setColumnNumber(colNr);
        }
        this.addColumnNode(defaultColumn);
    }

    private void addColumnNode(TableColumn col) {
        int colNumber = col.getColumnNumber();
        int colRepeat = col.getNumberColumnsRepeated();
        if (this.columns.size() < colNumber) {
            while (this.columns.size() < colNumber) {
                this.columns.add(null);
            }
        }
        this.columns.set(colNumber - 1, col);
        if (colRepeat > 1) {
            int i = colRepeat - 1;
            while (--i >= 0) {
                this.columns.add(col);
            }
        }
        int startIndex = this.columnIndex - 1;
        int endIndex = startIndex + colRepeat;
        this.flagColumnIndices(startIndex, endIndex);
    }

    public boolean isAutoLayout() {
        return this.tableLayout == 9;
    }

    public List getColumns() {
        return this.columns;
    }

    public TableBody getBody(int index) {
        return (TableBody)this.childNodes.get(index);
    }

    public TableBody getTableHeader() {
        return this.tableHeader;
    }

    public TableBody getTableFooter() {
        return this.tableFooter;
    }

    public boolean omitHeaderAtBreak() {
        return this.tableOmitHeaderAtBreak == 149;
    }

    public boolean omitFooterAtBreak() {
        return this.tableOmitFooterAtBreak == 149;
    }

    public LengthRangeProperty getInlineProgressionDimension() {
        return this.inlineProgressionDimension;
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public boolean mustKeepTogether() {
        return !this.getKeepTogether().getWithinPage().isAuto() || !this.getKeepTogether().getWithinColumn().isAuto();
    }

    public int getBorderCollapse() {
        return this.borderCollapse;
    }

    public boolean isSeparateBorderModel() {
        return this.getBorderCollapse() == 129;
    }

    public LengthPairProperty getBorderSeparation() {
        return this.borderSeparation;
    }

    public Length getWidowContentLimit() {
        return this.widowContentLimit;
    }

    public Length getOrphanContentLimit() {
        return this.orphanContentLimit;
    }

    public String getId() {
        return this.id;
    }

    public String getLocalName() {
        return "table";
    }

    public int getNameId() {
        return 46;
    }

    public int getCurrentColumnIndex() {
        return this.columnIndex;
    }

    public boolean isColumnNumberUsed(int colNr) {
        return this.usedColumnIndices.get(colNr - 1);
    }

    public void setCurrentColumnIndex(int newIndex) {
        this.columnIndex = newIndex;
    }

    protected void flagColumnIndices(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.usedColumnIndices.set(i);
        }
        while (this.usedColumnIndices.get(this.columnIndex - 1)) {
            ++this.columnIndex;
        }
    }

    public FONode clone(FONode parent, boolean removeChildren) throws FOPException {
        FObj fobj = (FObj)super.clone(parent, removeChildren);
        if (removeChildren) {
            Table t = (Table)fobj;
            t.columns = null;
            t.tableHeader = null;
            t.tableFooter = null;
        }
        return fobj;
    }
}

