/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.factory;

import java.util.Collection;
import java.util.Iterator;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.factory.Messagefactory;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ResultResponse;

public abstract class ResponseFactory
implements Messagefactory {
    private static final byte[] DEFAULT_SUCCESS = new byte[]{10, 1, 0, 4, 0, 4, 0};
    private static final byte[] EMPTY_MATCHED_DN = new byte[]{4, 0};

    protected ResponseFactory() {
    }

    protected void encodeReferralUrls(Asn1Buffer buffer, Iterator<String> urls) {
        if (urls.hasNext()) {
            String url = urls.next();
            this.encodeReferralUrls(buffer, urls);
            BerValue.encodeOctetString((Asn1Buffer)buffer, (String)url);
        }
    }

    protected void encodeLdapResultReverse(Asn1Buffer buffer, LdapResult ldapResult) {
        if (ldapResult.isDefaultSuccess()) {
            buffer.put(DEFAULT_SUCCESS);
            return;
        }
        Referral referral = ldapResult.getReferral();
        if (referral != null) {
            int start = buffer.getPos();
            Collection urls = referral.getLdapUrls();
            if (urls != null) {
                this.encodeReferralUrls(buffer, urls.iterator());
            }
            BerValue.encodeSequence((Asn1Buffer)buffer, (byte)-93, (int)start);
        }
        BerValue.encodeOctetString((Asn1Buffer)buffer, (String)ldapResult.getDiagnosticMessage());
        if (ldapResult.getMatchedDn() != null) {
            BerValue.encodeOctetString((Asn1Buffer)buffer, (String)ldapResult.getMatchedDn().getName());
        } else {
            buffer.put(EMPTY_MATCHED_DN);
        }
        BerValue.encodeEnumerated((Asn1Buffer)buffer, (int)ldapResult.getResultCode().getValue());
    }

    protected void encodeReverse(LdapApiService codec, Asn1Buffer buffer, byte tag, Message message) {
        int start = buffer.getPos();
        this.encodeLdapResultReverse(buffer, ((ResultResponse)message).getLdapResult());
        BerValue.encodeSequence((Asn1Buffer)buffer, (byte)tag, (int)start);
    }
}

