/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.thread.Scheduler;

public class ScheduledExecutorScheduler
extends AbstractLifeCycle
implements Scheduler {
    private final String name;
    private final boolean daemon;
    private volatile ScheduledThreadPoolExecutor scheduler;
    private ClassLoader classloader;

    public ScheduledExecutorScheduler() {
        this(null, false);
    }

    public ScheduledExecutorScheduler(String name, boolean daemon) {
        this(name, daemon, Thread.currentThread().getContextClassLoader());
    }

    public ScheduledExecutorScheduler(String name, boolean daemon, ClassLoader threadFactoryClassLoader) {
        this.name = name == null ? "Scheduler-" + this.hashCode() : name;
        this.daemon = daemon;
        this.classloader = threadFactoryClassLoader;
    }

    @Override
    protected void doStart() throws Exception {
        this.scheduler = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, ScheduledExecutorScheduler.this.name);
                thread.setDaemon(ScheduledExecutorScheduler.this.daemon);
                thread.setContextClassLoader(ScheduledExecutorScheduler.this.classloader);
                return thread;
            }
        });
        this.scheduler.setRemoveOnCancelPolicy(true);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.scheduler.shutdownNow();
        super.doStop();
        this.scheduler = null;
    }

    @Override
    public Scheduler.Task schedule(Runnable task, long delay, TimeUnit unit) {
        ScheduledFuture<?> result = this.scheduler.schedule(task, delay, unit);
        return new ScheduledFutureTask(result);
    }

    private class ScheduledFutureTask
    implements Scheduler.Task {
        private final ScheduledFuture<?> scheduledFuture;

        public ScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public boolean cancel() {
            return this.scheduledFuture.cancel(false);
        }
    }
}

