/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.jaas.internal;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.jaas.internal.BundleLoginModuleCreator;
import org.apache.felix.jaas.internal.ConfigSpiOsgi;
import org.apache.felix.jaas.internal.JaasConfigFactory;
import org.apache.felix.jaas.internal.JaasWebConsolePlugin;
import org.apache.felix.jaas.internal.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private BundleLoginModuleCreator loginModuleCreator;
    private JaasConfigFactory jaasConfigFactory;
    private ConfigSpiOsgi configSpi;
    private Logger logger;

    public void start(BundleContext context) throws Exception {
        this.logger = new Logger(context);
        this.loginModuleCreator = new BundleLoginModuleCreator(context, this.logger);
        this.jaasConfigFactory = new JaasConfigFactory(context, this.loginModuleCreator, this.logger);
        this.configSpi = new ConfigSpiOsgi(context, this.logger);
        this.registerWebConsolePlugin(context);
        this.loginModuleCreator.open();
        this.configSpi.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.loginModuleCreator != null) {
            this.loginModuleCreator.close();
        }
        if (this.configSpi != null) {
            this.configSpi.close();
        }
        if (this.logger != null) {
            this.logger.close();
        }
    }

    private void registerWebConsolePlugin(BundleContext context) {
        Properties props = new Properties();
        props.put("service.vendor", "Apache Software Foundation");
        props.put("service.description", "JAAS Web Console Plugin");
        props.put("felix.webconsole.label", "jaas");
        props.put("felix.webconsole.title", "JAAS");
        props.put("felix.webconsole.configprinter.modes", "always");
        context.registerService("javax.servlet.Servlet", (Object)new PluginServiceFactory(), (Dictionary)props);
    }

    private class PluginServiceFactory
    implements ServiceFactory {
        private PluginServiceFactory() {
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return new JaasWebConsolePlugin(Activator.this.configSpi, Activator.this.loginModuleCreator);
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

