/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.ds.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.plugins.ds.internal.Util;
import org.apache.felix.webconsole.plugins.ds.internal.WebConsolePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;

class ComponentConfigurationPrinter
implements InventoryPrinter {
    private final ServiceComponentRuntime scrService;
    private final WebConsolePlugin plugin;
    private static final String SEP = "----------------------------------------------------------------------";

    ComponentConfigurationPrinter(ServiceComponentRuntime scrService, WebConsolePlugin plugin) {
        this.scrService = scrService;
        this.plugin = plugin;
    }

    public void print(PrintWriter pw, Format format, boolean isZip) {
        ArrayList<ComponentDescriptionDTO> noConfig = new ArrayList<ComponentDescriptionDTO>();
        ArrayList<ComponentDescriptionDTO> disabled = new ArrayList<ComponentDescriptionDTO>();
        ArrayList<ComponentConfigurationDTO> configurations = new ArrayList<ComponentConfigurationDTO>();
        Collection descs = this.scrService.getComponentDescriptionDTOs(new Bundle[0]);
        for (ComponentDescriptionDTO d : descs) {
            if (!this.scrService.isComponentEnabled(d)) {
                disabled.add(d);
                continue;
            }
            Collection configs = this.scrService.getComponentConfigurationDTOs(d);
            if (configs.isEmpty()) {
                noConfig.add(d);
                continue;
            }
            configurations.addAll(configs);
        }
        Collections.sort(configurations, Util.COMPONENT_COMPARATOR);
        if (Format.JSON.equals(format)) {
            disabled.addAll(noConfig);
            try {
                this.printComponentsJson(pw, disabled, configurations, isZip);
            }
            catch (IOException iOException) {}
        } else {
            ComponentConfigurationPrinter.printComponentsText(pw, disabled, noConfig, configurations);
        }
    }

    private final void printComponentsJson(PrintWriter pw, List<ComponentDescriptionDTO> disabled, List<ComponentConfigurationDTO> configurations, boolean details) throws IOException {
        JSONWriter jw = new JSONWriter(pw);
        jw.object();
        jw.key("components");
        jw.array();
        for (ComponentDescriptionDTO cd : disabled) {
            this.plugin.component(jw, cd, null, details);
        }
        for (ComponentConfigurationDTO cfg : configurations) {
            this.plugin.component(jw, cfg.description, cfg, details);
        }
        jw.endArray();
        jw.endObject();
    }

    private static final void printComponentsText(PrintWriter pw, List<ComponentDescriptionDTO> disabled, List<ComponentDescriptionDTO> noConfig, List<ComponentConfigurationDTO> configurations) {
        if (!disabled.isEmpty()) {
            pw.println(SEP);
            pw.println("Disabled components:");
            pw.println(SEP);
            for (ComponentDescriptionDTO cd : disabled) {
                ComponentConfigurationPrinter.disabledComponent(pw, cd);
            }
            pw.println();
        }
        if (!noConfig.isEmpty()) {
            pw.println(SEP);
            pw.println("Components with missing configuration in Config Admin:");
            pw.println(SEP);
            for (ComponentDescriptionDTO cd : noConfig) {
                ComponentConfigurationPrinter.disabledComponent(pw, cd);
            }
            pw.println();
        }
        pw.println(SEP);
        if (configurations.isEmpty()) {
            pw.println("Status: No Component Configurations");
            pw.println(SEP);
        } else {
            pw.println("Component Configurations:");
            pw.println(SEP);
            TreeMap<Long, ComponentConfigurationDTO> componentMap = new TreeMap<Long, ComponentConfigurationDTO>();
            for (ComponentConfigurationDTO cfg : configurations) {
                componentMap.put(cfg.id, cfg);
            }
            for (ComponentConfigurationDTO cfg : componentMap.values()) {
                ComponentConfigurationPrinter.component(pw, cfg);
            }
        }
    }

    private static final void component(PrintWriter pw, ComponentConfigurationDTO cfg) {
        pw.print(cfg.id);
        pw.print("=[");
        pw.print(cfg.description.name);
        pw.println("]");
        pw.println("  Bundle=" + cfg.description.bundle.symbolicName + " (" + cfg.description.bundle.id + ")");
        pw.println("  State=" + ComponentConfigurationPrinter.toStateString(cfg.state));
        if (cfg.state == 16) {
            pw.println("  Failure=" + cfg.failure);
        }
        pw.println("  DefaultState=" + (cfg.description.defaultEnabled ? "enabled" : "disabled"));
        pw.println("  Activation=" + (cfg.description.immediate ? "immediate" : "delayed"));
        pw.println("  ConfigurationPolicy=" + cfg.description.configurationPolicy);
        ComponentConfigurationPrinter.listServices(pw, cfg.description);
        if (cfg.service != null) {
            pw.println("  ServiceId=" + String.valueOf(cfg.service.id));
        }
        ComponentConfigurationPrinter.listReferences(pw, cfg.description, cfg);
        ComponentConfigurationPrinter.listProperties(pw, cfg.description, cfg);
        pw.println();
    }

    private static final void disabledComponent(PrintWriter pw, ComponentDescriptionDTO description) {
        pw.println(description.name);
        pw.println("  Bundle=" + description.bundle.symbolicName + " (" + description.bundle.id + ")");
        pw.println("  DefaultState=" + (description.defaultEnabled ? "enabled" : "disabled"));
        pw.println("  Activation=" + (description.immediate ? "immediate" : "delayed"));
        pw.println("  ConfigurationPolicy=" + description.configurationPolicy);
        ComponentConfigurationPrinter.listServices(pw, description);
        ComponentConfigurationPrinter.listReferences(pw, description, null);
        ComponentConfigurationPrinter.listProperties(pw, description, null);
        pw.println();
    }

    private static void listServices(PrintWriter pw, ComponentDescriptionDTO cfg) {
        String[] services = cfg.serviceInterfaces;
        if (services == null) {
            return;
        }
        if (cfg.scope != null) {
            pw.println("  ServiceType=" + cfg.scope);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < services.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(services[i]);
        }
        pw.println("  Services=" + buf);
    }

    private static SatisfiedReferenceDTO findReference(ComponentConfigurationDTO component, String name) {
        for (SatisfiedReferenceDTO dto : component.satisfiedReferences) {
            if (!dto.name.equals(name)) continue;
            return dto;
        }
        return null;
    }

    private static final void listReferences(PrintWriter pw, ComponentDescriptionDTO description, ComponentConfigurationDTO configuration) {
        for (ReferenceDTO dto : description.references) {
            SatisfiedReferenceDTO satisfiedRef = configuration == null ? null : ComponentConfigurationPrinter.findReference(configuration, dto.name);
            pw.print("  Reference=");
            pw.print(dto.name);
            if (configuration != null) {
                pw.print(", ");
                pw.print(satisfiedRef != null ? "Satisfied" : "Unsatisfied");
            }
            pw.println();
            pw.println("    Service Name: " + dto.interfaceName);
            if (dto.target != null) {
                pw.println("  Target Filter: " + dto.target);
            }
            pw.println("    Cardinality: " + dto.cardinality);
            pw.println("    Policy: " + dto.policy);
            pw.println("    Policy Option: " + dto.policyOption);
            if (satisfiedRef != null) {
                for (ServiceReferenceDTO sref : satisfiedRef.boundServices) {
                    pw.print("    Bound Service: ID ");
                    pw.print(sref.properties.get("service.id"));
                    String name = (String)sref.properties.get("component.name");
                    if (name == null && (name = (String)sref.properties.get("service.pid")) == null) {
                        name = (String)sref.properties.get("service.description");
                    }
                    if (name != null) {
                        pw.print(" (");
                        pw.print(name);
                        pw.print(")");
                    }
                    pw.println();
                }
                continue;
            }
            pw.println("    No Services bound");
        }
    }

    private static final void listProperties(PrintWriter pw, ComponentDescriptionDTO description, ComponentConfigurationDTO cfg) {
        Object value;
        TreeSet keys;
        Map props;
        Map map = props = cfg == null ? description.properties : cfg.properties;
        if (props != null) {
            pw.println("  Properties=");
            keys = new TreeSet(props.keySet());
            for (String key : keys) {
                value = props.get(key);
                value = value != null && value.getClass().isArray() ? Arrays.toString((Object[])value) : Objects.toString(value, "n/a");
                pw.println("    " + key + "=" + value);
            }
        }
        if (cfg == null && description.factoryProperties != null) {
            pw.println("  FactoryProperties=");
            keys = new TreeSet(description.factoryProperties.keySet());
            for (String key : keys) {
                value = props.get(key);
                value = value != null && value.getClass().isArray() ? Arrays.toString((Object[])value) : Objects.toString(value, "n/a");
                pw.println("    " + key + "=" + value);
            }
        }
    }

    static final String toStateString(int state) {
        switch (state) {
            case 8: {
                return "active";
            }
            case 4: {
                return "satisfied";
            }
            case 1: {
                return "unsatisfied (configuration)";
            }
            case 2: {
                return "unsatisfied (reference)";
            }
            case 16: {
                return "failed activation";
            }
        }
        return String.valueOf(state);
    }
}

