/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mem;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.ignite.internal.mem.NumaAllocUtil;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.mem.NumaAllocationStrategy;

public class InterleavedNumaAllocationStrategy
implements NumaAllocationStrategy,
Serializable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private final int[] nodes;

    public InterleavedNumaAllocationStrategy() {
        this(null);
    }

    public InterleavedNumaAllocationStrategy(int[] nodes) {
        if (nodes != null && nodes.length > 0) {
            this.nodes = Arrays.copyOf(nodes, nodes.length);
            Arrays.sort(this.nodes);
            A.ensure((this.nodes[0] >= 0 ? 1 : 0) != 0, (String)("NUMA node number must be positive, passed instead " + Arrays.toString(this.nodes)));
            A.ensure((this.nodes[this.nodes.length - 1] < NumaAllocUtil.NUMA_NODES_CNT ? 1 : 0) != 0, (String)("NUMA node number must be less than NUMA_NODES_CNT=" + NumaAllocUtil.NUMA_NODES_CNT + ", passed instead " + Arrays.toString(this.nodes)));
        } else {
            this.nodes = null;
        }
    }

    @Override
    public long allocateMemory(long size) {
        return NumaAllocUtil.allocateInterleaved(size, this.nodes);
    }

    public String toString() {
        return GridToStringBuilder.toString(InterleavedNumaAllocationStrategy.class, (Object)this);
    }
}

