/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.style.component;

import org.apache.ignite3.internal.cli.core.style.AnsiStringSupport;
import org.apache.ignite3.internal.cli.core.style.component.UiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import org.apache.ignite3.internal.cli.core.style.element.UiString;

public class MessageUiComponent
implements UiComponent {
    private final String message;
    private final UiElement[] messageUiElements;
    private final String hint;
    private final UiElement[] hintUiElements;

    private MessageUiComponent(String message, UiElement[] messageUiElements, String hint, UiElement[] hintUiElements) {
        this.message = message;
        this.messageUiElements = messageUiElements;
        this.hint = hint;
        this.hintUiElements = hintUiElements;
    }

    @Override
    public String render() {
        String messageString = UiString.format(this.message, this.messageUiElements);
        String hintString = UiString.format(this.hint, this.hintUiElements);
        return AnsiStringSupport.ansi(messageString + (String)(hintString == null ? "" : System.lineSeparator() + hintString));
    }

    public static MessageUiComponent fromMessage(String message, UiElement ... messageUiElements) {
        return MessageUiComponent.builder().message(message, messageUiElements).build();
    }

    public static MessageUiComponent from(UiElement messageUiElement) {
        return MessageUiComponent.builder().message("%s", messageUiElement).build();
    }

    public static MessageComponentBuilder builder() {
        return new MessageComponentBuilder();
    }

    public static class MessageComponentBuilder {
        private String message;
        private String hint;
        private UiElement[] messageUiElements;
        private UiElement[] hintUiElements;

        public MessageComponentBuilder message(String message, UiElement ... uiElements) {
            this.message = message;
            this.messageUiElements = uiElements;
            return this;
        }

        public MessageComponentBuilder hint(String hint, UiElement ... uiElements) {
            this.hint = hint;
            this.hintUiElements = uiElements;
            return this;
        }

        public MessageUiComponent build() {
            return new MessageUiComponent(this.message, this.messageUiElements, this.hint, this.hintUiElements);
        }
    }
}

