/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

@GridInternal
class IgniteKillTask
extends ComputeTaskAdapter<Boolean, Void> {
    private static final long serialVersionUID = 0L;
    private boolean restart;

    IgniteKillTask() {
    }

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, Boolean restart) {
        assert (restart != null);
        this.restart = restart;
        HashMap<IgniteKillJob, ClusterNode> jobs = U.newHashMap(subgrid.size());
        for (ClusterNode n : subgrid) {
            if (this.daemon(n)) continue;
            jobs.put(new IgniteKillJob(), n);
        }
        return jobs;
    }

    private boolean daemon(ClusterNode n) {
        return "true".equalsIgnoreCase((String)n.attribute("org.apache.ignite.daemon"));
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        return ComputeJobResultPolicy.WAIT;
    }

    @Override
    public Void reduce(List<ComputeJobResult> results) {
        return null;
    }

    private class IgniteKillJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;

        private IgniteKillJob() {
        }

        @Override
        public Object execute() {
            if (IgniteKillTask.this.restart) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        G.restart(true);
                    }
                }, "ignite-restarter").start();
            } else {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        G.kill(true);
                    }
                }, "ignite-stopper").start();
            }
            return null;
        }
    }
}

