/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import org.apache.ignite.internal.metric.IndexPageType;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsQueryHelper;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IoStatisticsHolderIndex
implements IoStatisticsHolder {
    public static final String HASH_PK_IDX_NAME = "HASH_PK";
    public static final String LOGICAL_READS_LEAF = "LOGICAL_READS_LEAF";
    public static final String LOGICAL_READS_INNER = "LOGICAL_READS_INNER";
    public static final String PHYSICAL_READS_LEAF = "PHYSICAL_READS_LEAF";
    public static final String PHYSICAL_READS_INNER = "PHYSICAL_READS_INNER";
    private final LongAdderMetric logicalReadLeafCtr;
    private final LongAdderMetric logicalReadInnerCtr;
    private final LongAdderMetric physicalReadLeafCtr;
    private final LongAdderMetric physicalReadInnerCtr;
    private final String grpName;
    private final String idxName;
    private IoStatisticsType type;

    public IoStatisticsHolderIndex(IoStatisticsType type, String grpName, String idxName, GridMetricManager mmgr) {
        assert (grpName != null && idxName != null);
        this.type = type;
        this.grpName = grpName;
        this.idxName = idxName;
        MetricRegistry mreg = mmgr.registry(this.metricRegistryName());
        mreg.longMetric("startTime", null).value(U.currentTimeMillis());
        mreg.objectMetric("name", String.class, null).value(grpName);
        mreg.objectMetric("indexName", String.class, null).value(idxName);
        this.logicalReadLeafCtr = mreg.longAdderMetric(LOGICAL_READS_LEAF, null);
        this.logicalReadInnerCtr = mreg.longAdderMetric(LOGICAL_READS_INNER, null);
        this.physicalReadLeafCtr = mreg.longAdderMetric(PHYSICAL_READS_LEAF, null);
        this.physicalReadInnerCtr = mreg.longAdderMetric(PHYSICAL_READS_INNER, null);
    }

    @Override
    public void trackLogicalRead(long pageAddr) {
        IndexPageType idxPageType = PageIO.deriveIndexPageType(pageAddr);
        switch (idxPageType) {
            case INNER: {
                this.logicalReadInnerCtr.increment();
                IoStatisticsQueryHelper.trackLogicalReadQuery(pageAddr);
                break;
            }
            case LEAF: {
                this.logicalReadLeafCtr.increment();
                IoStatisticsQueryHelper.trackLogicalReadQuery(pageAddr);
            }
        }
    }

    @Override
    public void trackPhysicalAndLogicalRead(long pageAddr) {
        IndexPageType idxPageType = PageIO.deriveIndexPageType(pageAddr);
        switch (idxPageType) {
            case INNER: {
                this.logicalReadInnerCtr.increment();
                this.physicalReadInnerCtr.increment();
                IoStatisticsQueryHelper.trackPhysicalAndLogicalReadQuery(pageAddr);
                break;
            }
            case LEAF: {
                this.logicalReadLeafCtr.increment();
                this.physicalReadLeafCtr.increment();
                IoStatisticsQueryHelper.trackPhysicalAndLogicalReadQuery(pageAddr);
            }
        }
    }

    @Override
    public long logicalReads() {
        return this.logicalReadLeafCtr.value() + this.logicalReadInnerCtr.value();
    }

    @Override
    public long physicalReads() {
        return this.physicalReadLeafCtr.value() + this.physicalReadInnerCtr.value();
    }

    @Override
    public String metricRegistryName() {
        return MetricUtils.metricName(this.type.metricGroupName(), this.grpName, this.idxName);
    }

    public String toString() {
        return S.toString(IoStatisticsHolderIndex.class, this, "logicalReadLeafCtr", (Object)this.logicalReadLeafCtr, "logicalReadInnerCtr", (Object)this.logicalReadInnerCtr, "physicalReadLeafCtr", (Object)this.physicalReadLeafCtr, "physicalReadInnerCtr", (Object)this.physicalReadInnerCtr, "grpName", (Object)this.grpName, "idxName", (Object)this.idxName);
    }
}

