/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.PageStoreWriter;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointPagesWriter;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointMetricsTracker;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.util.GridConcurrentMultiPairQueue;
import org.apache.ignite.internal.util.future.CountDownFuture;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jsr166.ConcurrentLinkedHashMap;

public class CheckpointPagesWriterFactory {
    private final IgniteLogger log;
    private final IgniteCacheSnapshotManager snapshotMgr;
    private final DataStorageMetricsImpl persStoreMetrics;
    private volatile ThreadLocal<ByteBuffer> threadBuf;
    private final PageMemoryImpl.ThrottlingPolicy throttlingPolicy;
    private final IgniteThrowableFunction<Integer, PageMemoryEx> pageMemoryGroupResolver;
    private final CheckpointPagesWriter.CheckpointPageWriter checkpointPageWriter;

    CheckpointPagesWriterFactory(Function<Class<?>, IgniteLogger> logger, IgniteCacheSnapshotManager snapshotMgr, CheckpointPagesWriter.CheckpointPageWriter checkpointPageWriter, DataStorageMetricsImpl persStoreMetrics, PageMemoryImpl.ThrottlingPolicy throttlingPolicy, ThreadLocal<ByteBuffer> threadBuf, IgniteThrowableFunction<Integer, PageMemoryEx> pageMemoryGroupResolver) {
        this.snapshotMgr = snapshotMgr;
        this.log = logger.apply(this.getClass());
        this.persStoreMetrics = persStoreMetrics;
        this.threadBuf = threadBuf;
        this.throttlingPolicy = throttlingPolicy;
        this.pageMemoryGroupResolver = pageMemoryGroupResolver;
        this.checkpointPageWriter = checkpointPageWriter;
    }

    CheckpointPagesWriter build(CheckpointMetricsTracker tracker, GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> cpPages, ConcurrentLinkedHashMap<PageStore, LongAdder> updStores, CountDownFuture doneWriteFut, Runnable beforePageWrite, CheckpointProgressImpl curCpProgress, BooleanSupplier shutdownNow) {
        return new CheckpointPagesWriter(tracker, cpPages, updStores, doneWriteFut, beforePageWrite, this.snapshotMgr, this.log, this.persStoreMetrics, this.threadBuf, this.throttlingPolicy, this.pageMemoryGroupResolver, curCpProgress, this.checkpointPageWriter, shutdownNow);
    }

    Runnable buildRecovery(GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> pages, Collection<PageStore> updStores, AtomicReference<Throwable> writePagesError, AtomicInteger cpPagesCnt) {
        return () -> {
            int pagesWritten;
            block3: {
                GridConcurrentMultiPairQueue.Result res = new GridConcurrentMultiPairQueue.Result();
                pagesWritten = 0;
                ByteBuffer tmpWriteBuf = this.threadBuf.get();
                HashMap<PageMemoryEx, PageStoreWriter> pageStoreWriters = new HashMap<PageMemoryEx, PageStoreWriter>();
                try {
                    while (pages.next(res) && writePagesError.get() == null) {
                        PageMemoryEx pageMem = (PageMemoryEx)res.getKey();
                        PageStoreWriter pageStoreWriter = pageStoreWriters.computeIfAbsent(pageMem, pageMemEx -> (fullPageId, buf, tag) -> {
                            assert (tag != -1) : "Lock is held by other thread for page " + fullPageId;
                            PageStore store = this.checkpointPageWriter.write((PageMemoryEx)pageMemEx, fullPageId, buf, tag);
                            updStores.add(store);
                        });
                        pageMem.checkpointWritePage((FullPageId)res.getValue(), tmpWriteBuf, pageStoreWriter, null);
                        ++pagesWritten;
                    }
                }
                catch (Throwable e) {
                    U.error(this.log, "Failed to write page to pageStore: " + res);
                    writePagesError.compareAndSet(null, e);
                    if (!(e instanceof Error)) break block3;
                    throw (Error)e;
                }
            }
            cpPagesCnt.addAndGet(pagesWritten);
        };
    }

    public void threadBuf(ThreadLocal<ByteBuffer> threadBuf) {
        this.threadBuf = threadBuf;
    }
}

