/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;

public class PartitionDestroyRequest {
    private final int grpId;
    private final int partId;
    private boolean cancelled;
    private GridFutureAdapter<Void> destroyFut;

    PartitionDestroyRequest(int grpId, int partId) {
        this.grpId = grpId;
        this.partId = partId;
    }

    public synchronized boolean cancel() {
        if (this.destroyFut != null) {
            assert (!this.cancelled);
            return false;
        }
        this.cancelled = true;
        return true;
    }

    public synchronized boolean beginDestroy() {
        if (this.cancelled) {
            assert (this.destroyFut == null);
            return false;
        }
        if (this.destroyFut != null) {
            return false;
        }
        this.destroyFut = new GridFutureAdapter();
        return true;
    }

    public synchronized void onDone(Throwable err) {
        assert (this.destroyFut != null);
        this.destroyFut.onDone(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitCompleted() throws IgniteCheckedException {
        GridFutureAdapter<Void> fut;
        PartitionDestroyRequest partitionDestroyRequest = this;
        synchronized (partitionDestroyRequest) {
            assert (this.destroyFut != null);
            fut = this.destroyFut;
        }
        fut.get();
    }

    public int groupId() {
        return this.grpId;
    }

    public int partitionId() {
        return this.partId;
    }

    public String toString() {
        return "PartitionDestroyRequest [grpId=" + this.grpId + ", partId=" + this.partId + ']';
    }
}

