/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.dumpprocessors;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockDump;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.dumpprocessors.ToStringDumpProcessor;

public class ToFileDumpProcessor {
    public static final SimpleDateFormat DATE_FMT = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS");
    public static final String PREFIX_NAME = "page_lock_dump_";

    public static String toFileDump(PageLockDump pageLockDump, File dir, String name) throws IgniteCheckedException {
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, PREFIX_NAME + name + "_" + DATE_FMT.format(new Date(pageLockDump.time())));
            return ToFileDumpProcessor.saveToFile(ToStringDumpProcessor.toStringDump(pageLockDump), file);
        }
        catch (IOException e) {
            throw new IgniteCheckedException(e);
        }
    }

    private static String saveToFile(String dump, File file) throws IOException {
        assert (dump != null);
        assert (file != null);
        assert (!dump.isEmpty());
        try (FileChannel ch = FileChannel.open(file.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            ByteBuffer buf = ByteBuffer.wrap(dump.getBytes());
            assert (buf.position() == 0);
            assert (buf.limit() > 0);
            while (buf.position() != buf.limit()) {
                ch.write(buf);
            }
            ch.force(true);
        }
        return file.getAbsolutePath();
    }
}

