/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;

public abstract class GridCloseableIteratorAdapterEx<T>
extends GridIteratorAdapter<T>
implements GridCloseableIterator<T> {
    private static final long serialVersionUID = 0L;
    private final AtomicBoolean closed = new AtomicBoolean();

    @Override
    public final T nextX() throws IgniteCheckedException {
        if (this.closed.get()) {
            return null;
        }
        try {
            if (!this.onHasNext()) {
                throw new NoSuchElementException();
            }
            return this.onNext();
        }
        catch (IgniteCheckedException e) {
            if (this.closed.get()) {
                return null;
            }
            throw e;
        }
    }

    protected abstract T onNext() throws IgniteCheckedException;

    @Override
    public final boolean hasNextX() throws IgniteCheckedException {
        if (this.closed.get()) {
            return false;
        }
        try {
            return this.onHasNext();
        }
        catch (IgniteCheckedException e) {
            if (this.closed.get()) {
                return false;
            }
            throw e;
        }
    }

    protected abstract boolean onHasNext() throws IgniteCheckedException;

    @Override
    public final void removeX() throws IgniteCheckedException {
        block3: {
            if (this.closed.get()) {
                throw new NoSuchElementException("Iterator has been closed.");
            }
            try {
                this.onRemove();
            }
            catch (IgniteCheckedException e) {
                if (this.closed.get()) break block3;
                throw e;
            }
        }
    }

    protected void onRemove() throws IgniteCheckedException {
        throw new UnsupportedOperationException("Remove is not supported.");
    }

    @Override
    public final void close() throws IgniteCheckedException {
        if (this.closed.compareAndSet(false, true)) {
            this.onClose();
        }
    }

    protected void onClose() throws IgniteCheckedException {
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }
}

