/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.loadbalancing.roundrobin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.JobEvent;
import org.apache.ignite.events.TaskEvent;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.loadbalancing.LoadBalancingSpi;
import org.apache.ignite.spi.loadbalancing.roundrobin.RoundRobinGlobalLoadBalancer;
import org.apache.ignite.spi.loadbalancing.roundrobin.RoundRobinLoadBalancingSpiMBean;
import org.apache.ignite.spi.loadbalancing.roundrobin.RoundRobinPerTaskLoadBalancer;
import org.jetbrains.annotations.Nullable;

@IgniteSpiMultipleInstancesSupport(value=true)
public class RoundRobinLoadBalancingSpi
extends IgniteSpiAdapter
implements LoadBalancingSpi {
    @LoggerResource
    private IgniteLogger log;
    private RoundRobinGlobalLoadBalancer balancer;
    private boolean isPerTask;
    private final Map<IgniteUuid, RoundRobinPerTaskLoadBalancer> perTaskBalancers = new ConcurrentHashMap<IgniteUuid, RoundRobinPerTaskLoadBalancer>();
    private final GridLocalEventListener lsnr = new GridLocalEventListener(){

        @Override
        public void onEvent(Event evt) {
            RoundRobinPerTaskLoadBalancer balancer;
            if (evt.type() == 22 || evt.type() == 21) {
                RoundRobinLoadBalancingSpi.this.perTaskBalancers.remove(((TaskEvent)evt).taskSessionId());
            } else if (evt.type() == 40 && (balancer = (RoundRobinPerTaskLoadBalancer)RoundRobinLoadBalancingSpi.this.perTaskBalancers.get(((JobEvent)evt).taskSessionId())) != null) {
                balancer.onMapped();
            }
        }
    };

    public boolean isPerTask() {
        return this.isPerTask;
    }

    @IgniteSpiConfiguration(optional=true)
    public RoundRobinLoadBalancingSpi setPerTask(boolean isPerTask) {
        this.isPerTask = isPerTask;
        return this;
    }

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.startStopwatch();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("isPerTask", this.isPerTask));
        }
        this.registerMBean(igniteInstanceName, new RoundRobinLoadBalancingSpiMBeanImpl(this), RoundRobinLoadBalancingSpiMBean.class);
        this.balancer = new RoundRobinGlobalLoadBalancer(this.log);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.balancer = null;
        this.perTaskBalancers.clear();
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Override
    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        if (!this.isPerTask) {
            this.balancer.onContextInitialized(spiCtx);
        } else {
            if (!this.getSpiContext().isEventRecordable(22, 21, 40)) {
                throw new IgniteSpiException("Required event types are disabled: " + U.gridEventName(22) + ", " + U.gridEventName(21) + ", " + U.gridEventName(40));
            }
            this.getSpiContext().addLocalEventListener(this.lsnr, 22, 21, 40);
        }
    }

    @Override
    protected void onContextDestroyed0() {
        if (!this.isPerTask) {
            if (this.balancer != null) {
                this.balancer.onContextDestroyed();
            }
        } else {
            IgniteSpiContext spiCtx = this.getSpiContext();
            if (spiCtx != null) {
                spiCtx.removeLocalEventListener(this.lsnr);
            }
        }
    }

    @Override
    public ClusterNode getBalancedNode(ComputeTaskSession ses, List<ClusterNode> top, ComputeJob job) {
        A.notNull(ses, "ses", top, "top");
        if (this.isPerTask) {
            RoundRobinPerTaskLoadBalancer taskBalancer = this.perTaskBalancers.get(ses.getId());
            if (taskBalancer == null) {
                taskBalancer = new RoundRobinPerTaskLoadBalancer();
                this.perTaskBalancers.put(ses.getId(), taskBalancer);
            }
            return taskBalancer.getBalancedNode(top);
        }
        return this.balancer.getBalancedNode(top);
    }

    List<UUID> getNodeIds(ComputeTaskSession ses) {
        if (this.isPerTask) {
            RoundRobinPerTaskLoadBalancer balancer = this.perTaskBalancers.get(ses.getId());
            if (balancer == null) {
                return Collections.emptyList();
            }
            ArrayList<UUID> ids = new ArrayList<UUID>();
            for (ClusterNode node : balancer.getNodes()) {
                ids.add(node.id());
            }
            return ids;
        }
        return this.balancer.getNodeIds();
    }

    @Override
    public RoundRobinLoadBalancingSpi setName(String name) {
        super.setName(name);
        return this;
    }

    public String toString() {
        return S.toString(RoundRobinLoadBalancingSpi.class, this);
    }

    private class RoundRobinLoadBalancingSpiMBeanImpl
    extends IgniteSpiMBeanAdapter
    implements RoundRobinLoadBalancingSpiMBean {
        RoundRobinLoadBalancingSpiMBeanImpl(IgniteSpiAdapter spiAdapter) {
            super(spiAdapter);
        }

        @Override
        public boolean isPerTask() {
            return RoundRobinLoadBalancingSpi.this.isPerTask();
        }
    }
}

