/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.topic;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TopicMetaKeeper {
    private final Map<String, TopicMeta> topicNameToTopicMetaMap = new ConcurrentHashMap<String, TopicMeta>();
    private final ReentrantReadWriteLock topicMetaKeeperLock = new ReentrantReadWriteLock(true);

    public void acquireReadLock() {
        this.topicMetaKeeperLock.readLock().lock();
    }

    public void releaseReadLock() {
        this.topicMetaKeeperLock.readLock().unlock();
    }

    public void acquireWriteLock() {
        this.topicMetaKeeperLock.writeLock().lock();
    }

    public void releaseWriteLock() {
        this.topicMetaKeeperLock.writeLock().unlock();
    }

    public void addTopicMeta(String topicName, TopicMeta topicMeta) {
        this.topicNameToTopicMetaMap.put(topicName, topicMeta);
    }

    public TopicMeta getTopicMeta(String topicName) {
        return this.topicNameToTopicMetaMap.get(topicName);
    }

    public Iterable<TopicMeta> getAllTopicMeta() {
        return this.topicNameToTopicMetaMap.values();
    }

    public void removeTopicMeta(String topicName) {
        this.topicNameToTopicMetaMap.remove(topicName);
    }

    public boolean containsTopicMeta(String topicName) {
        return this.topicNameToTopicMetaMap.containsKey(topicName);
    }

    public void clear() {
        this.topicNameToTopicMetaMap.clear();
    }

    public boolean isEmpty() {
        return this.topicNameToTopicMetaMap.isEmpty();
    }

    public void processTakeSnapshot(FileOutputStream fileOutputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.topicNameToTopicMetaMap.size(), (OutputStream)fileOutputStream);
        for (Map.Entry<String, TopicMeta> entry : this.topicNameToTopicMetaMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)fileOutputStream);
            entry.getValue().serialize(fileOutputStream);
        }
    }

    public void processLoadSnapshot(FileInputStream fileInputStream) throws IOException {
        this.clear();
        int size = ReadWriteIOUtils.readInt((InputStream)fileInputStream);
        for (int i = 0; i < size; ++i) {
            String topicName = ReadWriteIOUtils.readString((InputStream)fileInputStream);
            this.topicNameToTopicMetaMap.put(topicName, TopicMeta.deserialize(fileInputStream));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicMetaKeeper that = (TopicMetaKeeper)o;
        return Objects.equals(this.topicNameToTopicMetaMap, that.topicNameToTopicMetaMap);
    }

    public int hashCode() {
        return Objects.hash(this.topicNameToTopicMetaMap);
    }

    public String toString() {
        return "TopicMetaKeeper{topicNameToTopicMetaMap=" + this.topicNameToTopicMetaMap + '}';
    }
}

