/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.buffer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.queryengine.metric.TimeSeriesMetadataCacheMetrics;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.BloomFilter;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesMetadataCache {
    private static final Logger logger = LoggerFactory.getLogger(TimeSeriesMetadataCache.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE = config.getAllocateMemoryForTimeSeriesMetaDataCache();
    private static final boolean CACHE_ENABLE = config.isMetaDataCacheEnable();
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();
    private final Cache<TimeSeriesMetadataCacheKey, TimeseriesMetadata> lruCache;
    private final AtomicLong entryAverageSize = new AtomicLong(0L);
    private final Map<String, WeakReference<String>> devices = Collections.synchronizedMap(new WeakHashMap());
    private static final String SEPARATOR = "$";

    private TimeSeriesMetadataCache() {
        if (CACHE_ENABLE) {
            logger.info("TimeSeriesMetadataCache size = {}", (Object)MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE);
        }
        this.lruCache = Caffeine.newBuilder().maximumWeight(MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE).weigher((key, value) -> (int)(key.getRetainedSizeInBytes() + value.getRetainedSizeInBytes())).recordStats().build();
        MetricService.getInstance().addMetricSet((IMetricSet)new TimeSeriesMetadataCacheMetrics(this));
    }

    public static TimeSeriesMetadataCache getInstance() {
        return TimeSeriesMetadataCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeseriesMetadata get(String filePath, TimeSeriesMetadataCacheKey key, Set<String> allSensors, boolean ignoreNotExists, boolean debug, QueryContext queryContext) throws IOException {
        long startTime = System.nanoTime();
        long loadBloomFilterTime = 0L;
        LongConsumer timeSeriesMetadataIoSizeRecorder = queryContext.getQueryStatistics().getLoadTimeSeriesMetadataActualIOSize()::addAndGet;
        LongConsumer bloomFilterIoSizeRecorder = queryContext.getQueryStatistics().getLoadBloomFilterActualIOSize()::addAndGet;
        boolean cacheHit = true;
        try {
            Object object;
            TimeseriesMetadata timeseriesMetadata;
            block23: {
                if (!CACHE_ENABLE) {
                    cacheHit = false;
                    TsFileSequenceReader reader = FileReaderManager.getInstance().get(filePath, key.tsFileID, true, bloomFilterIoSizeRecorder);
                    BloomFilter bloomFilter = reader.readBloomFilter(bloomFilterIoSizeRecorder);
                    queryContext.getQueryStatistics().getLoadBloomFilterFromDiskCount().incrementAndGet();
                    if (bloomFilter != null && !bloomFilter.contains(((PlainDeviceID)key.device).toStringID() + '.' + key.measurement)) {
                        loadBloomFilterTime = System.nanoTime() - startTime;
                        TimeseriesMetadata timeseriesMetadata2 = null;
                        return timeseriesMetadata2;
                    }
                    loadBloomFilterTime = System.nanoTime() - startTime;
                    TimeseriesMetadata timeseriesMetadata3 = reader.readTimeseriesMetadata(key.device, key.measurement, ignoreNotExists, timeSeriesMetadataIoSizeRecorder);
                    TimeseriesMetadata timeseriesMetadata4 = timeseriesMetadata3 == null || timeseriesMetadata3.getStatistics().getCount() == 0L ? null : timeseriesMetadata3;
                    return timeseriesMetadata4;
                }
                timeseriesMetadata = (TimeseriesMetadata)this.lruCache.getIfPresent((Object)key);
                if (timeseriesMetadata != null) break block23;
                if (debug) {
                    DEBUG_LOGGER.info("Cache miss: {}.{} in file: {}", new Object[]{key.device, key.measurement, filePath});
                    DEBUG_LOGGER.info("Device: {}, all sensors: {}", (Object)key.device, allSensors);
                }
                object = this.devices.computeIfAbsent(((PlainDeviceID)key.device).toStringID() + SEPARATOR + filePath, WeakReference::new);
                synchronized (object) {
                    long loadBloomFilterStartTime;
                    block22: {
                        timeseriesMetadata = (TimeseriesMetadata)this.lruCache.getIfPresent((Object)key);
                        if (timeseriesMetadata != null) break block23;
                        cacheHit = false;
                        loadBloomFilterStartTime = System.nanoTime();
                        BloomFilter bloomFilter = BloomFilterCache.getInstance().get(new BloomFilterCache.BloomFilterCacheKey(filePath, key.tsFileID), debug, bloomFilterIoSizeRecorder, queryContext.getQueryStatistics().getLoadBloomFilterFromCacheCount()::addAndGet, queryContext.getQueryStatistics().getLoadBloomFilterFromDiskCount()::addAndGet);
                        if (bloomFilter == null || bloomFilter.contains(((PlainDeviceID)key.device).toStringID() + "." + key.measurement)) break block22;
                        if (debug) {
                            DEBUG_LOGGER.info("TimeSeries meta data {} is filter by bloomFilter!", (Object)key);
                        }
                        loadBloomFilterTime = System.nanoTime() - loadBloomFilterStartTime;
                        TimeseriesMetadata timeseriesMetadata5 = null;
                        return timeseriesMetadata5;
                    }
                    loadBloomFilterTime = System.nanoTime() - loadBloomFilterStartTime;
                    TsFileSequenceReader reader = FileReaderManager.getInstance().get(filePath, key.tsFileID, true, timeSeriesMetadataIoSizeRecorder);
                    List timeSeriesMetadataList = reader.readTimeseriesMetadata(key.device, key.measurement, allSensors, ignoreNotExists, timeSeriesMetadataIoSizeRecorder);
                    for (TimeseriesMetadata metadata : timeSeriesMetadataList) {
                        TimeSeriesMetadataCacheKey k = new TimeSeriesMetadataCacheKey(key.tsFileID, key.device, metadata.getMeasurementId());
                        if (metadata.getStatistics().getCount() != 0L) {
                            this.lruCache.put((Object)k, (Object)metadata);
                        }
                        if (!metadata.getMeasurementId().equals(key.measurement)) continue;
                        timeseriesMetadata = metadata.getStatistics().getCount() == 0L ? null : metadata;
                    }
                }
            }
            if (timeseriesMetadata == null) {
                if (debug) {
                    DEBUG_LOGGER.info("The file doesn't have this time series {}.", (Object)key);
                }
                object = null;
                return object;
            }
            if (debug) {
                DEBUG_LOGGER.info("Get timeseries: {}.{}  metadata in file: {}  from cache: {}.", new Object[]{key.device, key.measurement, filePath, timeseriesMetadata});
            }
            object = new TimeseriesMetadata(timeseriesMetadata);
            return object;
        }
        finally {
            queryContext.getQueryStatistics().getLoadBloomFilterTime().getAndAdd(loadBloomFilterTime);
            if (cacheHit) {
                queryContext.getQueryStatistics().getLoadTimeSeriesMetadataFromCacheCount().incrementAndGet();
                SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("read_timeseries_metadata_cache", System.nanoTime() - startTime);
            } else {
                queryContext.getQueryStatistics().getLoadTimeSeriesMetadataFromDiskCount().incrementAndGet();
                SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("read_timeseries_metadata_file", System.nanoTime() - startTime);
            }
        }
    }

    public double calculateTimeSeriesMetadataHitRatio() {
        return this.lruCache.stats().hitRate();
    }

    public long getEvictionCount() {
        return this.lruCache.stats().evictionCount();
    }

    public long getMaxMemory() {
        return MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE;
    }

    public double getAverageLoadPenalty() {
        return this.lruCache.stats().averageLoadPenalty();
    }

    public long getAverageSize() {
        return this.entryAverageSize.get();
    }

    public double calculateBloomFilterHitRatio() {
        return BloomFilterCache.getInstance().calculateBloomFilterHitRatio();
    }

    public void clear() {
        this.lruCache.invalidateAll();
        this.lruCache.cleanUp();
    }

    public void remove(TimeSeriesMetadataCacheKey key) {
        this.lruCache.invalidate((Object)key);
    }

    public boolean isEmpty() {
        return this.lruCache.asMap().isEmpty();
    }

    private static class TimeSeriesMetadataCacheHolder {
        private static final TimeSeriesMetadataCache INSTANCE = new TimeSeriesMetadataCache();

        private TimeSeriesMetadataCacheHolder() {
        }
    }

    public static class TimeSeriesMetadataCacheKey {
        private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TimeSeriesMetadataCacheKey.class) + RamUsageEstimator.shallowSizeOfInstance(String.class);
        private final TsFileID tsFileID;
        private final IDeviceID device;
        private final String measurement;

        public TimeSeriesMetadataCacheKey(TsFileID tsFileID, IDeviceID device, String measurement) {
            this.tsFileID = tsFileID;
            this.device = device;
            this.measurement = measurement;
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE + this.device.ramBytesUsed() + RamUsageEstimator.sizeOfCharArray((int)this.measurement.length());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSeriesMetadataCacheKey that = (TimeSeriesMetadataCacheKey)o;
            return Objects.equals(this.tsFileID, that.tsFileID) && Objects.equals(this.device, that.device) && Objects.equals(this.measurement, that.measurement);
        }

        public int hashCode() {
            return Objects.hash(this.tsFileID, this.device, this.measurement);
        }

        public String toString() {
            return "TimeSeriesMetadataCacheKey{regionId=" + this.tsFileID.regionId + ", timePartitionId=" + this.tsFileID.timePartitionId + ", tsFileVersion=" + this.tsFileID.fileVersion + ", compactionVersion=" + this.tsFileID.compactionVersion + ", device='" + ((PlainDeviceID)this.device).toStringID() + '\'' + ", measurement='" + this.measurement + '\'' + '}';
        }
    }
}

