/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.active;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadPathHelper;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadScheduledExecutorService;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadTsFileLoader;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadUtil;
import org.apache.iotdb.db.storageengine.load.metrics.ActiveLoadingFilesNumberMetricsSet;
import org.apache.iotdb.db.storageengine.load.metrics.ActiveLoadingFilesSizeMetricsSet;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveLoadDirScanner
extends ActiveLoadScheduledExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveLoadDirScanner.class);
    private static final String RESOURCE = ".resource";
    private static final String MODS = ".mods";
    private final AtomicReference<String[]> listeningDirsConfig = new AtomicReference();
    private final Set<String> listeningDirs = new CopyOnWriteArraySet<String>();
    private final Set<String> noPermissionDirs = new CopyOnWriteArraySet<String>();
    private final AtomicBoolean isReadOnlyLogPrinted = new AtomicBoolean(false);
    private final ActiveLoadTsFileLoader activeLoadTsFileLoader;

    public ActiveLoadDirScanner(ActiveLoadTsFileLoader activeLoadTsFileLoader) {
        super(ThreadName.ACTIVE_LOAD_DIR_SCANNER);
        this.activeLoadTsFileLoader = activeLoadTsFileLoader;
        this.register(this::scanSafely);
        LOGGER.info("Active load dir scanner periodical job registered");
    }

    private void scanSafely() {
        try {
            this.scan();
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred during active load dir scanning.", (Throwable)e);
        }
    }

    private void scan() throws IOException {
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            if (!this.isReadOnlyLogPrinted.get()) {
                LOGGER.warn("Current system is read-only mode. Skip active load dir scanning.");
                this.isReadOnlyLogPrinted.set(true);
            }
            return;
        }
        this.isReadOnlyLogPrinted.set(false);
        this.hotReloadActiveLoadDirs();
        for (String listeningDir : this.listeningDirs) {
            if (!this.checkPermission(listeningDir)) continue;
            int currentAllowedPendingSize = this.activeLoadTsFileLoader.getCurrentAllowedPendingSize();
            if (currentAllowedPendingSize <= 0) {
                return;
            }
            boolean isGeneratedByPipe = listeningDir.equals(IOTDB_CONFIG.getLoadActiveListeningPipeDir());
            File listeningDirFile = new File(listeningDir);
            Stream fileStream = FileUtils.streamFiles((File)listeningDirFile, (boolean)true, (String[])null);
            try {
                try {
                    fileStream.filter(file -> !this.activeLoadTsFileLoader.isFilePendingOrLoading((File)file)).filter(File::exists).map(file -> file.getName().endsWith(RESOURCE) || file.getName().endsWith(MODS) ? ActiveLoadDirScanner.getTsFilePath(file.getAbsolutePath()) : file.getAbsolutePath()).filter(this::isTsFileCompleted).limit(currentAllowedPendingSize).forEach(filePath -> {
                        File tsFile = new File((String)filePath);
                        Map<String, String> attributes = ActiveLoadPathHelper.parseAttributes(tsFile, listeningDirFile);
                        File parentFile = tsFile.getParentFile();
                        this.activeLoadTsFileLoader.tryTriggerTsFileLoad(tsFile.getAbsolutePath(), listeningDirFile.getAbsolutePath(), isGeneratedByPipe);
                    });
                }
                catch (UncheckedIOException e) {
                    LOGGER.debug("The file has been deleted. Ignore this exception.");
                }
                catch (Exception e) {
                    LOGGER.warn("Exception occurred during scanning dir: {}", (Object)listeningDir, (Object)e);
                }
            }
            finally {
                if (fileStream == null) continue;
                fileStream.close();
            }
        }
    }

    private boolean checkPermission(String listeningDir) {
        try {
            Path listeningDirPath = new File(listeningDir).toPath();
            if (!Files.isReadable(listeningDirPath)) {
                if (!this.noPermissionDirs.contains(listeningDir)) {
                    LOGGER.error("Current dir path is not readable: {}.Skip scanning this dir. Please check the permission.", (Object)listeningDirPath);
                    this.noPermissionDirs.add(listeningDir);
                }
                return false;
            }
            if (!Files.isWritable(listeningDirPath)) {
                if (!this.noPermissionDirs.contains(listeningDir)) {
                    LOGGER.error("Current dir path is not writable: {}.Skip scanning this dir. Please check the permission.", (Object)listeningDirPath);
                    this.noPermissionDirs.add(listeningDir);
                }
                return false;
            }
            this.noPermissionDirs.remove(listeningDir);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred during checking r/w permission of dir: {}. Skip scanning this dir.", (Object)listeningDir, (Object)e);
            return false;
        }
    }

    private boolean isTsFileCompleted(String file) {
        boolean bl;
        TsFileSequenceReader reader = new TsFileSequenceReader(file, false);
        try {
            bl = "TsFile".equals(reader.readTailMagic());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        reader.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hotReloadActiveLoadDirs() {
        try {
            if (IOTDB_CONFIG.getLoadActiveListeningEnable()) {
                if (IOTDB_CONFIG.getLoadActiveListeningDirs() != this.listeningDirsConfig.get()) {
                    ActiveLoadDirScanner activeLoadDirScanner = this;
                    synchronized (activeLoadDirScanner) {
                        if (IOTDB_CONFIG.getLoadActiveListeningDirs() != this.listeningDirsConfig.get()) {
                            this.listeningDirs.clear();
                            this.listeningDirsConfig.set(IOTDB_CONFIG.getLoadActiveListeningDirs());
                            this.listeningDirs.addAll(Arrays.asList(IOTDB_CONFIG.getLoadActiveListeningDirs()));
                            ActiveLoadUtil.updateLoadDiskSelector();
                        }
                    }
                }
            } else {
                this.listeningDirs.clear();
            }
            this.listeningDirs.add(IOTDB_CONFIG.getLoadActiveListeningPipeDir());
            this.listeningDirs.forEach(this::createDirectoriesIfNotExists);
            ActiveLoadingFilesNumberMetricsSet.getInstance().updatePendingDirList(this.listeningDirs);
            ActiveLoadingFilesSizeMetricsSet.getInstance().updatePendingDirList(this.listeningDirs);
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred during hot reload active load dirs. Current active load listening dirs: {}.", this.listeningDirs, (Object)e);
        }
    }

    private void createDirectoriesIfNotExists(String dirPath) {
        try {
            FileUtils.forceMkdir((File)new File(dirPath));
        }
        catch (IOException e) {
            LOGGER.warn("Error occurred during creating directory {} for active load.", (Object)dirPath, (Object)e);
        }
    }

    private static String getTsFilePath(String filePathWithResourceOrModsTail) {
        return filePathWithResourceOrModsTail.endsWith(RESOURCE) ? filePathWithResourceOrModsTail.substring(0, filePathWithResourceOrModsTail.length() - RESOURCE.length()) : filePathWithResourceOrModsTail.substring(0, filePathWithResourceOrModsTail.length() - MODS.length());
    }

    public long countAndReportActiveListeningDirsFileNumber() {
        long totalFileCount = 0L;
        long totalFileSize = 0L;
        try {
            for (String dir : this.listeningDirs) {
                final long[] fileCountInDir = new long[]{0L};
                final long[] fileSizeInDir = new long[]{0L};
                Files.walkFileTree(new File(dir).toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        fileCountInDir[0] = fileCountInDir[0] + 1L;
                        try {
                            fileSizeInDir[0] = fileSizeInDir[0] + file.toFile().length();
                        }
                        catch (Exception e) {
                            LOGGER.debug("Failed to count active listening dirs file number.", (Throwable)e);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                ActiveLoadingFilesNumberMetricsSet.getInstance().updatePendingFileCounterInDir(dir, fileCountInDir[0]);
                ActiveLoadingFilesSizeMetricsSet.getInstance().updatePendingFileCounterInDir(dir, fileSizeInDir[0]);
                totalFileCount += fileCountInDir[0];
                totalFileSize += fileSizeInDir[0];
            }
            ActiveLoadingFilesNumberMetricsSet.getInstance().updateTotalPendingFileCounter(totalFileCount);
            ActiveLoadingFilesSizeMetricsSet.getInstance().updateTotalPendingFileCounter(totalFileSize);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to count active listening dirs file number.", (Throwable)e);
        }
        return totalFileCount;
    }
}

